/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PageDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.CustomModelDefinitionImpl;
import org.alfresco.repo.dictionary.CustomModelsInfo;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryDAOImpl;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.dictionary.RepositoryLocation;
import org.alfresco.repo.download.DownloadModel;
import org.alfresco.repo.download.DownloadStorage;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.CustomModelDefinition;
import org.alfresco.service.cmr.dictionary.CustomModelException;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.download.DownloadService;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.XMLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CustomModelServiceImpl
implements CustomModelService {
    private static final Log logger = LogFactory.getLog(CustomModelServiceImpl.class);
    public static final String DEFAULT_CUSTOM_MODEL_ASPECT = "hasAspect('cmm:customModelManagement')";
    public static final QName ASPECT_CUSTOM_MODEL = QName.createQName((String)"http://www.alfresco.org/model/custommodelmanagement/1.0", (String)"customModelManagement");
    public static final String ALFRESCO_MODEL_ADMINISTRATORS_AUTHORITY = "ALFRESCO_MODEL_ADMINISTRATORS";
    public static final String GROUP_ALFRESCO_MODEL_ADMINISTRATORS_AUTHORITY = "GROUP_ALFRESCO_MODEL_ADMINISTRATORS";
    public static final String SHARE_EXT_MODULE_SUFFIX = "_module.xml";
    private static final String MSG_NAME_ALREADY_IN_USE = "cmm.service.name_already_in_use";
    private static final String MSG_CREATE_MODEL_ERR = "cmm.service.create_model_err";
    private static final String MSG_UPDATE_MODEL_ERR = "cmm.service.update_model_err";
    private static final String MSG_MULTIPLE_MODELS = "cmm.service.multiple_models";
    private static final String MSG_RETRIEVE_MODEL = "cmm.service.retrieve_model";
    private static final String MSG_MODEL_NOT_EXISTS = "cmm.service.model_not_exists";
    private static final String MSG_NAMESPACE_NOT_EXISTS = "cmm.service.namespace_not_exists";
    private static final String MSG_NAMESPACE_MANY_EXIST = "cmm.service.namespace_many_exist";
    private static final String MSG_NAMESPACE_URI_ALREADY_IN_USE = "cmm.service.namespace_uri_already_in_use";
    private static final String MSG_NAMESPACE_PREFIX_ALREADY_IN_USE = "cmm.service.namespace_prefix_already_in_use";
    private static final String MSG_UNABLE_DELETE_ACTIVE_MODEL = "cmm.service.unable_delete_active_model";
    private static final String MSG_UNABLE_MODEL_DELETE = "cmm.service.unable_model_delete";
    private static final String MSG_UNABLE_MODEL_DEACTIVATE = "cmm.service.unable_model_deactivate";
    private static final String MSG_UNABLE_MODEL_ACTIVATE = "cmm.service.unable_model_activate";
    private static final String MSG_INVALID_MODEL = "cmm.service.invalid_model";
    private static final String MSG_NAMESPACE_ACTIVE_MODEL = "cmm.service.namespace_active_model";
    private static final String MSG_FAILED_DEACTIVATION_TYPE_DEPENDENCY = "cmm.service.failed.deactivation.type.dependency";
    private static final String MSG_FAILED_DEACTIVATION_ASPECT_DEPENDENCY = "cmm.service.failed.deactivation.aspect.dependency";
    private static final String MSG_DOWNLOAD_COPY_MODEL_ERR = "cmm.service.download.create_model_copy_err";
    private static final String MSG_DOWNLOAD_CREATE_SHARE_EXT_ERR = "cmm.service.download.create_share_ext_err";
    private NodeService nodeService;
    private DictionaryDAOImpl dictionaryDAO;
    private ContentService contentService;
    private SearchService searchService;
    private RepositoryLocation repoModelsLocation;
    private NamespaceDAO namespaceDAO;
    private DictionaryService dictionaryService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private RepoAdminService repoAdminService;
    private AuthorityService authorityService;
    private HiddenAspect hiddenAspect;
    private DownloadService downloadService;
    private DownloadStorage downloadStorage;
    private String shareExtModulePath;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryDAO(DictionaryDAOImpl dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setRepositoryModelsLocation(RepositoryLocation repoModelsLocation) {
        this.repoModelsLocation = repoModelsLocation;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceDAO(NamespaceDAO namespaceDAO) {
        this.namespaceDAO = namespaceDAO;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setDownloadService(DownloadService downloadSerivce) {
        this.downloadService = downloadSerivce;
    }

    public void setDownloadStorage(DownloadStorage downloadStorage) {
        this.downloadStorage = downloadStorage;
    }

    public void setShareExtModulePath(String shareExtModulePath) {
        this.shareExtModulePath = shareExtModulePath;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryDAO", (Object)this.dictionaryDAO);
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"repoModelsLocation", (Object)this.repoModelsLocation);
        PropertyCheck.mandatory((Object)this, (String)"namespaceDAO", (Object)this.namespaceDAO);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"retryingTransactionHelper", (Object)this.retryingTransactionHelper);
        PropertyCheck.mandatory((Object)this, (String)"repoAdminService", (Object)this.repoAdminService);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"hiddenAspect", (Object)this.hiddenAspect);
        PropertyCheck.mandatory((Object)this, (String)"shareExtModulePath", (Object)this.shareExtModulePath);
        PropertyCheck.mandatory((Object)this, (String)"downloadService", (Object)this.downloadService);
        PropertyCheck.mandatory((Object)this, (String)"downloadStorage", (Object)this.downloadStorage);
    }

    private NodeRef getRootNode() {
        StoreRef storeRef = this.repoModelsLocation.getStoreRef();
        return this.nodeService.getRootNode(storeRef);
    }

    public NodeRef getModelNodeRef(String modelName) {
        ParameterCheck.mandatoryString((String)"modelName", (String)modelName);
        StringBuilder builder = new StringBuilder(120);
        builder.append(this.repoModelsLocation.getPath()).append("//.[@cm:name='").append(modelName).append("' and ").append("subtypeOf('cm:dictionaryModel')").append(']');
        List nodeRefs = this.searchService.selectNodes(this.getRootNode(), builder.toString(), null, (NamespacePrefixResolver)this.namespaceDAO, false);
        if (nodeRefs.size() == 0) {
            return null;
        }
        if (nodeRefs.size() > 1) {
            throw new CustomModelException(MSG_MULTIPLE_MODELS, new Object[]{modelName});
        }
        return (NodeRef)nodeRefs.get(0);
    }

    public M2Model getM2Model(NodeRef modelNodeRef) {
        M2Model m2Model;
        block8: {
            ContentReader reader = this.contentService.getReader(modelNodeRef, ContentModel.PROP_CONTENT);
            if (reader == null) {
                return null;
            }
            InputStream in = reader.getContentInputStream();
            try {
                m2Model = M2Model.createModel((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        logger.error((Object)("Failed to close input stream for " + String.valueOf(modelNodeRef)));
                    }
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                logger.error((Object)("Failed to close input stream for " + String.valueOf(modelNodeRef)));
            }
        }
        return m2Model;
    }

    public CustomModelDefinition getCustomModel(String modelName) {
        ParameterCheck.mandatoryString((String)"modelName", (String)modelName);
        Pair<CompiledModel, Boolean> compiledModelPair = this.getCustomCompiledModel(modelName);
        CustomModelDefinitionImpl result = compiledModelPair == null ? null : new CustomModelDefinitionImpl((CompiledModel)compiledModelPair.getFirst(), ((Boolean)compiledModelPair.getSecond()).booleanValue(), (MessageLookup)this.dictionaryService);
        return result;
    }

    public ModelDefinition getCustomModelByUri(String namespaceUri) {
        ParameterCheck.mandatoryString((String)"namespaceUri", (String)namespaceUri);
        CompiledModel compiledModel = this.getModelByUri(namespaceUri);
        if (compiledModel != null) {
            return compiledModel.getModelDefinition();
        }
        return null;
    }

    private CompiledModel getModelByUri(String uri) {
        for (CompiledModel model : this.getAllCustomM2Models(false)) {
            if (!uri.equals(this.getModelNamespaceUriPrefix(model.getM2Model()).getFirst())) continue;
            return model;
        }
        return null;
    }

    protected Pair<CompiledModel, Boolean> getCustomCompiledModel(String modelName) {
        ParameterCheck.mandatoryString((String)"modelName", (String)modelName);
        NodeRef modelNodeRef = this.getModelNodeRef(modelName);
        if (modelNodeRef == null || !this.nodeService.exists(modelNodeRef)) {
            return null;
        }
        M2Model model = null;
        boolean isActive = Boolean.TRUE.equals(this.nodeService.getProperty(modelNodeRef, ContentModel.PROP_MODEL_ACTIVE));
        if (isActive) {
            QName modelQName = (QName)this.nodeService.getProperty(modelNodeRef, ContentModel.PROP_MODEL_NAME);
            if (modelQName == null) {
                return null;
            }
            try {
                CompiledModel compiledModel = this.dictionaryDAO.getCompiledModel(modelQName);
                model = compiledModel.getM2Model();
            }
            catch (Exception e) {
                throw new CustomModelException(MSG_RETRIEVE_MODEL, new Object[]{modelName}, (Throwable)e);
            }
        } else {
            model = this.getM2Model(modelNodeRef);
        }
        Pair result = model == null ? null : new Pair((Object)this.compileModel(model), (Object)isActive);
        return result;
    }

    public PagingResults<CustomModelDefinition> getCustomModels(PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        List<CustomModelDefinition> result = this.getAllCustomModels();
        return result.isEmpty() ? new PagingResults<CustomModelDefinition>() : this.wrapResult(pagingRequest, result);
    }

    protected List<CustomModelDefinition> getAllCustomModels() {
        ArrayList<CustomModelDefinition> result = new ArrayList<CustomModelDefinition>();
        Collection models = this.dictionaryDAO.getModels(true);
        ArrayList<String> dictionaryModels = new ArrayList<String>();
        for (QName model : models) {
            dictionaryModels.add(model.toPrefixString());
        }
        List<CompiledModel> compiledModels = this.getAllCustomM2Models(false);
        if (compiledModels.size() > 0) {
            for (CompiledModel model : compiledModels) {
                boolean isActive = false;
                if (dictionaryModels.contains(model.getM2Model().getName())) {
                    isActive = true;
                }
                result.add((CustomModelDefinition)new CustomModelDefinitionImpl(model, isActive, (MessageLookup)this.dictionaryService));
            }
        }
        return result;
    }

    private List<CompiledModel> getAllCustomM2Models(boolean onlyInactiveModels) {
        ArrayList<CompiledModel> result = new ArrayList<CompiledModel>();
        StringBuilder builder = new StringBuilder(160);
        builder.append(this.repoModelsLocation.getPath()).append("/*").append("[(").append("subtypeOf('cm:dictionaryModel')").append(" and ").append(DEFAULT_CUSTOM_MODEL_ASPECT);
        if (onlyInactiveModels) {
            builder.append(" and @cm:modelActive='false'");
        }
        builder.append(")]");
        List nodeRefs = this.searchService.selectNodes(this.getRootNode(), builder.toString(), null, (NamespacePrefixResolver)this.namespaceDAO, false, "xpath");
        if (nodeRefs.size() > 0) {
            for (NodeRef nodeRef : nodeRefs) {
                try {
                    M2Model m2Model = this.getM2Model(nodeRef);
                    if (m2Model == null) {
                        logger.warn((Object)("Couldn't construct M2Model from nodeRef:" + String.valueOf(nodeRef)));
                        continue;
                    }
                    result.add(this.compileModel(m2Model));
                }
                catch (Throwable t) {
                    logger.warn((Object)("Skip model (" + t.getMessage() + ")"));
                }
            }
        }
        return result;
    }

    public AspectDefinition getCustomAspect(QName name) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        CompiledModel compiledModel = this.getModelByUri(name.getNamespaceURI());
        if (compiledModel != null) {
            return compiledModel.getAspect(name);
        }
        return null;
    }

    public PagingResults<AspectDefinition> getAllCustomAspects(PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        ArrayList result = new ArrayList();
        List<CompiledModel> list = this.getAllCustomM2Models(false);
        for (CompiledModel model : list) {
            result.addAll(model.getAspects());
        }
        return this.wrapResult(pagingRequest, result);
    }

    public TypeDefinition getCustomType(QName name) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        CompiledModel compiledModel = this.getModelByUri(name.getNamespaceURI());
        if (compiledModel != null) {
            return compiledModel.getType(name);
        }
        return null;
    }

    public PagingResults<TypeDefinition> getAllCustomTypes(PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        ArrayList result = new ArrayList();
        List<CompiledModel> list = this.getAllCustomM2Models(false);
        for (CompiledModel model : list) {
            result.addAll(model.getTypes());
        }
        return this.wrapResult(pagingRequest, result);
    }

    public ConstraintDefinition getCustomConstraint(QName name) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        CompiledModel compiledModel = this.getModelByUri(name.getNamespaceURI());
        if (compiledModel != null) {
            return compiledModel.getConstraint(name);
        }
        return null;
    }

    public CustomModelDefinition createCustomModel(M2Model m2Model, boolean activate) {
        String modelFileName;
        ParameterCheck.mandatory((String)"m2Model", (Object)m2Model);
        String modelName = m2Model.getName();
        int colonIndex = modelName.indexOf(58);
        String string = modelFileName = colonIndex == -1 ? modelName : modelName.substring(colonIndex + 1);
        if (this.isModelExists(modelFileName)) {
            throw new CustomModelException.ModelExistsException(MSG_NAME_ALREADY_IN_USE, new Object[]{modelFileName});
        }
        this.validateModelNamespaceUri((String)this.getModelNamespaceUriPrefix(m2Model).getFirst());
        this.validateModelNamespacePrefix((String)this.getModelNamespaceUriPrefix(m2Model).getSecond());
        CompiledModel compiledModel = this.createUpdateModel(modelFileName, m2Model, activate, MSG_CREATE_MODEL_ERR, false);
        CustomModelDefinitionImpl modelDef = new CustomModelDefinitionImpl(compiledModel, activate, (MessageLookup)this.dictionaryService);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(modelFileName + " model has been created."));
        }
        return modelDef;
    }

    public CustomModelDefinition updateCustomModel(String modelFileName, M2Model m2Model, boolean activate) {
        ParameterCheck.mandatory((String)"m2Model", (Object)m2Model);
        NodeRef existingModelNodeRef = this.getModelNodeRef(modelFileName);
        if (existingModelNodeRef == null) {
            throw new CustomModelException.ModelDoesNotExistException(MSG_MODEL_NOT_EXISTS, new Object[]{modelFileName});
        }
        boolean isActive = Boolean.TRUE.equals(this.nodeService.getProperty(existingModelNodeRef, ContentModel.PROP_MODEL_ACTIVE));
        M2Model existingModel = this.getM2Model(existingModelNodeRef);
        Pair<String, String> existingNamespacePair = this.getModelNamespaceUriPrefix(existingModel);
        Pair<String, String> newNamespacePair = this.getModelNamespaceUriPrefix(m2Model);
        if (isActive && !existingNamespacePair.equals(newNamespacePair)) {
            throw new CustomModelException.ActiveModelConstraintException(MSG_NAMESPACE_ACTIVE_MODEL);
        }
        if (!((String)existingNamespacePair.getSecond()).equals(newNamespacePair.getSecond())) {
            this.validateModelNamespacePrefix((String)newNamespacePair.getSecond());
        }
        if (!((String)existingNamespacePair.getFirst()).equals(newNamespacePair.getFirst())) {
            this.validateModelNamespaceUri((String)newNamespacePair.getFirst());
        }
        CompiledModel compiledModel = this.createUpdateModel(modelFileName, m2Model, activate, MSG_UPDATE_MODEL_ERR, true);
        CustomModelDefinitionImpl modelDef = new CustomModelDefinitionImpl(compiledModel, activate, (MessageLookup)this.dictionaryService);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(modelFileName + " model has been updated."));
        }
        return modelDef;
    }

    private CompiledModel createUpdateModel(final String modelFileName, M2Model m2Model, final boolean activate, String errMsgId, boolean requiresNewTx) {
        CompiledModel compiledModel = this.compileModel(m2Model);
        this.validatePropsDefaultValues(compiledModel);
        ByteArrayOutputStream xml = new ByteArrayOutputStream();
        m2Model.toXML((OutputStream)xml);
        final ByteArrayInputStream modelStream = new ByteArrayInputStream(xml.toByteArray());
        NodeRef nodeRef = this.doInTransaction(errMsgId, requiresNewTx, new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                return CustomModelServiceImpl.this.repoAdminService.deployModel(modelStream, modelFileName, activate);
            }
        });
        if (!this.nodeService.hasAspect(nodeRef, ASPECT_CUSTOM_MODEL)) {
            this.nodeService.addAspect(nodeRef, ASPECT_CUSTOM_MODEL, null);
        }
        if (!this.hiddenAspect.hasHiddenAspect(nodeRef)) {
            this.hiddenAspect.hideNode(nodeRef, false, false, false);
        }
        return compiledModel;
    }

    private void validatePropsDefaultValues(CompiledModel compiledModel) {
        for (PropertyDefinition propertyDef : compiledModel.getProperties()) {
            if (propertyDef.getDefaultValue() == null || propertyDef.getConstraints().size() <= 0) continue;
            for (ConstraintDefinition constraintDef : propertyDef.getConstraints()) {
                Constraint constraint = constraintDef.getConstraint();
                try {
                    constraint.evaluate((Object)propertyDef.getDefaultValue());
                }
                catch (AlfrescoRuntimeException ex) {
                    String message = CustomModelServiceImpl.getRootCauseMsg(ex, false, "cmm.service.constraint.default_prop_value_err");
                    throw new CustomModelException.CustomModelConstraintException(message);
                }
            }
        }
    }

    public CompiledModel compileModel(M2Model m2Model) {
        try {
            return m2Model.compile((DictionaryDAO)this.dictionaryDAO, this.namespaceDAO, true);
        }
        catch (Exception ex) {
            AlfrescoRuntimeException alf = null;
            alf = ex instanceof AlfrescoRuntimeException ? (AlfrescoRuntimeException)((Object)ex) : AlfrescoRuntimeException.create((Throwable)ex, (String)ex.getMessage(), (Object[])new Object[0]);
            Throwable cause = alf.getRootCause();
            String message = null;
            if (cause instanceof DictionaryException.DuplicateDefinitionException) {
                message = CustomModelServiceImpl.getRootCauseMsg(cause, false, MSG_INVALID_MODEL);
                throw new CustomModelException.CustomModelConstraintException(message);
            }
            message = CustomModelServiceImpl.getRootCauseMsg(cause, true, null);
            throw new CustomModelException.InvalidCustomModelException(MSG_INVALID_MODEL, new Object[]{message}, (Throwable)ex);
        }
    }

    protected <T> PagingResults<T> wrapResult(PagingRequest pagingRequest, List<T> result) {
        final int totalSize = result.size();
        final PageDetails pageDetails = PageDetails.getPageDetails((PagingRequest)pagingRequest, (int)totalSize);
        final ArrayList<T> page = new ArrayList<T>(pageDetails.getPageSize());
        Iterator<T> it = result.iterator();
        int counter = 0;
        while (counter < pageDetails.getEnd() && it.hasNext()) {
            T element = it.next();
            if (counter >= pageDetails.getSkipCount()) {
                if (counter > pageDetails.getEnd() - 1) break;
                page.add(element);
            }
            ++counter;
        }
        return new PagingResults<T>(){

            public List<T> getPage() {
                return page;
            }

            public boolean hasMoreItems() {
                return pageDetails.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                Integer total = totalSize;
                return new Pair((Object)total, (Object)total);
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }

    public boolean isModelAdmin(String userName) {
        if (userName == null) {
            return false;
        }
        return this.authorityService.isAdminAuthority(userName) || this.authorityService.getAuthoritiesForUser(userName).contains(GROUP_ALFRESCO_MODEL_ADMINISTRATORS_AUTHORITY);
    }

    public void activateCustomModel(String modelName) {
        try {
            this.repoAdminService.activateModel(modelName);
        }
        catch (Exception ex) {
            throw new CustomModelException(MSG_UNABLE_MODEL_ACTIVATE, new Object[]{modelName}, (Throwable)ex);
        }
    }

    public void deactivateCustomModel(final String modelName) {
        CustomModelDefinition customModelDefinition = this.getCustomModel(modelName);
        if (customModelDefinition == null) {
            throw new CustomModelException.ModelDoesNotExistException(MSG_MODEL_NOT_EXISTS, new Object[]{modelName});
        }
        Collection modelTypes = customModelDefinition.getTypeDefinitions();
        Collection modelAspects = customModelDefinition.getAspectDefinitions();
        for (CompiledModel cm : this.getAllCustomM2Models(false)) {
            if (customModelDefinition.getName().equals((Object)cm.getModelDefinition().getName())) continue;
            this.validateTypeAspectDependency(modelTypes, cm.getTypes());
            this.validateTypeAspectDependency(modelAspects, cm.getAspects());
        }
        this.doInTransaction(MSG_UNABLE_MODEL_DEACTIVATE, true, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Exception {
                CustomModelServiceImpl.this.repoAdminService.deactivateModel(modelName);
                return null;
            }
        });
    }

    private void validateTypeAspectDependency(Collection<? extends ClassDefinition> parentDefs, Collection<? extends ClassDefinition> childDefs) {
        for (ClassDefinition classDefinition : parentDefs) {
            for (ClassDefinition classDefinition2 : childDefs) {
                if (!classDefinition.getName().equals((Object)classDefinition2.getParentName())) continue;
                Object[] msgParams = new Object[]{classDefinition.getName().toPrefixString(), classDefinition2.getName().toPrefixString(), classDefinition2.getModel().getName().getLocalName()};
                if (classDefinition instanceof TypeDefinition) {
                    throw new CustomModelException.CustomModelConstraintException(MSG_FAILED_DEACTIVATION_TYPE_DEPENDENCY, msgParams);
                }
                throw new CustomModelException.CustomModelConstraintException(MSG_FAILED_DEACTIVATION_ASPECT_DEPENDENCY, msgParams);
            }
        }
    }

    public void deleteCustomModel(String modelName) {
        NodeRef nodeRef = this.getModelNodeRef(modelName);
        if (nodeRef == null) {
            throw new CustomModelException.ModelDoesNotExistException(MSG_MODEL_NOT_EXISTS, new Object[]{modelName});
        }
        boolean isActive = Boolean.TRUE.equals(this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODEL_ACTIVE));
        if (isActive) {
            throw new CustomModelException.ActiveModelConstraintException(MSG_UNABLE_DELETE_ACTIVE_MODEL);
        }
        try {
            this.repoAdminService.undeployModel(modelName);
        }
        catch (Exception ex) {
            throw new CustomModelException(MSG_UNABLE_MODEL_DELETE, new Object[]{modelName}, (Throwable)ex);
        }
    }

    public boolean isNamespaceUriExists(String modelNamespaceUri) {
        ParameterCheck.mandatoryString((String)"modelNamespaceUri", (String)modelNamespaceUri);
        Collection uris = this.namespaceDAO.getURIs();
        if (uris.contains(modelNamespaceUri)) {
            return true;
        }
        for (CompiledModel model : this.getAllCustomM2Models(false)) {
            if (!modelNamespaceUri.equals(this.getModelNamespaceUriPrefix(model.getM2Model()).getFirst())) continue;
            return true;
        }
        return false;
    }

    public boolean isNamespacePrefixExists(String modelNamespacePrefix) {
        ParameterCheck.mandatoryString((String)"modelNamespacePrefix", (String)modelNamespacePrefix);
        Collection prefixes = this.namespaceDAO.getPrefixes();
        if (prefixes.contains(modelNamespacePrefix)) {
            return true;
        }
        for (CompiledModel model : this.getAllCustomM2Models(false)) {
            if (!modelNamespacePrefix.equals(this.getModelNamespaceUriPrefix(model.getM2Model()).getSecond())) continue;
            return true;
        }
        return false;
    }

    public boolean isNamespacePrefixExists(NodeRef modelNodeRef) {
        Collection uris;
        ParameterCheck.mandatoryString((String)"modelNodeRef", (String)modelNodeRef.toString());
        M2Model m2Model = this.getM2Model(modelNodeRef);
        String modelNamespacePrefix = (String)this.getModelNamespaceUriPrefix(m2Model).getSecond();
        String modelNamespaceUri = (String)this.getModelNamespaceUriPrefix(m2Model).getFirst();
        Collection prefixes = this.namespaceDAO.getPrefixes();
        if (prefixes.contains(modelNamespacePrefix) && !(uris = this.namespaceDAO.getURIs()).contains(modelNamespaceUri)) {
            return true;
        }
        for (CompiledModel model : this.getAllCustomM2Models(false)) {
            NodeRef existingModelNodeRef;
            M2Model existingModel = model.getM2Model();
            String existingPrefix = (String)this.getModelNamespaceUriPrefix(existingModel).getSecond();
            if (!modelNamespacePrefix.equals(existingPrefix) || modelNodeRef.equals((Object)(existingModelNodeRef = this.getModelNodeRef(model.getModelDefinition().getName().getLocalName())))) continue;
            return true;
        }
        return false;
    }

    public boolean isModelExists(String modelFileName) {
        NodeRef nodeRef = this.getModelNodeRef(modelFileName);
        if (nodeRef != null) {
            return true;
        }
        for (QName qname : this.dictionaryService.getAllModels()) {
            if (!qname.getLocalName().equalsIgnoreCase(modelFileName)) continue;
            return true;
        }
        return false;
    }

    public Pair<String, String> getModelNamespaceUriPrefix(M2Model model) {
        ParameterCheck.mandatory((String)"model", (Object)model);
        List namespaces = model.getNamespaces();
        if (namespaces.isEmpty()) {
            throw new CustomModelException.InvalidNamespaceException(MSG_NAMESPACE_NOT_EXISTS, new Object[]{model.getName()});
        }
        if (namespaces.size() > 1) {
            throw new CustomModelException.InvalidNamespaceException(MSG_NAMESPACE_MANY_EXIST, new Object[]{model.getName()});
        }
        M2Namespace ns = (M2Namespace)namespaces.iterator().next();
        return new Pair((Object)ns.getUri(), (Object)ns.getPrefix());
    }

    private void validateModelNamespaceUri(String uri) {
        if (this.isNamespaceUriExists(uri)) {
            throw new CustomModelException.NamespaceConstraintException(MSG_NAMESPACE_URI_ALREADY_IN_USE, new Object[]{uri});
        }
    }

    public void validateModelNamespacePrefix(String prefix) {
        if (this.isNamespacePrefixExists(prefix)) {
            throw new CustomModelException.NamespaceConstraintException(MSG_NAMESPACE_PREFIX_ALREADY_IN_USE, new Object[]{prefix});
        }
    }

    public void validateModelNamespacePrefix(NodeRef modelNodeRef) {
        if (this.isNamespacePrefixExists(modelNodeRef)) {
            M2Model m2Model = this.getM2Model(modelNodeRef);
            String prefix = (String)this.getModelNamespaceUriPrefix(m2Model).getSecond();
            throw new CustomModelException.NamespaceConstraintException(MSG_NAMESPACE_PREFIX_ALREADY_IN_USE, new Object[]{prefix});
        }
    }

    private <R> R doInTransaction(String errMsgId, boolean requiresNewTx, RetryingTransactionHelper.RetryingTransactionCallback<R> cb) {
        try {
            return this.retryingTransactionHelper.doInTransaction(cb, false, requiresNewTx);
        }
        catch (Exception ex) {
            AlfrescoRuntimeException alf = null;
            alf = ex instanceof AlfrescoRuntimeException ? (AlfrescoRuntimeException)((Object)ex) : AlfrescoRuntimeException.create((Throwable)ex, (String)ex.getMessage(), (Object[])new Object[0]);
            Throwable cause = alf.getRootCause();
            String message = CustomModelServiceImpl.getRootCauseMsg(cause, true, null);
            throw new CustomModelException(errMsgId, new Object[]{message}, (Throwable)ex);
        }
    }

    private static String getRootCauseMsg(Throwable cause, boolean withAlfLogNum, String defaultMsg) {
        String message;
        if (defaultMsg == null) {
            defaultMsg = "";
        }
        if ((message = cause.getMessage()) == null) {
            return defaultMsg;
        }
        return withAlfLogNum ? message : message.replaceFirst("\\d+", "").trim();
    }

    public NodeRef createDownloadNode(String modelFileName, boolean withAssociatedForm) {
        return this.createDownloadNode(modelFileName, withAssociatedForm, null);
    }

    public NodeRef createDownloadNode(String modelFileName, boolean withAssociatedForm, String downloadNodeName) {
        StringBuilder msg;
        ArrayList<NodeRef> nodesToBeDownloaded = new ArrayList<NodeRef>(2);
        NodeRef customModelNodeRef = this.getModelNodeRef(modelFileName);
        if (customModelNodeRef == null) {
            throw new CustomModelException.ModelDoesNotExistException(MSG_MODEL_NOT_EXISTS, new Object[]{modelFileName});
        }
        customModelNodeRef = this.createCustomModelCopy(modelFileName + ".xml", customModelNodeRef);
        nodesToBeDownloaded.add(customModelNodeRef);
        if (withAssociatedForm) {
            NodeRef shareExtModuleNodeRef = null;
            try {
                shareExtModuleNodeRef = this.createCustomModelShareExtModuleRef(modelFileName);
                nodesToBeDownloaded.add(shareExtModuleNodeRef);
                if (logger.isDebugEnabled()) {
                    msg = new StringBuilder();
                    msg.append("Temp nodes created for download: Custom model nodeRef [").append(customModelNodeRef).append("] and its associated Share form nodeRef [").append(shareExtModuleNodeRef).append(']');
                    logger.debug((Object)msg.toString());
                }
            }
            catch (CustomModelException ex) {
                StringBuilder msg2 = new StringBuilder();
                msg2.append("Constructing CMM zip file containing only the model [").append(modelFileName).append(".xml] without its associated share extension module, because: ").append(ex.getMessage());
                logger.warn((Object)msg2.toString());
            }
        } else if (logger.isDebugEnabled()) {
            StringBuilder msg3 = new StringBuilder();
            msg3.append("Temp node created for download: Custom model nodeRef [").append(customModelNodeRef).append(']');
            logger.debug((Object)msg3.toString());
        }
        try {
            NodeRef archiveNodeRef = this.downloadService.createDownload(nodesToBeDownloaded.toArray(new NodeRef[0]), false, downloadNodeName);
            if (logger.isDebugEnabled()) {
                msg = new StringBuilder();
                msg.append("Created download nodeRef [").append(archiveNodeRef).append(']');
                logger.debug((Object)msg.toString());
            }
            return archiveNodeRef;
        }
        catch (Exception ex) {
            throw new CustomModelException("cmm.service.download.create_err", (Throwable)ex);
        }
    }

    protected NodeRef createCustomModelShareExtModuleRef(String modelName) {
        final String moduleId = "CMM_" + modelName;
        NodeRef formNodeRef = this.getShareExtModule();
        ContentReader reader = this.contentService.getReader(formNodeRef, ContentModel.PROP_CONTENT);
        if (reader == null) {
            throw new CustomModelException("cmm.service.download.share_ext_node_read_err");
        }
        InputStream in = reader.getContentInputStream();
        Node moduleIdXmlNode = null;
        try {
            Document document = XMLUtil.parse(in);
            String xpathQuery = "/extension//modules//module//id[.= '" + moduleId + "']";
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPathExpression expression = xPath.compile(xpathQuery);
            moduleIdXmlNode = (Node)expression.evaluate(document, XPathConstants.NODE);
        }
        catch (Exception ex) {
            throw new CustomModelException("cmm.service.download.share_ext_file_parse_err", (Throwable)ex);
        }
        if (moduleIdXmlNode == null) {
            throw new CustomModelException("cmm.service.download.share_ext_module_not_found", new Object[]{moduleId});
        }
        final File moduleFile = TempFileProvider.createTempFile((String)moduleId, (String)".xml");
        try {
            XMLUtil.print(moduleIdXmlNode.getParentNode(), moduleFile);
        }
        catch (IOException error) {
            throw new CustomModelException("cmm.service.download.share_ext_write_err", new Object[]{moduleId}, (Throwable)error);
        }
        return this.doInTransaction(MSG_DOWNLOAD_CREATE_SHARE_EXT_ERR, true, new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                NodeRef nodeRef = CustomModelServiceImpl.this.createDownloadTypeNode(moduleId + CustomModelServiceImpl.SHARE_EXT_MODULE_SUFFIX);
                ContentWriter writer = CustomModelServiceImpl.this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/xml");
                writer.setEncoding("UTF-8");
                writer.putContent(moduleFile);
                return nodeRef;
            }
        });
    }

    protected NodeRef getShareExtModule() {
        List results = this.searchService.selectNodes(this.getRootNode(), this.shareExtModulePath, null, (NamespacePrefixResolver)this.namespaceDAO, false, "xpath");
        if (results.isEmpty()) {
            throw new CustomModelException("cmm.service.download.share_ext_file_not_found");
        }
        return (NodeRef)results.get(0);
    }

    protected NodeRef createCustomModelCopy(final String newName, final NodeRef modelNodeRef) {
        return this.doInTransaction(MSG_DOWNLOAD_COPY_MODEL_ERR, true, new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Exception {
                NodeRef newNodeRef = CustomModelServiceImpl.this.createDownloadTypeNode(newName);
                Serializable content = CustomModelServiceImpl.this.nodeService.getProperty(modelNodeRef, ContentModel.PROP_CONTENT);
                CustomModelServiceImpl.this.nodeService.setProperty(newNodeRef, ContentModel.PROP_CONTENT, content);
                return newNodeRef;
            }
        });
    }

    private NodeRef createDownloadTypeNode(String name) {
        NodeRef newNodeRef = this.nodeService.createNode(this.downloadStorage.getOrCreateDowloadContainer(), ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, DownloadModel.TYPE_DOWNLOAD, Collections.singletonMap(ContentModel.PROP_NAME, name)).getChildRef();
        HashMap<QName, Boolean> aspectProperties = new HashMap<QName, Boolean>(2);
        aspectProperties.put(ContentModel.PROP_IS_INDEXED, Boolean.FALSE);
        aspectProperties.put(ContentModel.PROP_IS_CONTENT_INDEXED, Boolean.FALSE);
        this.nodeService.addAspect(newNodeRef, ContentModel.ASPECT_INDEX_CONTROL, aspectProperties);
        return newNodeRef;
    }

    public CustomModelsInfo getCustomModelsInfo() {
        List page = this.getCustomModels(new PagingRequest(0, Integer.MAX_VALUE)).getPage();
        int activeModels = 0;
        int activeTypes = 0;
        int activeAspects = 0;
        for (CustomModelDefinition cm : page) {
            if (!cm.isActive()) continue;
            ++activeModels;
            activeTypes += cm.getTypeDefinitions().size();
            activeAspects += cm.getAspectDefinitions().size();
        }
        CustomModelsInfo info = new CustomModelsInfo();
        info.setNumberOfActiveModels(activeModels);
        info.setNumberOfActiveTypes(activeTypes);
        info.setNumberOfActiveAspects(activeAspects);
        return info;
    }
}

