/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.node.ParentAssocsInfo;
import org.alfresco.util.Pair;

class ParentAssocsCache {
    private final Cache<Pair<Long, String>, ParentAssocsInfo> cache;

    ParentAssocsCache(int size, int limitFactor, int concurrencyLevel) {
        int maxParentCount = size * limitFactor;
        this.cache = CacheBuilder.newBuilder().maximumWeight((long)maxParentCount).concurrencyLevel(concurrencyLevel).weigher((key, value) -> {
            Integer parentAssocsSize = Optional.ofNullable(value).map(ParentAssocsInfo::getParentAssocs).map(Map::size).orElse(1);
            return Math.max(1, parentAssocsSize);
        }).build();
    }

    ParentAssocsInfo get(Pair<Long, String> cacheKey) {
        return (ParentAssocsInfo)this.cache.getIfPresent(cacheKey);
    }

    ParentAssocsInfo get(Pair<Long, String> cacheKey, Callable<ParentAssocsInfo> valueLoader) {
        try {
            return (ParentAssocsInfo)this.cache.get(cacheKey, valueLoader);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to load parent associations", (Throwable)e);
        }
    }

    void put(Pair<Long, String> cacheKey, ParentAssocsInfo parentAssocs) {
        this.cache.put(cacheKey, (Object)parentAssocs);
    }

    ParentAssocsInfo remove(Pair<Long, String> cacheKey) {
        ParentAssocsInfo old = (ParentAssocsInfo)this.cache.getIfPresent(cacheKey);
        if (old != null) {
            this.cache.invalidate(cacheKey);
        }
        return old;
    }

    void clear() {
        this.cache.invalidateAll();
    }
}

