/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.PeerAssociationResource;
import org.alfresco.repo.event2.EventConsolidator;
import org.alfresco.repo.event2.NodeResourceHelper;
import org.alfresco.repo.event2.PeerAssociationEventSupportedPolicies;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.namespace.QName;

public class PeerAssociationEventConsolidator
extends EventConsolidator<AssociationRef, PeerAssociationResource>
implements PeerAssociationEventSupportedPolicies {
    public PeerAssociationEventConsolidator(AssociationRef associationRef, NodeResourceHelper helper) {
        super(associationRef, helper);
    }

    @Override
    public void onCreateAssociation(AssociationRef associationRef) {
        this.eventTypes.add(EventType.PEER_ASSOC_CREATED);
        this.resource = this.buildPeerAssociationResource(associationRef);
    }

    @Override
    public void beforeDeleteAssociation(AssociationRef associationRef) {
        this.eventTypes.add(EventType.PEER_ASSOC_DELETED);
        this.resource = this.buildPeerAssociationResource(associationRef);
    }

    private PeerAssociationResource buildPeerAssociationResource(AssociationRef associationRef) {
        String sourceId = associationRef.getSourceRef().getId();
        String targetId = associationRef.getTargetRef().getId();
        String assocType = this.helper.getQNamePrefixString(associationRef.getTypeQName());
        return new PeerAssociationResource(sourceId, targetId, assocType);
    }

    @Override
    protected EventType getDerivedEvent() {
        if (this.isTemporaryEntity()) {
            return EventType.PEER_ASSOC_DELETED;
        }
        if (this.eventTypes.contains(EventType.PEER_ASSOC_CREATED)) {
            return EventType.PEER_ASSOC_CREATED;
        }
        if (this.eventTypes.getLast() == EventType.PEER_ASSOC_DELETED) {
            return EventType.PEER_ASSOC_DELETED;
        }
        return (EventType)this.eventTypes.getFirst();
    }

    @Override
    public boolean isTemporaryEntity() {
        return this.eventTypes.contains(EventType.PEER_ASSOC_CREATED) && this.eventTypes.getLast() == EventType.PEER_ASSOC_DELETED;
    }

    @Override
    public QName getEntityType() {
        return ((AssociationRef)this.entityReference).getTypeQName();
    }
}

