/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.util.Map;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.alfresco.repo.tenant.TenantUtil;

public class ActivitiUtil {
    private final RepositoryService repoService;
    private final RuntimeService runtimeService;
    private final HistoryService historyService;
    private final TaskService taskService;
    private final FormService formService;
    private final ManagementService managementService;
    private boolean deployWorkflowsInTenant;
    private boolean retentionHistoricProcessInstance;

    public ActivitiUtil(ProcessEngine engine, boolean deployWorkflowsInTenant) {
        this.repoService = engine.getRepositoryService();
        this.runtimeService = engine.getRuntimeService();
        this.taskService = engine.getTaskService();
        this.historyService = engine.getHistoryService();
        this.formService = engine.getFormService();
        this.managementService = engine.getManagementService();
        this.deployWorkflowsInTenant = deployWorkflowsInTenant;
    }

    public ActivitiUtil(ProcessEngine engine, boolean deployWorkflowsInTenant, boolean retentionHistoricProcessInstance) {
        this.repoService = engine.getRepositoryService();
        this.runtimeService = engine.getRuntimeService();
        this.taskService = engine.getTaskService();
        this.historyService = engine.getHistoryService();
        this.formService = engine.getFormService();
        this.managementService = engine.getManagementService();
        this.deployWorkflowsInTenant = deployWorkflowsInTenant;
        this.retentionHistoricProcessInstance = retentionHistoricProcessInstance;
    }

    public ProcessDefinition getProcessDefinition(String definitionId) {
        return (ProcessDefinition)this.repoService.createProcessDefinitionQuery().processDefinitionId(definitionId).singleResult();
    }

    public ProcessDefinition getProcessDefinitionByKey(String processKey) {
        return (ProcessDefinition)this.repoService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
    }

    public ProcessDefinition getProcessDefinitionForDeployment(String deploymentId) {
        return (ProcessDefinition)this.repoService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
    }

    public ProcessInstance getProcessInstance(String id) {
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(id).singleResult();
    }

    public Task getTaskInstance(String taskId) {
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().taskId(taskId);
        if (!this.deployWorkflowsInTenant) {
            taskQuery.processVariableValueEquals("_tenant_domain", (Object)TenantUtil.getCurrentDomain());
        }
        return (Task)taskQuery.singleResult();
    }

    public HistoricProcessInstance getHistoricProcessInstance(String id) {
        return (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(id).singleResult();
    }

    public Execution getExecution(String id) {
        return (Execution)this.runtimeService.createExecutionQuery().executionId(id).singleResult();
    }

    public ReadOnlyProcessDefinition getDeployedProcessDefinition(String processDefinitionId) {
        return ((RepositoryServiceImpl)this.repoService).getDeployedProcessDefinition(processDefinitionId);
    }

    public String getStartFormKey(String processDefinitionId) {
        ProcessDefinitionEntity procDef = (ProcessDefinitionEntity)this.getDeployedProcessDefinition(processDefinitionId);
        if (procDef.getStartFormHandler() == null) {
            return null;
        }
        return procDef.getStartFormHandler().createStartFormData(procDef).getFormKey();
    }

    public String getStartTaskTypeName(String processDefinitionId) {
        String startTaskName = null;
        StartFormData startFormData = this.formService.getStartFormData(processDefinitionId);
        if (startFormData != null) {
            startTaskName = startFormData.getFormKey();
        }
        return startTaskName;
    }

    public Map<String, Object> getExecutionVariables(String executionId) {
        return this.runtimeService.getVariables(executionId);
    }

    public FormService getFormService() {
        return this.formService;
    }

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public RepositoryService getRepositoryService() {
        return this.repoService;
    }

    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public ManagementService getManagementService() {
        return this.managementService;
    }

    public HistoricTaskInstance getHistoricTaskInstance(String localId) {
        HistoricTaskInstanceQuery taskQuery = (HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(localId);
        if (!this.deployWorkflowsInTenant) {
            taskQuery.processVariableValueEquals("_tenant_domain", (Object)TenantUtil.getCurrentDomain());
        }
        return (HistoricTaskInstance)taskQuery.singleResult();
    }

    public boolean isMultiTenantWorkflowDeploymentEnabled() {
        return this.deployWorkflowsInTenant;
    }

    public boolean isRetentionHistoricProcessInstanceEnabled() {
        return this.retentionHistoricProcessInstance;
    }
}

