/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.alfresco.repo.tenant.TenantService;

public class AlfrescoProcessBpmnParseHandler
extends AbstractBpmnParseHandler<Process> {
    private ExecutionListener processCreateListener;
    private TenantService tenantService;
    private boolean multiTenancyEnabled = true;

    protected Class<? extends BaseElement> getHandledType() {
        return Process.class;
    }

    protected void executeParse(BpmnParse bpmnParse, Process process) {
        ProcessDefinitionEntity processDefinition = bpmnParse.getCurrentProcessDefinition();
        processDefinition.addExecutionListener("start", this.processCreateListener);
        if (this.multiTenancyEnabled && this.tenantService.isEnabled()) {
            String key = this.tenantService.getName(processDefinition.getKey());
            processDefinition.setKey(key);
        }
    }

    public void setProcessCreateListener(ExecutionListener processCreateListener) {
        this.processCreateListener = processCreateListener;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setMultiTenancyEnabled(boolean multiTenancyEnabled) {
        this.multiTenancyEnabled = multiTenancyEnabled;
    }
}

