/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.oauth2;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.oauth2.OAuth2CredentialsStoreService;
import org.alfresco.service.cmr.remotecredentials.OAuth2CredentialsInfo;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OAuth2CredentialsStoreServiceTest
extends BaseSpringTest {
    private static OAuth2CredentialsStoreService oauth2CredentialsStoreService;
    private static ServiceRegistry serviceRegistry;
    private static RetryingTransactionHelper transactionHelper;
    private static MutableAuthenticationService authenticationService;
    private static PersonService personService;
    private static String RemoteSystemId;
    private static String AccessToken;
    private static String RefreshToken;
    private static long dec291999;
    private static Date ExpiresAt;
    private static Date IssuedAt;
    private static String UpdatedAccessToken;
    private static String UpdatedRefreshToken;
    private static long dec292012;
    private static Date UpdatedExpiresAt;
    private static Date UpdatedIssuedAt;
    private static String TEST_USER_ONE;
    private static String TEST_USER_TWO;
    private static final String ADMIN_USER;

    static {
        RemoteSystemId = "Test-OAuth2RemoteSystem";
        AccessToken = "123456789ABC";
        RefreshToken = "CBA987654321";
        dec291999 = 946450800L;
        ExpiresAt = new Date(dec291999);
        IssuedAt = new Date(dec291999);
        UpdatedAccessToken = "abcdefghi123";
        UpdatedRefreshToken = "321ihgfedcba";
        dec292012 = 1356764400L;
        UpdatedExpiresAt = new Date(dec292012);
        UpdatedIssuedAt = new Date(dec292012);
        TEST_USER_ONE = OAuth2CredentialsStoreService.class.getSimpleName() + GUID.generate();
        TEST_USER_TWO = OAuth2CredentialsStoreService.class.getSimpleName() + GUID.generate();
        ADMIN_USER = AuthenticationUtil.getAdminUserName();
    }

    @Before
    public void setUp() throws Exception {
        serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        transactionHelper = serviceRegistry.getTransactionService().getRetryingTransactionHelper();
        authenticationService = serviceRegistry.getAuthenticationService();
        personService = serviceRegistry.getPersonService();
        oauth2CredentialsStoreService = (OAuth2CredentialsStoreService)this.applicationContext.getBean("oauth2CredentialsStoreService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        OAuth2CredentialsStoreServiceTest.createUser(TEST_USER_ONE);
        OAuth2CredentialsStoreServiceTest.createUser(TEST_USER_TWO);
    }

    @After
    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void testStorePersonalOAuth2Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        oauth2CredentialsStoreService.storePersonalOAuth2Credentials(RemoteSystemId, AccessToken, RefreshToken, ExpiresAt, IssuedAt);
        OAuth2CredentialsInfo oAuth2CredentialsInfo = oauth2CredentialsStoreService.getPersonalOAuth2Credentials(RemoteSystemId);
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that access tokens will match", (String)AccessToken, (String)oAuth2CredentialsInfo.getOAuthAccessToken());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect the refresh token will match", (String)RefreshToken, (String)oAuth2CredentialsInfo.getOAuthRefreshToken());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that the expiration date will match", (Object)ExpiresAt, (Object)oAuth2CredentialsInfo.getOAuthTicketExpiresAt());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that the issued date will match", (Object)IssuedAt, (Object)oAuth2CredentialsInfo.getOAuthTicketIssuedAt());
        oauth2CredentialsStoreService.storePersonalOAuth2Credentials(RemoteSystemId, UpdatedAccessToken, UpdatedRefreshToken, UpdatedExpiresAt, UpdatedIssuedAt);
        OAuth2CredentialsInfo _oAuth2CredentialsInfo = oauth2CredentialsStoreService.getPersonalOAuth2Credentials(RemoteSystemId);
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that access tokens will match", (String)UpdatedAccessToken, (String)_oAuth2CredentialsInfo.getOAuthAccessToken());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect the refresh token will match", (String)UpdatedRefreshToken, (String)_oAuth2CredentialsInfo.getOAuthRefreshToken());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that the expiration date will match", (Object)UpdatedExpiresAt, (Object)_oAuth2CredentialsInfo.getOAuthTicketExpiresAt());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that the issued date will match", (Object)UpdatedIssuedAt, (Object)_oAuth2CredentialsInfo.getOAuthTicketIssuedAt());
    }

    @Test
    public void testStoreSharedOAuth2Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        oauth2CredentialsStoreService.storeSharedOAuth2Credentials(RemoteSystemId, AccessToken, RefreshToken, ExpiresAt, IssuedAt);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        List sharedCredentials = oauth2CredentialsStoreService.listSharedOAuth2Credentials(RemoteSystemId);
        OAuth2CredentialsInfo oAuth2CredentialsInfo = (OAuth2CredentialsInfo)sharedCredentials.get(0);
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that access tokens will match", (String)AccessToken, (String)oAuth2CredentialsInfo.getOAuthAccessToken());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect the refresh token will match", (String)RefreshToken, (String)oAuth2CredentialsInfo.getOAuthRefreshToken());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that the expiration date will match", (Object)ExpiresAt, (Object)oAuth2CredentialsInfo.getOAuthTicketExpiresAt());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that the issued date will match", (Object)IssuedAt, (Object)oAuth2CredentialsInfo.getOAuthTicketIssuedAt());
    }

    @Test(expected=AccessDeniedException.class)
    public void testSecureUpdateSharedOAuth2Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        List sharedCredentials = oauth2CredentialsStoreService.listSharedOAuth2Credentials(RemoteSystemId);
        OAuth2CredentialsInfo oAuth2CredentialsInfo = (OAuth2CredentialsInfo)sharedCredentials.get(0);
        oauth2CredentialsStoreService.updateSharedOAuth2Credentials(oAuth2CredentialsInfo, RemoteSystemId, UpdatedAccessToken, UpdatedRefreshToken, UpdatedExpiresAt, UpdatedIssuedAt);
    }

    @Test
    public void testUpdateSharedOAuth2CredentialsTestDeletePesonalOAuth2Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        List sharedCredentials = oauth2CredentialsStoreService.listSharedOAuth2Credentials(RemoteSystemId);
        OAuth2CredentialsInfo oAuth2CredentialsInfo = (OAuth2CredentialsInfo)sharedCredentials.get(0);
        OAuth2CredentialsInfo _oAuth2CredentialsInfo = oauth2CredentialsStoreService.updateSharedOAuth2Credentials(oAuth2CredentialsInfo, RemoteSystemId, UpdatedAccessToken, UpdatedRefreshToken, UpdatedExpiresAt, UpdatedIssuedAt);
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that access tokens will match", (String)UpdatedAccessToken, (String)_oAuth2CredentialsInfo.getOAuthAccessToken());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect the refresh token will match", (String)UpdatedRefreshToken, (String)_oAuth2CredentialsInfo.getOAuthRefreshToken());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that the expiration date will match", (Object)UpdatedExpiresAt, (Object)_oAuth2CredentialsInfo.getOAuthTicketExpiresAt());
        OAuth2CredentialsStoreServiceTest.assertEquals((String)"Expect that the issued date will match", (Object)UpdatedIssuedAt, (Object)_oAuth2CredentialsInfo.getOAuthTicketIssuedAt());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        boolean deleted = oauth2CredentialsStoreService.deletePersonalOAuth2Credentials(RemoteSystemId);
        OAuth2CredentialsStoreServiceTest.assertTrue((boolean)deleted);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        boolean _deleted = oauth2CredentialsStoreService.deletePersonalOAuth2Credentials(RemoteSystemId);
        OAuth2CredentialsStoreServiceTest.assertFalse((boolean)_deleted);
    }

    @Test(expected=AccessDeniedException.class)
    public void testSecureDeleteSharedOAuth2CredentialsTestDeleteSharedOAuth2Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        List sharedCredentials = oauth2CredentialsStoreService.listSharedOAuth2Credentials(RemoteSystemId);
        OAuth2CredentialsInfo oAuth2CredentialsInfo = (OAuth2CredentialsInfo)sharedCredentials.get(0);
        oauth2CredentialsStoreService.deleteSharedOAuth2Credentials(RemoteSystemId, oAuth2CredentialsInfo);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        sharedCredentials = oauth2CredentialsStoreService.listSharedOAuth2Credentials(RemoteSystemId);
        oAuth2CredentialsInfo = (OAuth2CredentialsInfo)sharedCredentials.get(0);
        boolean deleted = oauth2CredentialsStoreService.deleteSharedOAuth2Credentials(RemoteSystemId, oAuth2CredentialsInfo);
        OAuth2CredentialsStoreServiceTest.assertTrue((boolean)deleted);
    }

    private static void createUser(final String userName) {
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (!authenticationService.authenticationExists(userName)) {
                    authenticationService.createAuthentication(userName, "PWD".toCharArray());
                }
                if (!personService.personExists(userName)) {
                    PropertyMap ppOne = new PropertyMap();
                    ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
                    ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
                    ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
                    ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
                    ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
                    personService.createPerson((Map)ppOne);
                }
                return null;
            }
        });
    }
}

