/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.replication.script;

import java.util.List;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.replication.script.ScriptReplicationDefinition;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.replication.ReplicationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptReplicationService
extends BaseScopableProcessorExtension {
    private static Log logger = LogFactory.getLog(ScriptReplicationService.class);
    private ServiceRegistry serviceRegistry;
    private ReplicationService replicationService;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setReplicationService(ReplicationService replicationService) {
        this.replicationService = replicationService;
    }

    public ScriptReplicationDefinition createReplicationDefinition(String replicationName, String description) {
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Creating ScriptReplicationDefinition [").append(replicationName).append(", ").append(description).append("]");
            logger.debug((Object)msg.toString());
        }
        ReplicationDefinition replicationDefinition = this.replicationService.createReplicationDefinition(replicationName, description);
        return new ScriptReplicationDefinition(this.serviceRegistry, this.replicationService, this.getScope(), replicationDefinition);
    }

    public void saveReplicationDefinition(ScriptReplicationDefinition definition) {
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Saving ScriptReplicationDefinition [").append(definition.getReplicationName()).append(", ").append(definition.getDescription()).append("]");
            logger.debug((Object)msg.toString());
        }
        ReplicationDefinition replicationDefinition = definition.getReplicationDefinition();
        this.replicationService.saveReplicationDefinition(replicationDefinition);
    }

    public ScriptReplicationDefinition loadReplicationDefinition(String replicationName) {
        ReplicationDefinition replicationDefinition = this.replicationService.loadReplicationDefinition(replicationName);
        if (replicationDefinition == null) {
            return null;
        }
        return new ScriptReplicationDefinition(this.serviceRegistry, this.replicationService, this.getScope(), replicationDefinition);
    }

    public ScriptReplicationDefinition[] loadReplicationDefinitions() {
        List<ReplicationDefinition> definitions = this.replicationService.loadReplicationDefinitions();
        return this.toScriptReplicationDefinitions(definitions);
    }

    public ScriptReplicationDefinition[] loadReplicationDefinitions(String targetName) {
        List<ReplicationDefinition> definitions = this.replicationService.loadReplicationDefinitions(targetName);
        return this.toScriptReplicationDefinitions(definitions);
    }

    public void replicate(ScriptReplicationDefinition definition) {
        this.replicationService.replicate(definition.getReplicationDefinition());
    }

    private ScriptReplicationDefinition[] toScriptReplicationDefinitions(List<ReplicationDefinition> definitions) {
        ScriptReplicationDefinition[] scriptDefs = new ScriptReplicationDefinition[definitions.size()];
        int i = 0;
        while (i < scriptDefs.length) {
            ReplicationDefinition def = definitions.get(i);
            scriptDefs[i] = new ScriptReplicationDefinition(this.serviceRegistry, this.replicationService, this.getScope(), def);
            ++i;
        }
        return scriptDefs;
    }
}

