/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.security.authority.AuthorityBridgeDAO;
import org.alfresco.repo.security.authority.AuthorityBridgeLink;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public abstract class AbstractAuthorityBridgeDAO
implements AuthorityBridgeDAO {
    private NodeDAO nodeDAO;
    private QNameDAO qnameDAO;
    private TenantService tenantService;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Override
    public List<AuthorityBridgeLink> getAuthorityBridgeLinks() {
        Pair<Long, StoreRef> storePair;
        Long authorityContainerTypeQNameId = Long.MIN_VALUE;
        Pair<Long, QName> authorityContainerTypeQNamePair = this.qnameDAO.getQName(ContentModel.TYPE_AUTHORITY_CONTAINER);
        if (authorityContainerTypeQNamePair != null) {
            authorityContainerTypeQNameId = (Long)authorityContainerTypeQNamePair.getFirst();
        }
        Long memberAssocQNameId = Long.MIN_VALUE;
        Pair<Long, QName> memberAssocQNamePair = this.qnameDAO.getQName(ContentModel.ASSOC_MEMBER);
        if (memberAssocQNamePair != null) {
            memberAssocQNameId = (Long)memberAssocQNamePair.getFirst();
        }
        Long authorityNameQNameId = Long.MIN_VALUE;
        Pair<Long, QName> authorityNameQNamePair = this.qnameDAO.getQName(ContentModel.PROP_AUTHORITY_NAME);
        if (authorityNameQNamePair != null) {
            authorityNameQNameId = (Long)authorityNameQNamePair.getFirst();
        }
        StoreRef tenantSpecificStoreRef = this.tenantService.getName(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        Long storeId = Long.MIN_VALUE;
        if (tenantSpecificStoreRef != null && (storePair = this.nodeDAO.getStore(tenantSpecificStoreRef)) != null) {
            storeId = (Long)storePair.getFirst();
        }
        return this.selectAuthorityBridgeLinks(authorityContainerTypeQNameId, memberAssocQNameId, authorityNameQNameId, storeId);
    }

    @Override
    public List<AuthorityBridgeLink> getDirectAuthoritiesForUser(NodeRef authRef) {
        Pair<Long, StoreRef> storePair;
        Long authorityContainerTypeQNameId = Long.MIN_VALUE;
        Pair<Long, QName> authorityContainerTypeQNamePair = this.qnameDAO.getQName(ContentModel.TYPE_AUTHORITY_CONTAINER);
        if (authorityContainerTypeQNamePair != null) {
            authorityContainerTypeQNameId = (Long)authorityContainerTypeQNamePair.getFirst();
        }
        Long memberAssocQNameId = Long.MIN_VALUE;
        Pair<Long, QName> memberAssocQNamePair = this.qnameDAO.getQName(ContentModel.ASSOC_MEMBER);
        if (memberAssocQNamePair != null) {
            memberAssocQNameId = (Long)memberAssocQNamePair.getFirst();
        }
        Long authorityNameQNameId = Long.MIN_VALUE;
        Pair<Long, QName> authorityNameQNamePair = this.qnameDAO.getQName(ContentModel.PROP_AUTHORITY_NAME);
        if (authorityNameQNamePair != null) {
            authorityNameQNameId = (Long)authorityNameQNamePair.getFirst();
        }
        StoreRef tenantSpecificStoreRef = this.tenantService.getName(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        Long storeId = Long.MIN_VALUE;
        if (tenantSpecificStoreRef != null && (storePair = this.nodeDAO.getStore(tenantSpecificStoreRef)) != null) {
            storeId = (Long)storePair.getFirst();
        }
        Pair<Long, NodeRef> pair = authRef == null ? null : this.nodeDAO.getNodePair(this.tenantService.getName(authRef));
        return this.selectDirectAuthoritiesForUser(authorityContainerTypeQNameId, memberAssocQNameId, authorityNameQNameId, storeId, pair == null ? -1L : (Long)pair.getFirst());
    }

    protected abstract List<AuthorityBridgeLink> selectDirectAuthoritiesForUser(Long var1, Long var2, Long var3, Long var4, Long var5);

    protected abstract List<AuthorityBridgeLink> selectAuthorityBridgeLinks(Long var1, Long var2, Long var3, Long var4);
}

