/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.textui.ResultPrinter;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.TestWebScriptRepoServer;
import org.alfresco.repo.web.scripts.servlet.LocalTestRunAsAuthenticatorFactory;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.webscripts.TestWebScriptServer;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;

@Category(value={LuceneTests.class})
public abstract class BaseWebScriptTest
extends TestCase {
    private WebScriptTestListener listener = null;
    private boolean traceReqRes = false;
    private String customContext = null;
    private ServletAuthenticatorFactory customAuthenticatorFactory = null;
    private String defaultRunAs = null;
    private RemoteServer remoteServer = null;
    private HttpClient httpClient = null;

    public void setCustomContext(String customContext) {
        this.customContext = customContext;
    }

    public void setListener(WebScriptTestListener listener) {
        this.listener = listener;
    }

    public void setTraceReqRes(boolean traceReqRes) {
        this.traceReqRes = traceReqRes;
    }

    public void setRemoteServer(RemoteServer server) {
        this.remoteServer = server;
    }

    public RemoteServer getRemoteServer() {
        return this.remoteServer;
    }

    public void setDefaultRunAs(String localRunAs) {
        this.defaultRunAs = localRunAs;
    }

    public String getDefaultRunAs() {
        return this.defaultRunAs;
    }

    public ServletAuthenticatorFactory getCustomAuthenticatorFactory() {
        return this.customAuthenticatorFactory;
    }

    public void setCustomAuthenticatorFactory(ServletAuthenticatorFactory customAuthenticatorFactory) {
        this.customAuthenticatorFactory = customAuthenticatorFactory;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.remoteServer != null) {
            this.httpClient = new HttpClient();
            this.httpClient.getParams().setBooleanParameter("http.authentication.preemptive", true);
            if (this.remoteServer.username != null) {
                this.httpClient.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.remoteServer.username, this.remoteServer.password));
            }
        }
    }

    public TestWebScriptServer getServer() {
        TestWebScriptServer server = this.customContext == null ? TestWebScriptRepoServer.getTestServer() : TestWebScriptRepoServer.getTestServer(this.customContext);
        if (this.customAuthenticatorFactory != null) {
            server.setServletAuthenticatorFactory(this.customAuthenticatorFactory);
        }
        return server;
    }

    protected boolean isLogEnabled() {
        return this.listener != null;
    }

    protected void log(String log) {
        if (this.listener != null) {
            this.listener.addLog((Test)this, log);
        }
    }

    protected TestWebScriptServer.Response sendRequest(TestWebScriptServer.Request req, int expectedStatus) throws IOException {
        return this.sendRequest(req, expectedStatus, null);
    }

    protected TestWebScriptServer.Response sendRequest(TestWebScriptServer.Request req, int expectedStatus, String asUser) throws IOException {
        if (this.traceReqRes && this.isLogEnabled()) {
            this.log("");
            this.log("* Request: " + req.getMethod() + " " + req.getFullUri() + (String)(req.getBody() == null ? "" : "\n" + new String(req.getBody(), "UTF-8")));
        }
        TestWebScriptServer.Response res = null;
        res = this.remoteServer == null ? this.sendLocalRequest(req, expectedStatus, asUser) : this.sendRemoteRequest(req, expectedStatus);
        if (this.traceReqRes && this.isLogEnabled()) {
            this.log("");
            this.log("* Response: " + res.getStatus() + " " + res.getContentType() + " " + req.getMethod() + " " + req.getFullUri() + "\n");
            this.log(res.getContentAsString());
        }
        if (expectedStatus > 0 && expectedStatus != res.getStatus()) {
            BaseWebScriptTest.fail((String)("Status code " + res.getStatus() + " returned, but expected " + expectedStatus + " for " + req.getFullUri() + " (" + req.getMethod() + ")\n" + res.getContentAsString()));
        }
        return res;
    }

    protected TestWebScriptServer.Response sendLocalRequest(final TestWebScriptServer.Request req, int expectedStatus, String asUser) throws IOException {
        asUser = asUser == null ? this.defaultRunAs : asUser;
        TestWebScriptServer tws = this.getServer();
        if (AuthenticationUtil.isMtEnabled() && this.customAuthenticatorFactory == null) {
            tws.setServletAuthenticatorFactory((ServletAuthenticatorFactory)new LocalTestRunAsAuthenticatorFactory());
        }
        if (asUser == null) {
            return this.getServer().submitRequest(req.getMethod(), req.getFullUri(), req.getHeaders(), req.getBody(), req.getEncoding(), req.getType());
        }
        return (TestWebScriptServer.Response)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<TestWebScriptServer.Response>(){

            public TestWebScriptServer.Response doWork() throws Exception {
                return BaseWebScriptTest.this.getServer().submitRequest(req.getMethod(), req.getFullUri(), req.getHeaders(), req.getBody(), req.getEncoding(), req.getType());
            }
        }, (String)asUser);
    }

    protected TestWebScriptServer.Response sendRemoteRequest(TestWebScriptServer.Request req, int expectedStatus) throws IOException {
        Object uri = req.getFullUri();
        if (!((String)uri).startsWith("http")) {
            uri = this.remoteServer.baseAddress + (String)uri;
        }
        GetMethod httpMethod = null;
        String method = req.getMethod();
        if (method.equalsIgnoreCase("GET")) {
            GetMethod get;
            httpMethod = get = new GetMethod(req.getFullUri());
        } else if (method.equalsIgnoreCase("POST")) {
            post = new PostMethod(req.getFullUri());
            post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(req.getBody(), req.getType()));
            httpMethod = post;
        } else if (method.equalsIgnoreCase("PATCH")) {
            post = new PatchMethod(req.getFullUri());
            post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(req.getBody(), req.getType()));
            httpMethod = post;
        } else if (method.equalsIgnoreCase("PUT")) {
            PutMethod put = new PutMethod(req.getFullUri());
            put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(req.getBody(), req.getType()));
            httpMethod = put;
        } else if (method.equalsIgnoreCase("DELETE")) {
            DeleteMethod del = new DeleteMethod(req.getFullUri());
            httpMethod = del;
        } else {
            throw new AlfrescoRuntimeException("Http Method " + method + " not supported");
        }
        if (req.getHeaders() != null) {
            for (Map.Entry header : req.getHeaders().entrySet()) {
                httpMethod.setRequestHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        this.httpClient.executeMethod((HttpMethod)httpMethod);
        return new HttpMethodResponse((HttpMethod)httpMethod);
    }

    public static class BaseWebScriptTestListener
    extends ResultPrinter
    implements WebScriptTestListener {
        public BaseWebScriptTestListener(PrintStream writer) {
            super(writer);
        }

        public void addError(Test test, Throwable t) {
            this.getWriter().println("*** Error: " + ((BaseWebScriptTest)test).getName());
            t.printStackTrace(this.getWriter());
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.getWriter().println("*** Failed: " + ((BaseWebScriptTest)test).getName());
            t.printStackTrace(this.getWriter());
        }

        public void endTest(Test test) {
            this.getWriter().println();
            this.getWriter().println("*** Test completed: " + ((BaseWebScriptTest)test).getName());
        }

        public void startTest(Test test) {
            this.getWriter().println();
            this.getWriter().println("*** Test started: " + ((BaseWebScriptTest)test).getName() + " (remote: " + (((BaseWebScriptTest)test).getRemoteServer() != null));
        }

        @Override
        public void addLog(Test test, String log) {
            this.getWriter().println(log);
        }
    }

    public static class HttpMethodResponse
    implements TestWebScriptServer.Response {
        private HttpMethod method;

        public HttpMethodResponse(HttpMethod method) {
            this.method = method;
        }

        public byte[] getContentAsByteArray() {
            try {
                return this.method.getResponseBody();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public String getContentAsString() throws UnsupportedEncodingException {
            try {
                return this.method.getResponseBodyAsString();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public String getContentType() {
            return this.getHeader("Content-Type");
        }

        public int getContentLength() {
            try {
                return this.method.getResponseBody().length;
            }
            catch (IOException iOException) {
                return 0;
            }
        }

        public String getHeader(String name) {
            Header header = this.method.getResponseHeader(name);
            return header != null ? header.getValue() : null;
        }

        public int getStatus() {
            return this.method.getStatusCode();
        }
    }

    public static class PatchMethod
    extends EntityEnclosingMethod {
        public PatchMethod(String uri) {
            super(uri);
        }

        public String getName() {
            return "PATCH";
        }
    }

    public static class RemoteServer {
        public String baseAddress;
        public String username;
        public String password;
    }

    public static interface WebScriptTestListener
    extends TestListener {
        public void addLog(Test var1, String var2);
    }
}

