/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoContext;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.filesys.config.acl.AccessControlListBean;
import org.alfresco.filesys.repo.NodeMonitor;
import org.alfresco.jlan.server.config.CoreServerConfigSection;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.cache.FileStateLockManager;
import org.alfresco.jlan.server.filesys.quota.QuotaManagerException;
import org.alfresco.jlan.server.thread.ThreadRequestPool;
import org.alfresco.service.cmr.repository.NodeRef;

public class ContentContext
extends AlfrescoContext {
    private String m_storeName;
    private String m_rootPath;
    private NodeRef m_rootNodeRef;
    private String m_relativePath;
    private boolean m_offlineFiles;
    private boolean m_disableNodeMonitor;
    private boolean m_disableChangeNotifications;
    private AccessControlListBean m_accessControlList;
    private FileStateLockManager m_lockManager;
    private boolean m_oplocksDisabled;
    private NodeMonitor m_nodeMonitor;
    private ThreadRequestPool m_threadPool;
    private Pattern renameShufflePattern = Pattern.compile("(.*[a-f0-9]{8}+$)|(.*\\.tmp$)|(.*\\.wbk$)|(.*\\.bak$)|(.*\\~$)");

    public ContentContext() {
    }

    public ContentContext(String deviceName, String storeName, String rootPath, NodeRef rootNodeRef) {
        this.setDeviceName(deviceName);
        this.setStoreName(storeName);
        this.setRootPath(rootPath);
        this.setRootNodeRef(rootNodeRef);
    }

    public void setStoreName(String name) {
        this.m_storeName = name;
    }

    public void setRootPath(String path) {
        this.m_rootPath = path;
    }

    public void setRelativePath(String path) {
        this.m_relativePath = path.replace('/', '\\');
    }

    public void setOfflineFiles(boolean offlineFiles) {
        this.m_offlineFiles = offlineFiles;
    }

    public void setDisableNodeMonitor(boolean disableNodeMonitor) {
        this.m_disableNodeMonitor = disableNodeMonitor;
    }

    public void setDisableChangeNotifications(boolean disableChangeNotify) {
        this.m_disableChangeNotifications = disableChangeNotify;
    }

    public void setAccessControlList(AccessControlListBean accessControlList) {
        this.m_accessControlList = accessControlList;
    }

    public void setRootNodeRef(NodeRef nodeRef) {
        this.m_rootNodeRef = nodeRef;
        this.setShareName(nodeRef.toString());
    }

    public void setDisableOplocks(boolean disableOplocks) {
        this.m_oplocksDisabled = disableOplocks;
    }

    public Pattern getRenameShufflePattern() {
        return this.renameShufflePattern;
    }

    public void setRenameShufflePattern(Pattern renameShufflePattern) {
        this.renameShufflePattern = renameShufflePattern;
    }

    @Override
    public void initialize(AlfrescoDiskDriver filesysDriver) {
        if (this.m_storeName == null || this.m_storeName.length() == 0) {
            throw new AlfrescoRuntimeException("Device missing storeName");
        }
        if (this.m_rootPath == null || this.m_rootPath.length() == 0) {
            throw new AlfrescoRuntimeException("Device missing rootPath");
        }
        this.getStateCache().setCaseSensitive(false);
        this.m_lockManager = new FileStateLockManager(this.getStateCache());
    }

    @Override
    public String getFilesystemType() {
        return "NTFS";
    }

    public final String getStoreName() {
        return this.m_storeName;
    }

    public final String getRootPath() {
        return this.m_rootPath;
    }

    public String getRelativePath() {
        return this.m_relativePath;
    }

    public boolean getOfflineFiles() {
        return this.m_offlineFiles;
    }

    public boolean getDisableNodeMonitor() {
        return this.m_disableNodeMonitor;
    }

    public boolean getDisableOplocks() {
        return this.m_oplocksDisabled;
    }

    public FileStateLockManager getLockManager() {
        return this.m_lockManager;
    }

    public boolean getDisableChangeNotifications() {
        return this.m_disableChangeNotifications;
    }

    public AccessControlListBean getAccessControlList() {
        return this.m_accessControlList;
    }

    public final NodeRef getRootNode() {
        return this.m_rootNodeRef;
    }

    public final ThreadRequestPool getThreadPool() {
        return this.m_threadPool;
    }

    public void CloseContext() {
        if (this.m_nodeMonitor != null) {
            this.m_nodeMonitor.shutdownRequest();
        }
        if (this.hasQuotaManager()) {
            try {
                this.getQuotaManager().stopManager(null, (DiskDeviceContext)this);
            }
            catch (QuotaManagerException quotaManagerException) {}
        }
        super.CloseContext();
    }

    protected void setNodeMonitor(NodeMonitor nodeMonitor) {
        this.m_nodeMonitor = nodeMonitor;
    }

    @Override
    public void startFilesystem(DiskSharedDevice share) throws DeviceContextException {
        CoreServerConfigSection coreConfig;
        super.startFilesystem(share);
        if (this.getStateCache() != null) {
            this.getStateCache().setCaseSensitive(false);
        }
        if ((coreConfig = (CoreServerConfigSection)share.getConfiguration().getConfigSection("CoreServer")) != null) {
            this.m_threadPool = coreConfig.getThreadPool();
        }
        if (this.getLockManager() != null) {
            this.m_lockManager.startLockManager("OplockExpire_" + share.getName(), this.m_threadPool);
        }
        if (this.m_nodeMonitor != null) {
            this.m_nodeMonitor.startMonitor();
        }
    }
}

