/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.mapping.AbstractActionEvaluator;
import org.alfresco.opencmis.mapping.PermissionActionEvaluator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.chemistry.opencmis.commons.enums.Action;

public class CanCheckOutActionEvaluator
extends AbstractActionEvaluator {
    private PermissionActionEvaluator permissionEvaluator;
    private LockService lockService;

    protected CanCheckOutActionEvaluator(ServiceRegistry serviceRegistry) {
        super(serviceRegistry, Action.CAN_CHECK_OUT);
        this.permissionEvaluator = new PermissionActionEvaluator(serviceRegistry, Action.CAN_CHECK_OUT, "CheckOut");
        this.lockService = serviceRegistry.getLockService();
    }

    public boolean isAllowed(CMISNodeInfo nodeInfo) {
        NodeRef nodeRef = nodeInfo.getNodeRef();
        if (nodeInfo.hasPWC() || this.lockService.getLockType(nodeRef) == LockType.READ_ONLY_LOCK) {
            return false;
        }
        return this.permissionEvaluator.isAllowed(nodeInfo);
    }
}

