/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema.script;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.alfresco.repo.domain.schema.script.StatementExecutor;
import org.alfresco.util.LogUtil;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteNotExistsExecutor
implements StatementExecutor {
    private static Log logger = LogFactory.getLog(DeleteNotExistsExecutor.class);
    private static final String ERR_STATEMENT_FAILED = "schema.update.err.statement_failed";
    private static final String MSG_OPTIONAL_STATEMENT_FAILED = "schema.update.msg.optional_statement_failed";
    public static final String PROPERTY_BATCH_SIZE = "system.delete_not_exists.batchsize";
    public static final String PROPERTY_DELETE_BATCH_SIZE = "system.delete_not_exists.delete_batchsize";
    public static final String PROPERTY_READ_ONLY = "system.delete_not_exists.read_only";
    public static final String PROPERTY_TIMEOUT_SECONDS = "system.delete_not_exists.timeout_seconds";
    protected Connection connection;
    private String sql;
    private int line;
    private File scriptFile;
    protected Properties globalProperties;
    protected boolean readOnly;
    protected int deleteBatchSize;
    protected int batchSize;
    private long timeoutSec;
    protected long deletedCount;
    protected Date startTime;

    public DeleteNotExistsExecutor(Connection connection, String sql, int line, File scriptFile, Properties globalProperties) {
        this.connection = connection;
        this.sql = sql;
        this.line = line;
        this.scriptFile = scriptFile;
        this.globalProperties = globalProperties;
    }

    public void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"globalProperties", (Object)this.globalProperties);
    }

    @Override
    public void execute() throws Exception {
        String[] tableColumnArgs;
        String[] args;
        this.checkProperties();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Execute statement: " + this.sql));
        }
        if ((args = this.sql.split("[ \\t]+(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")).length >= 3 && args[1].indexOf(46) != -1 && (tableColumnArgs = args[1].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")).length >= 2) {
            String batchSizeString = this.globalProperties.getProperty(args[2]);
            if (batchSizeString == null) {
                batchSizeString = this.globalProperties.getProperty(PROPERTY_BATCH_SIZE);
            }
            this.batchSize = batchSizeString == null ? 100000 : Integer.parseInt(batchSizeString);
            String deleteBatchSizeString = this.globalProperties.getProperty(PROPERTY_DELETE_BATCH_SIZE);
            this.deleteBatchSize = deleteBatchSizeString == null ? 1000 : Integer.parseInt(deleteBatchSizeString);
            String readOnlyString = this.globalProperties.getProperty(PROPERTY_READ_ONLY);
            this.readOnly = readOnlyString != null && Boolean.parseBoolean(readOnlyString);
            String timeoutSecString = this.globalProperties.getProperty(PROPERTY_TIMEOUT_SECONDS);
            this.timeoutSec = timeoutSecString == null ? -1L : Long.parseLong(timeoutSecString);
            String skipToIdString = args.length == 4 ? this.globalProperties.getProperty(args[3]) : null;
            Long skipToId = skipToIdString == null ? 0L : Long.parseLong(skipToIdString);
            Long[] tableUpperLimits = new Long[tableColumnArgs.length];
            Pair[] tableColumn = new Pair[tableColumnArgs.length];
            String[] optionalWhereClauses = new String[tableColumnArgs.length];
            int i = 0;
            while (i < tableColumnArgs.length) {
                String[] tableDetails = tableColumnArgs[i].split("\\.");
                String tableName = tableDetails[0];
                String columnName = tableDetails[1];
                if (tableDetails.length == 3) {
                    optionalWhereClauses[i] = this.removeDoubleQuotes(tableDetails[2]);
                }
                tableColumn[i] = new Pair((Object)tableName, (Object)columnName);
                tableUpperLimits[i] = this.getBatchUpperLimit(this.connection, tableName, columnName, this.line, this.scriptFile);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("BatchUpperLimit " + String.valueOf(tableUpperLimits[i]) + " for " + tableName + "." + columnName));
                }
                ++i;
            }
            this.process(tableColumn, tableUpperLimits, optionalWhereClauses, skipToId);
        }
    }

    protected void process(Pair<String, String>[] tableColumn, Long[] tableUpperLimits, String[] optionalWhereClauses) throws SQLException {
        String primaryTableName = (String)tableColumn[0].getFirst();
        String primaryColumnName = (String)tableColumn[0].getSecond();
        String primaryWhereClause = optionalWhereClauses[0];
        Long primaryId = 0L;
        PreparedStatement primaryPrepStmt = null;
        Statement[] secondaryPrepStmts = null;
        PreparedStatement deletePrepStmt = null;
        HashSet<Long> deleteIds = new HashSet<Long>();
        this.deletedCount = 0L;
        this.startTime = new Date();
        try {
            this.connection.setAutoCommit(false);
            primaryPrepStmt = this.connection.prepareStatement(this.createPreparedSelectStatement(primaryTableName, primaryColumnName, primaryWhereClause));
            primaryPrepStmt.setFetchSize(this.batchSize);
            primaryPrepStmt.setLong(1, primaryId);
            primaryPrepStmt.setLong(2, tableUpperLimits[0]);
            boolean hasResults = primaryPrepStmt.execute();
            if (hasResults) {
                Statement secStmt;
                secondaryPrepStmts = new PreparedStatement[tableColumn.length];
                int i = 1;
                while (i < tableColumn.length) {
                    secStmt = this.connection.prepareStatement(this.createPreparedSelectStatement((String)tableColumn[i].getFirst(), (String)tableColumn[i].getSecond(), optionalWhereClauses[i]));
                    secStmt.setFetchSize(this.batchSize);
                    secStmt.setLong(1, primaryId);
                    secStmt.setLong(2, tableUpperLimits[i]);
                    secondaryPrepStmts[i] = secStmt;
                    ++i;
                }
                deletePrepStmt = this.connection.prepareStatement(this.createPreparedDeleteStatement(primaryTableName, primaryColumnName, this.deleteBatchSize, primaryWhereClause));
                while (hasResults && !this.isTimeoutExceeded()) {
                    primaryId = this.processPrimaryTableResultSet(primaryPrepStmt, (PreparedStatement[])secondaryPrepStmts, deletePrepStmt, deleteIds, primaryTableName, primaryColumnName, tableColumn);
                    this.connection.commit();
                    if (primaryId == null) break;
                    primaryPrepStmt.setLong(1, primaryId);
                    primaryPrepStmt.setLong(2, tableUpperLimits[0]);
                    i = 1;
                    while (i < tableColumn.length) {
                        secStmt = secondaryPrepStmts[i];
                        secStmt.setLong(1, primaryId);
                        secStmt.setLong(2, tableUpperLimits[i]);
                        ++i;
                    }
                    hasResults = primaryPrepStmt.execute();
                }
            }
            if (!deleteIds.isEmpty()) {
                this.deleteFromPrimaryTable(deletePrepStmt, deleteIds, primaryTableName);
                this.connection.commit();
            }
            if (logger.isDebugEnabled()) {
                String msg = (this.readOnly ? "Script would have" : "Script") + " deleted a total of " + this.deletedCount + " items from table " + primaryTableName + ".";
                logger.debug((Object)msg);
            }
        }
        catch (Throwable throwable) {
            this.closeQuietly(deletePrepStmt);
            this.closeQuietly(secondaryPrepStmts);
            this.closeQuietly(primaryPrepStmt);
            this.connection.setAutoCommit(true);
            throw throwable;
        }
        this.closeQuietly(deletePrepStmt);
        this.closeQuietly(secondaryPrepStmts);
        this.closeQuietly(primaryPrepStmt);
        this.connection.setAutoCommit(true);
    }

    protected boolean isTimeoutExceeded() {
        if (this.timeoutSec <= 0L) {
            return false;
        }
        Date now = new Date();
        return now.getTime() > this.startTime.getTime() + this.timeoutSec * 1000L;
    }

    protected Long processPrimaryTableResultSet(PreparedStatement primaryPrepStmt, PreparedStatement[] secondaryPrepStmts, PreparedStatement deletePrepStmt, Set<Long> deleteIds, String primaryTableName, String primaryColumnName, Pair<String, String>[] tableColumn) throws SQLException {
        int rowsProcessed = 0;
        Long primaryId = null;
        ResultSet[] secondaryResultSets = null;
        try {
            Throwable throwable = null;
            Object var12_13 = null;
            try (ResultSet resultSet = primaryPrepStmt.getResultSet();){
                secondaryResultSets = this.getSecondaryResultSets(secondaryPrepStmts);
                Long[] secondaryIds = this.getSecondaryIds(secondaryResultSets, tableColumn);
                while (resultSet.next()) {
                    ++rowsProcessed;
                    primaryId = resultSet.getLong(primaryColumnName);
                    while (this.isLess(primaryId, secondaryIds)) {
                        deleteIds.add(primaryId);
                        if (deleteIds.size() == this.deleteBatchSize) {
                            this.deleteFromPrimaryTable(deletePrepStmt, deleteIds, primaryTableName);
                        }
                        if (!resultSet.next()) break;
                        primaryId = resultSet.getLong(primaryColumnName);
                        if (++rowsProcessed == this.batchSize) break;
                    }
                    if (rowsProcessed == this.batchSize) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("RowsProcessed " + rowsProcessed + " from primary table " + primaryTableName));
                        }
                        break;
                    }
                    this.updateSecondaryIds(primaryId, secondaryIds, secondaryResultSets, tableColumn);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.closeQuietly(secondaryResultSets);
            throw throwable;
        }
        this.closeQuietly(secondaryResultSets);
        return primaryId;
    }

    protected void deleteFromPrimaryTable(PreparedStatement deletePrepStmt, Set<Long> deleteIds, String primaryTableName) throws SQLException {
        int deletedBatchCount = deleteIds.size();
        if (!this.readOnly && !deleteIds.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Prepare to delete " + deleteIds.size() + " items from table " + primaryTableName + "."));
            }
            deletedBatchCount = this.executeDeleteStatement(deletePrepStmt, deleteIds, this.deleteBatchSize, this.line, this.scriptFile);
        }
        this.deletedCount += (long)deletedBatchCount;
        if (logger.isTraceEnabled()) {
            String msg = (this.readOnly ? "Script would have" : "Script") + " deleted a batch of " + deletedBatchCount + " items from table " + primaryTableName + ".";
            logger.trace((Object)msg);
        }
        deleteIds.clear();
    }

    private Object executeStatement(Connection connection, String sql, String fetchColumnName, boolean optional, int line, File file) throws SQLException {
        Object ret;
        block17: {
            Statement stmt = null;
            ret = null;
            try {
                try {
                    boolean haveResults;
                    stmt = connection.createStatement();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Executing statement: " + sql));
                    }
                    if (!(haveResults = stmt.execute(sql)) || fetchColumnName == null) break block17;
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (ResultSet rs = stmt.getResultSet();){
                        if (rs.next()) {
                            ret = rs.getObject(fetchColumnName);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    if (!optional) {
                        LogUtil.error((Log)logger, (String)ERR_STATEMENT_FAILED, (Object[])new Object[]{sql, e.getMessage(), file.getAbsolutePath(), line});
                        throw e;
                    }
                    LogUtil.debug((Log)logger, (String)MSG_OPTIONAL_STATEMENT_FAILED, (Object[])new Object[]{sql, e.getMessage(), file.getAbsolutePath(), line});
                    this.closeQuietly(stmt);
                }
            }
            finally {
                this.closeQuietly(stmt);
            }
        }
        return ret;
    }

    private Long getBatchUpperLimit(Connection connection, String tableName, String columnName, int line, File scriptFile) throws SQLException {
        Long batchUpperLimit = 0L;
        String stmt = "SELECT MAX(" + columnName + ") AS upper_limit FROM " + tableName;
        Object fetchedVal = this.executeStatement(connection, stmt, "upper_limit", false, line, scriptFile);
        if (fetchedVal instanceof Number) {
            batchUpperLimit = ((Number)fetchedVal).longValue();
        }
        return batchUpperLimit;
    }

    protected boolean isLess(Long primaryId, Long[] secondaryIds) {
        Long[] longArray = secondaryIds;
        int n = secondaryIds.length;
        int n2 = 0;
        while (n2 < n) {
            Long secondaryId = longArray[n2];
            if (secondaryId != null && primaryId >= secondaryId) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String removeDoubleQuotes(String quotedString) {
        if (quotedString == null || quotedString.isEmpty()) {
            return quotedString;
        }
        return quotedString.replace("\"", "");
    }

    protected String createPreparedSelectStatement(String tableName, String columnName, String whereClause) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT " + columnName + " FROM " + tableName + " WHERE ");
        if (whereClause != null && !whereClause.isEmpty()) {
            sqlBuilder.append(whereClause + " AND ");
        }
        sqlBuilder.append(columnName + " > ? AND " + columnName + " <= ? ORDER BY " + columnName + " ASC");
        return sqlBuilder.toString();
    }

    protected String createPreparedDeleteStatement(String tableName, String idColumnName, int deleteBatchSize, String whereClause) {
        StringBuilder stmtBuilder = new StringBuilder("DELETE FROM " + tableName + " WHERE ");
        if (whereClause != null && !whereClause.isEmpty()) {
            stmtBuilder.append(whereClause + " AND ");
        }
        stmtBuilder.append(idColumnName + " IN ");
        stmtBuilder.append("(");
        int i = 1;
        while (i <= deleteBatchSize) {
            if (i < deleteBatchSize) {
                stmtBuilder.append("?,");
            } else {
                stmtBuilder.append("?");
            }
            ++i;
        }
        stmtBuilder.append(")");
        return stmtBuilder.toString();
    }

    private int executeDeleteStatement(PreparedStatement stmt, Set<Long> deleteIds, int deleteBatchSize, int line, File scriptFile) throws SQLException {
        try {
            int i = 1;
            for (Long deleteId : deleteIds) {
                stmt.setObject(i, deleteId);
                ++i;
            }
            int j = i;
            while (j <= deleteBatchSize) {
                stmt.setObject(j, 0);
                ++j;
            }
            int deletedItems = stmt.executeUpdate();
            return deletedItems;
        }
        catch (SQLException e) {
            LogUtil.error((Log)logger, (String)ERR_STATEMENT_FAILED, (Object[])new Object[]{this.sql, e.getMessage(), scriptFile.getAbsolutePath(), line});
            throw e;
        }
    }

    protected Long getColumnValueById(ResultSet resultSet, String columnId) throws SQLException {
        Long columnValue = null;
        if (resultSet != null && resultSet.next()) {
            columnValue = resultSet.getLong(columnId);
        }
        return columnValue;
    }

    protected ResultSet[] getSecondaryResultSets(PreparedStatement[] preparedStatements) throws SQLException {
        ResultSet[] secondaryResultSets = new ResultSet[preparedStatements.length];
        int i = 1;
        while (i < preparedStatements.length) {
            PreparedStatement secStmt = preparedStatements[i];
            boolean secHasResults = secStmt.execute();
            secondaryResultSets[i] = secHasResults ? secStmt.getResultSet() : null;
            ++i;
        }
        return secondaryResultSets;
    }

    protected Long[] getSecondaryIds(ResultSet[] secondaryResultSets, Pair<String, String>[] tableColumn) throws SQLException {
        Long[] secondaryIds = new Long[tableColumn.length];
        int i = 1;
        while (i < tableColumn.length) {
            ResultSet resultSet = secondaryResultSets[i];
            String columnId = (String)tableColumn[i].getSecond();
            secondaryIds[i] = this.getColumnValueById(resultSet, columnId);
            ++i;
        }
        return secondaryIds;
    }

    private void updateSecondaryIds(Long primaryId, Long[] secondaryIds, ResultSet[] secondaryResultSets, Pair<String, String>[] tableColumn) throws SQLException {
        int i = 1;
        while (i < tableColumn.length) {
            Long secondaryId = secondaryIds[i];
            while (secondaryId != null && primaryId >= secondaryId) {
                ResultSet resultSet = secondaryResultSets[i];
                String columnId = (String)tableColumn[i].getSecond();
                secondaryIds[i] = secondaryId = this.getColumnValueById(resultSet, columnId);
            }
            ++i;
        }
    }

    protected void closeQuietly(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void closeQuietly(Statement[] statements) {
        if (statements != null) {
            Statement[] statementArray = statements;
            int n = statements.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray[n2];
                this.closeQuietly(statement);
                ++n2;
            }
        }
    }

    protected void closeQuietly(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void closeQuietly(ResultSet[] resultSets) {
        if (resultSets != null) {
            ResultSet[] resultSetArray = resultSets;
            int n = resultSets.length;
            int n2 = 0;
            while (n2 < n) {
                ResultSet resultSet = resultSetArray[n2];
                this.closeQuietly(resultSet);
                ++n2;
            }
        }
    }

    protected void process(Pair<String, String>[] tableColumn, Long[] tableUpperLimits, String[] optionalWhereClauses, Long skipToId) throws SQLException {
        this.process(tableColumn, tableUpperLimits, optionalWhereClauses);
    }
}

