/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptAction;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.lang3.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MetaDataExtractAction
extends BaseScopableProcessorExtension {
    private static final Log LOG = LogFactory.getLog(MetaDataExtractAction.class);
    private static final String ACTION_NAME = "extract-metadata";
    private ContentService contentService;
    private ServiceRegistry services;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.services = serviceRegistry;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ScriptAction create(boolean isContentChanged) {
        ScriptAction scriptAction = null;
        ActionService actionService = this.services.getActionService();
        ActionDefinition actionDef = actionService.getActionDefinition(ACTION_NAME);
        if (actionDef != null) {
            Action action = actionService.createAction(ACTION_NAME);
            ActionCondition actionCondition = actionService.createActionCondition("compare-content");
            actionCondition.setParameterValue("isContentChanged", Boolean.valueOf(isContentChanged));
            action.addActionCondition(actionCondition);
            scriptAction = new ScriptAction(this.services, action, actionDef);
            scriptAction.setScope(this.getScope());
        }
        return scriptAction;
    }

    public boolean isContentChanged(String itemId, FormData formData) {
        FormData.FieldData fieldData;
        String contentString;
        block6: {
            NodeRef nodeRef;
            block5: {
                try {
                    NodeRef nodeRef2 = nodeRef = NodeRef.isNodeRef((String)itemId) ? new NodeRef(itemId) : this.parseNodeRef(itemId);
                    if (nodeRef != null) break block5;
                    return false;
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Unable to determine if content has changed for node: " + itemId), (Throwable)e);
                    }
                    return false;
                }
            }
            ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
            contentString = reader.getContentString();
            fieldData = formData.getFieldData("prop_cm_content");
            if (fieldData != null && fieldData.getValue() != null) break block6;
            return false;
        }
        String propCmContent = String.valueOf(fieldData.getValue());
        return !Strings.CS.equals(contentString, propCmContent);
    }

    private NodeRef parseNodeRef(String itemId) {
        String[] parts = itemId.split("/");
        return parts.length == 3 ? new NodeRef(parts[0], parts[1], parts[2]) : null;
    }
}

