/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.site.SiteContainersCannedQueryParams;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class SiteContainersCannedQuery
extends AbstractCannedQueryPermissions<FileInfo> {
    private FileFolderService fileFolderService;
    private NodeService nodeService;

    public SiteContainersCannedQuery(FileFolderService fileFolderService, NodeService nodeService, CannedQueryParameters parameters, MethodSecurityBean<FileInfo> methodSecurity) {
        super(parameters, methodSecurity);
        this.fileFolderService = fileFolderService;
        this.nodeService = nodeService;
    }

    protected List<FileInfo> queryAndFilter(CannedQueryParameters parameters) {
        SiteContainersCannedQueryParams paramBean = (SiteContainersCannedQueryParams)parameters.getParameterBean();
        NodeRef siteNodeRef = paramBean.getSiteNodeRef();
        ArrayList<FileInfo> containers = new ArrayList<FileInfo>(10);
        int skip = 0;
        int maxItems = 50;
        List<Pair<QName, Boolean>> sortProps = null;
        PagingRequest pagingRequest = new PagingRequest(skip, maxItems);
        PagingResults<FileInfo> pagingResults = null;
        do {
            pagingResults = this.fileFolderService.list(siteNodeRef, false, true, null, sortProps, pagingRequest);
            for (FileInfo folder : pagingResults.getPage()) {
                NodeRef containerNodeRef = folder.getNodeRef();
                if (!this.nodeService.hasAspect(containerNodeRef, SiteModel.ASPECT_SITE_CONTAINER)) continue;
                containers.add(folder);
            }
            if (!pagingResults.hasMoreItems()) continue;
            pagingRequest = new PagingRequest(skip += maxItems, maxItems);
        } while (pagingResults.hasMoreItems());
        return containers;
    }

    protected boolean isApplyPostQuerySorting() {
        return true;
    }

    protected List<FileInfo> applyPostQuerySorting(List<FileInfo> results, CannedQuerySortDetails sortDetails) {
        List sortPairs = sortDetails.getSortPairs();
        if (sortPairs.size() > 0) {
            Collections.sort(results, new FileInfoComparator(sortPairs));
        }
        return results;
    }

    private static class FileInfoComparator
    implements Comparator<FileInfo> {
        private List<Pair<Object, CannedQuerySortDetails.SortOrder>> sortPairs;

        public FileInfoComparator(List<Pair<Object, CannedQuerySortDetails.SortOrder>> sortPairs) {
            this.sortPairs = sortPairs;
        }

        @Override
        public int compare(FileInfo o1, FileInfo o2) {
            int ret = 0;
            for (Pair<Object, CannedQuerySortDetails.SortOrder> pair : this.sortPairs) {
                if (!pair.getFirst().equals((Object)SiteContainersCannedQueryParams.SortFields.ContainerName)) continue;
                ret = o1.getName().compareTo(o2.getName());
                if (!((CannedQuerySortDetails.SortOrder)pair.getSecond()).equals((Object)CannedQuerySortDetails.SortOrder.DESCENDING)) continue;
                ret *= -1;
            }
            return ret;
        }
    }
}

