/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryNamespaceComponent;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.model.filefolder.FilenameFilteringInterceptor;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.springframework.context.ApplicationContext;

public class HiddenAspectTest {
    @Rule
    public TestName name = new TestName();
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    protected HiddenAspect hiddenAspect;
    private TransactionService transactionService;
    private NodeDAO nodeDAO;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;
    private CheckOutCheckInService cociService;
    private UserTransaction txn;
    private DictionaryNamespaceComponent namespacePrefixResolver;
    private ImapService imapService;
    private PersonService personService;
    private FilenameFilteringInterceptor interceptor;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;
    private NodeRef topNodeRef;
    private boolean imapEnabled;
    private final String MAILBOX_NAME_A = "mailbox_a";
    private final String MAILBOX_NAME_B = ".mailbox_a";
    private String username;
    private AlfrescoImapUser user;
    protected boolean cmisDisableHide;

    @Before
    public void setup() throws SystemException, NotSupportedException {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.hiddenAspect = (HiddenAspect)ctx.getBean("hiddenAspect");
        this.interceptor = (FilenameFilteringInterceptor)ctx.getBean("filenameFilteringInterceptor");
        this.namespacePrefixResolver = (DictionaryNamespaceComponent)ctx.getBean("namespaceService");
        this.cociService = (CheckOutCheckInService)ctx.getBean("checkOutCheckInService");
        this.imapService = serviceRegistry.getImapService();
        this.personService = serviceRegistry.getPersonService();
        this.permissionService = serviceRegistry.getPermissionService();
        this.imapEnabled = serviceRegistry.getImapService().getImapServerEnabled();
        this.nodeDAO = (NodeDAO)ctx.getBean("nodeDAO");
        Properties properties = (Properties)ctx.getBean("global-properties");
        this.cmisDisableHide = Boolean.getBoolean(properties.getProperty("cmis.disable.hidden.leading.period.files"));
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.username = "user" + System.currentTimeMillis();
        PropertyMap testUser = new PropertyMap();
        testUser.put((Object)ContentModel.PROP_USERNAME, (Object)this.username);
        testUser.put((Object)ContentModel.PROP_FIRSTNAME, (Object)this.username);
        testUser.put((Object)ContentModel.PROP_LASTNAME, (Object)this.username);
        testUser.put((Object)ContentModel.PROP_EMAIL, (Object)(this.username + "@alfresco.com"));
        testUser.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.personService.createPerson((Map)testUser);
        this.authenticationService.createAuthentication(this.username, this.username.toCharArray());
        this.user = new AlfrescoImapUser(this.username + "@alfresco.com", this.username, this.username);
        this.storeRef = this.nodeService.createStore("workspace", this.getName() + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        this.permissionService.setPermission(this.rootNodeRef, this.username, "CreateChildren", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.username);
        this.topNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"working root"), ContentModel.TYPE_FOLDER).getChildRef();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
    }

    private String getName() {
        return this.name.getMethodName();
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.txn.getStatus() != 4 && this.txn.getStatus() != 3) {
                this.txn.commit();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testHiddenFilesEnhancedClient() {
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.webdav);
        try {
            FileFilterMode.Client client;
            NodeRef parent = this.fileFolderService.create(this.topNodeRef, "New Folder", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef child = this.fileFolderService.create(parent, "file.tmp", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
            List children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)1L, (long)children.size());
            parent = this.fileFolderService.create(this.topNodeRef, "abc", ContentModel.TYPE_FOLDER).getNodeRef();
            child = this.fileFolderService.create(parent, ".TemporaryItems", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef child1 = this.fileFolderService.create(child, "inTemporaryItems", ContentModel.TYPE_FOLDER).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child1, ContentModel.ASPECT_TEMPORARY));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child1, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child1, ContentModel.ASPECT_INDEX_CONTROL));
            children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)1L, (long)children.size());
            FileFilterMode.Client saveClient = FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.script);
            try {
                children = this.fileFolderService.list(parent);
            }
            finally {
                FileFilterMode.setClient((FileFilterMode.Client)saveClient);
            }
            Assert.assertEquals((long)0L, (long)children.size());
            parent = this.fileFolderService.create(this.topNodeRef, "Folder 2", ContentModel.TYPE_FOLDER).getNodeRef();
            child = this.fileFolderService.create(parent, "Thumbs.db", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
            children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)1L, (long)children.size());
            Assert.assertEquals((Object)HiddenAspect.Visibility.Visible, (Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.ftp, child));
            Assert.assertEquals((Object)HiddenAspect.Visibility.Visible, (Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.nfs, child));
            Assert.assertEquals((Object)HiddenAspect.Visibility.Visible, (Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.webdav, child));
            Assert.assertEquals((Object)HiddenAspect.Visibility.HiddenAttribute, (Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.cifs, child));
            Assert.assertEquals((Object)HiddenAspect.Visibility.NotVisible, (Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.script, child));
            Assert.assertEquals((Object)HiddenAspect.Visibility.NotVisible, (Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.webclient, child));
            NodeRef node = this.fileFolderService.create(this.topNodeRef, "surf-config", ContentModel.TYPE_FOLDER).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            FileFilterMode.Client[] clientArray = this.hiddenAspect.getClients();
            int n = clientArray.length;
            int n2 = 0;
            while (n2 < n) {
                client = clientArray[n2];
                if (!client.equals((Object)FileFilterMode.Client.admin)) {
                    Assert.assertEquals((Object)HiddenAspect.Visibility.NotVisible, (Object)this.hiddenAspect.getVisibility(client, node));
                }
                ++n2;
            }
            node = this.fileFolderService.create(this.topNodeRef, ".DS_Store", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            clientArray = this.hiddenAspect.getClients();
            n = clientArray.length;
            n2 = 0;
            while (n2 < n) {
                client = clientArray[n2];
                if (client == FileFilterMode.Client.cifs) {
                    Assert.assertEquals((String)("Should have hidden attribute set for client " + String.valueOf(client)), (Object)HiddenAspect.Visibility.HiddenAttribute, (Object)this.hiddenAspect.getVisibility(client, node));
                } else if (client == FileFilterMode.Client.webdav || client == FileFilterMode.Client.nfs || client == FileFilterMode.Client.ftp) {
                    Assert.assertEquals((String)("Should be visible for client " + String.valueOf(client)), (Object)HiddenAspect.Visibility.Visible, (Object)this.hiddenAspect.getVisibility(client, node));
                } else if (client != FileFilterMode.Client.admin) {
                    Assert.assertEquals((String)("Should not be visible for client " + String.valueOf(client)), (Object)HiddenAspect.Visibility.NotVisible, (Object)this.hiddenAspect.getVisibility(client, node));
                }
                ++n2;
            }
            node = this.fileFolderService.create(this.topNodeRef, "._resourceFork", ContentModel.TYPE_FOLDER).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            clientArray = this.hiddenAspect.getClients();
            n = clientArray.length;
            n2 = 0;
            while (n2 < n) {
                client = clientArray[n2];
                if (client != FileFilterMode.Client.admin && client != FileFilterMode.Client.webdav) {
                    Assert.assertEquals((String)("Client " + client.toString()), (Object)HiddenAspect.Visibility.NotVisible, (Object)this.hiddenAspect.getVisibility(client, node));
                }
                ++n2;
            }
        }
        finally {
            FileFilterMode.clearClient();
        }
    }

    @Test
    public void testClientControlled() throws Exception {
        String nodeName;
        String hiddenNodeName = nodeName = GUID.generate();
        HashMap<QName, String> properties = new HashMap<QName, String>(11);
        properties.put(ContentModel.PROP_NAME, hiddenNodeName);
        QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)hiddenNodeName));
        ChildAssociationRef assocRef = null;
        try {
            assocRef = this.nodeService.createNode(this.topNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_FOLDER, properties);
        }
        catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {
            throw new FileExistsException(this.topNodeRef, hiddenNodeName);
        }
        NodeRef parent = assocRef.getChildRef();
        NodeRef child = null;
        NodeRef child1 = null;
        FileFilterMode.Client saveClient = FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.cmis);
        try {
            this.hiddenAspect.hideNode(parent, true, true, true);
            child = this.fileFolderService.create(parent, "folder11", ContentModel.TYPE_FOLDER).getNodeRef();
            child1 = this.fileFolderService.create(child, "folder21", ContentModel.TYPE_FOLDER).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child1, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child1, ContentModel.ASPECT_INDEX_CONTROL));
            this.fileFolderService.rename(parent, nodeName);
            Assert.assertTrue((boolean)this.nodeService.hasAspect(parent, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(parent, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child1, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child1, ContentModel.ASPECT_INDEX_CONTROL));
        }
        finally {
            FileFilterMode.setClient((FileFilterMode.Client)saveClient);
        }
        List children = this.fileFolderService.list(parent);
        Assert.assertEquals((long)0L, (long)children.size());
        saveClient = FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.script);
        try {
            children = this.fileFolderService.list(parent);
        }
        finally {
            FileFilterMode.setClient((FileFilterMode.Client)saveClient);
        }
        Assert.assertEquals((long)0L, (long)children.size());
        saveClient = FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.cmis);
        try {
            children = this.fileFolderService.list(parent);
        }
        finally {
            FileFilterMode.setClient((FileFilterMode.Client)saveClient);
        }
        Assert.assertEquals((long)0L, (long)children.size());
        saveClient = FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.cmis);
        try {
            this.nodeService.removeAspect(parent, ContentModel.ASPECT_HIDDEN);
            Assert.assertFalse((boolean)this.nodeService.hasAspect(parent, ContentModel.ASPECT_HIDDEN));
        }
        finally {
            FileFilterMode.setClient((FileFilterMode.Client)saveClient);
        }
        NodeRef parent2 = null;
        NodeRef child2 = null;
        NodeRef child12 = null;
        FileFilterMode.Client saveClient2 = FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.cmis);
        try {
            parent2 = this.fileFolderService.create(this.topNodeRef, "." + GUID.generate(), ContentModel.TYPE_FOLDER).getNodeRef();
            child2 = this.fileFolderService.create(parent2, "folder11", ContentModel.TYPE_FOLDER).getNodeRef();
            child12 = this.fileFolderService.create(child2, "folder21", ContentModel.TYPE_FOLDER).getNodeRef();
        }
        finally {
            FileFilterMode.setClient((FileFilterMode.Client)saveClient2);
        }
        Assert.assertTrue((boolean)(this.nodeService.hasAspect(child2, ContentModel.ASPECT_HIDDEN) ^ this.cmisDisableHide));
        Assert.assertTrue((boolean)(this.nodeService.hasAspect(child2, ContentModel.ASPECT_INDEX_CONTROL) ^ this.cmisDisableHide));
        Assert.assertTrue((boolean)(this.nodeService.hasAspect(child12, ContentModel.ASPECT_HIDDEN) ^ this.cmisDisableHide));
        Assert.assertTrue((boolean)(this.nodeService.hasAspect(child12, ContentModel.ASPECT_INDEX_CONTROL) ^ this.cmisDisableHide));
        List children2 = this.fileFolderService.list(parent2);
        Assert.assertEquals((long)(this.cmisDisableHide ? 1 : 0), (long)children2.size());
        saveClient2 = FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.script);
        try {
            children2 = this.fileFolderService.list(parent2);
        }
        finally {
            FileFilterMode.setClient((FileFilterMode.Client)saveClient2);
        }
        Assert.assertEquals((long)(this.cmisDisableHide ? 1 : 0), (long)children2.size());
        saveClient2 = FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.cmis);
        try {
            children2 = this.fileFolderService.list(parent2);
        }
        finally {
            FileFilterMode.setClient((FileFilterMode.Client)saveClient2);
        }
        Assert.assertEquals((long)(this.cmisDisableHide ? 1 : 0), (long)children2.size());
    }

    @Test
    public void testImap() {
        if (this.imapEnabled) {
            FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.webdav);
            try {
                this.imapService.getOrCreateMailbox(this.user, "mailbox_a", false, true);
                this.imapService.renameMailbox(this.user, "mailbox_a", ".mailbox_a");
                Assert.assertFalse((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, "mailbox_a"));
                Assert.assertTrue((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, ".mailbox_a"));
                Assert.assertEquals((String)"Can't rename mailbox", (long)0L, (long)this.numMailboxes(this.user, "mailbox_a"));
                Assert.assertEquals((String)"Can't rename mailbox", (long)1L, (long)this.numMailboxes(this.user, ".mailbox_a"));
            }
            finally {
                FileFilterMode.clearClient();
            }
        }
    }

    @Test
    public void testRename() {
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.webdav);
        try {
            String nodeName = GUID.generate();
            NodeRef node = this.fileFolderService.create(this.topNodeRef, nodeName, ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node11 = this.fileFolderService.create(node, nodeName + ".11", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node12 = this.fileFolderService.create(node, nodeName + ".12", ContentModel.TYPE_CONTENT).getNodeRef();
            NodeRef node21 = this.fileFolderService.create(node11, nodeName + ".21", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node22 = this.fileFolderService.create(node11, nodeName + ".22", ContentModel.TYPE_CONTENT).getNodeRef();
            NodeRef node31 = this.fileFolderService.create(node21, ".31", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node41 = this.fileFolderService.create(node31, nodeName + ".41", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_INDEX_CONTROL));
            try {
                this.fileFolderService.rename(node, "." + nodeName);
            }
            catch (FileExistsException fileExistsException) {
                Assert.fail();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Assert.fail();
            }
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_INDEX_CONTROL));
            try {
                this.fileFolderService.rename(node, nodeName);
            }
            catch (FileExistsException fileExistsException) {
                Assert.fail();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Assert.fail();
            }
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_INDEX_CONTROL));
        }
        finally {
            FileFilterMode.clearClient();
        }
    }

    @Test
    public void testFolderRename() {
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.cmis);
        NodeRef workingCopyNodeRef = null;
        try {
            String guid = GUID.generate();
            String nodeName = "MyFolder" + guid;
            String newName = "AnotherFolder" + guid;
            NodeRef node = this.fileFolderService.create(this.topNodeRef, nodeName, ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef checkedOutNode = this.fileFolderService.create(node, guid + ".lockedchild", ContentModel.TYPE_CONTENT).getNodeRef();
            workingCopyNodeRef = this.cociService.checkout(checkedOutNode);
            Assert.assertNotNull((Object)workingCopyNodeRef);
            Assert.assertTrue((boolean)this.nodeService.hasAspect(checkedOutNode, ContentModel.ASPECT_CHECKED_OUT));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(checkedOutNode, ContentModel.ASPECT_LOCKABLE));
            try {
                this.fileFolderService.rename(node, newName);
            }
            catch (NodeLockedException nodeLockedException) {
                Assert.fail((String)"It should be possible to rename folder with locked items");
            }
            catch (FileExistsException fileExistsException) {
                Assert.fail();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Assert.fail();
            }
        }
        catch (Throwable throwable) {
            this.cociService.cancelCheckout(workingCopyNodeRef);
            FileFilterMode.clearClient();
            throw throwable;
        }
        this.cociService.cancelCheckout(workingCopyNodeRef);
        FileFilterMode.clearClient();
    }

    @Test
    public void testHiddenFilesBasicClient() {
        if (this.imapEnabled) {
            FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.imap);
            try {
                NodeRef parent = this.fileFolderService.create(this.topNodeRef, "New Folder", ContentModel.TYPE_FOLDER).getNodeRef();
                NodeRef child = this.fileFolderService.create(parent, "file.tmp", ContentModel.TYPE_CONTENT).getNodeRef();
                Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
                List children = this.fileFolderService.list(parent);
                Assert.assertEquals((long)1L, (long)children.size());
                parent = this.fileFolderService.create(this.topNodeRef, ".TemporaryItems", ContentModel.TYPE_FOLDER).getNodeRef();
                child = this.fileFolderService.create(parent, "inTemporaryItems", ContentModel.TYPE_FOLDER).getNodeRef();
                Assert.assertFalse((boolean)this.nodeService.hasAspect(parent, ContentModel.ASPECT_TEMPORARY));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(parent, ContentModel.ASPECT_HIDDEN));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(parent, ContentModel.ASPECT_INDEX_CONTROL));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
                children = this.fileFolderService.list(parent);
                Assert.assertEquals((long)1L, (long)children.size());
                parent = this.fileFolderService.create(this.topNodeRef, "Folder 2", ContentModel.TYPE_FOLDER).getNodeRef();
                child = this.fileFolderService.create(parent, "Thumbs.db", ContentModel.TYPE_CONTENT).getNodeRef();
                Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
                children = this.fileFolderService.list(parent);
                Assert.assertEquals((long)1L, (long)children.size());
                NodeRef node = this.fileFolderService.create(this.topNodeRef, "surf-config", ContentModel.TYPE_FOLDER).getNodeRef();
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
                node = this.fileFolderService.create(this.topNodeRef, ".DS_Store", ContentModel.TYPE_CONTENT).getNodeRef();
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
                FileFilterMode.Client[] clientArray = this.hiddenAspect.getClients();
                int n = clientArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FileFilterMode.Client client = clientArray[n2];
                    Assert.assertEquals((String)("Should be visible for client " + String.valueOf(client)), (Object)HiddenAspect.Visibility.Visible, (Object)this.hiddenAspect.getVisibility(client, node));
                    ++n2;
                }
                node = this.fileFolderService.create(this.topNodeRef, "._resourceFork", ContentModel.TYPE_FOLDER).getNodeRef();
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
                children = this.fileFolderService.list(parent);
                Assert.assertEquals((long)1L, (long)children.size());
                String nodeName = "Node" + System.currentTimeMillis();
                node = this.fileFolderService.create(this.topNodeRef, nodeName, ContentModel.TYPE_CONTENT).getNodeRef();
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
                try {
                    this.fileFolderService.rename(node, "." + nodeName);
                }
                catch (FileExistsException fileExistsException) {
                    Assert.fail();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Assert.fail();
                }
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
                try {
                    this.fileFolderService.rename(node, nodeName);
                }
                catch (FileExistsException fileExistsException) {
                    Assert.fail();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Assert.fail();
                }
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
                Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
                this.imapService.getOrCreateMailbox(this.user, "mailbox_a", false, true);
                this.imapService.renameMailbox(this.user, "mailbox_a", ".mailbox_a");
                Assert.assertFalse((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, "mailbox_a"));
                Assert.assertTrue((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, ".mailbox_a"));
                Assert.assertEquals((String)"Can't rename mailbox", (long)0L, (long)this.numMailboxes(this.user, "mailbox_a"));
                Assert.assertEquals((String)"Can't rename mailbox", (long)1L, (long)this.numMailboxes(this.user, ".mailbox_a"));
            }
            finally {
                FileFilterMode.clearClient();
            }
        }
    }

    @Test
    public void testCheckHidden() throws Exception {
        String nodeName = GUID.generate();
        this.interceptor.setEnabled(false);
        try {
            NodeRef node = this.fileFolderService.create(this.topNodeRef, nodeName, ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node11 = this.fileFolderService.create(node, nodeName + ".11", ContentModel.TYPE_FOLDER).getNodeRef();
            this.fileFolderService.create(node, ".12", ContentModel.TYPE_CONTENT).getNodeRef();
            NodeRef node21 = this.fileFolderService.create(node11, nodeName + ".21", ContentModel.TYPE_FOLDER).getNodeRef();
            this.fileFolderService.create(node11, nodeName + ".22", ContentModel.TYPE_CONTENT).getNodeRef();
            NodeRef node31 = this.fileFolderService.create(node21, ".31", ContentModel.TYPE_FOLDER).getNodeRef();
            this.fileFolderService.create(node31, nodeName + ".41", ContentModel.TYPE_CONTENT).getNodeRef();
            this.txn.commit();
        }
        finally {
            this.interceptor.setEnabled(true);
        }
    }

    @Test
    public void testHideNodeExplicit() throws Exception {
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.cifs);
        try {
            NodeRef parent = this.fileFolderService.create(this.topNodeRef, "New Folder", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef childA = this.fileFolderService.create(parent, "fileA", ContentModel.TYPE_CONTENT).getNodeRef();
            NodeRef childB = this.fileFolderService.create(parent, "Thumbs.db", ContentModel.TYPE_CONTENT).getNodeRef();
            this.hiddenAspect.hideNodeExplicit(childA);
            Assert.assertTrue((String)"node a should be hidden", (boolean)this.nodeService.hasAspect(childA, ContentModel.ASPECT_HIDDEN));
            List children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)2L, (long)children.size());
            this.hiddenAspect.unhideExplicit(childA);
            this.hiddenAspect.unhideExplicit(childB);
            Assert.assertFalse((boolean)this.nodeService.hasAspect(childA, ContentModel.ASPECT_HIDDEN));
            this.hiddenAspect.checkHidden(childA, true, false);
            children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)2L, (long)children.size());
            Assert.assertFalse((boolean)this.nodeService.hasAspect(childA, ContentModel.ASPECT_HIDDEN));
            children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)2L, (long)children.size());
        }
        finally {
            FileFilterMode.clearClient();
        }
    }

    private List<NodeRef> getHiddenNodes(final StoreRef storeRef) {
        final ArrayList<NodeRef> nodes = new ArrayList<NodeRef>(20);
        NodeDAO.NodeRefQueryCallback resultsCallback = new NodeDAO.NodeRefQueryCallback(){

            public boolean handle(Pair<Long, NodeRef> nodePair) {
                if (storeRef == null || ((NodeRef)nodePair.getSecond()).getStoreRef().equals((Object)storeRef)) {
                    nodes.add((NodeRef)nodePair.getSecond());
                }
                return true;
            }
        };
        this.nodeDAO.getNodesWithAspects(Collections.singleton(ContentModel.ASPECT_HIDDEN), Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE), resultsCallback);
        return nodes;
    }

    private int numMailboxes(AlfrescoImapUser user, String mailboxName) {
        int numMailboxes = 0;
        try {
            List folders = this.imapService.listMailboxes(user, mailboxName, false);
            numMailboxes = folders.size();
        }
        catch (AlfrescoRuntimeException e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
        return numMailboxes;
    }

    private boolean checkMailbox(AlfrescoImapUser user, String mailboxName) {
        try {
            this.imapService.getOrCreateMailbox(user, mailboxName, true, false);
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            return false;
        }
        return true;
    }
}

