/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.impl.solr.SolrCategoryServiceImpl;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SolrCategoryServiceImplTest {
    private static final String PATH_ROOT = "-root-";
    private static final String CAT_ROOT_NODE_ID = "cat-root-node-id";
    private static final String NODE_ID_PREFIX = "node-id-";
    private static final StoreRef STORE_REF = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
    @Mock
    private NodeService nodeServiceMock;
    @Mock
    private ChildAssociationRef categoryRootChildAssociationRefMock;
    @Mock
    private ChildAssociationRef categoryChildAssociationRefMock;
    @Mock
    private IndexerAndSearcher indexerAndSearcherMock;
    @Mock
    private SearchService searcherMock;
    @Mock
    private DictionaryService dictionaryServiceMock;
    @Mock
    private AspectDefinition aspectDefinitionMock;
    @Mock
    private ResultSet resultSetMock;
    @InjectMocks
    private SolrCategoryServiceImpl objectUnderTest;

    @Test
    public void testGetRootCategoryNodeRef() {
        NodeRef rootNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, PATH_ROOT);
        BDDMockito.given((Object)this.nodeServiceMock.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE)).willReturn((Object)rootNodeRef);
        BDDMockito.given((Object)this.nodeServiceMock.getChildAssocs(rootNodeRef, Set.of(ContentModel.TYPE_CATEGORYROOT))).willReturn(List.of(this.categoryRootChildAssociationRefMock));
        BDDMockito.given((Object)this.categoryChildAssociationRefMock.getQName()).willReturn((Object)ContentModel.ASPECT_GEN_CLASSIFIABLE);
        NodeRef categoryRootNodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, CAT_ROOT_NODE_ID);
        BDDMockito.given((Object)this.categoryChildAssociationRefMock.getChildRef()).willReturn((Object)categoryRootNodeRef);
        BDDMockito.given((Object)this.nodeServiceMock.getChildAssocs(this.categoryRootChildAssociationRefMock.getChildRef())).willReturn(List.of(this.categoryChildAssociationRefMock));
        Optional rooCategoryNodeRef = this.objectUnderTest.getRootCategoryNodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(rootNodeRef, Set.of(ContentModel.TYPE_CATEGORYROOT));
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should()).getChildAssocs(this.categoryRootChildAssociationRefMock.getChildRef());
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        Assert.assertTrue((boolean)rooCategoryNodeRef.isPresent());
        Assert.assertEquals((Object)CAT_ROOT_NODE_ID, (Object)((NodeRef)rooCategoryNodeRef.get()).getId());
    }

    @Test
    public void testGetTopCategories() {
        BDDMockito.given((Object)this.indexerAndSearcherMock.getSearcher(STORE_REF, false)).willReturn((Object)this.searcherMock);
        QName aspectGenClassifiable = ContentModel.ASPECT_GEN_CLASSIFIABLE;
        this.mockAspectDefinition(ContentModel.PROP_CATEGORIES, null);
        BDDMockito.given((Object)this.dictionaryServiceMock.getAspect(aspectGenClassifiable)).willReturn((Object)this.aspectDefinitionMock);
        QName categoryProperty = ContentModel.PROP_CATEGORIES;
        String field = this.getField(categoryProperty);
        SearchParameters searchParameters = this.prepareSearchParams(STORE_REF, categoryProperty, field, 100);
        List<Integer> countList = List.of(Integer.valueOf(11), Integer.valueOf(9), Integer.valueOf(8));
        this.mockResultSet(field, countList);
        BDDMockito.given((Object)this.searcherMock.query(searchParameters)).willReturn((Object)this.resultSetMock);
        BDDMockito.given((Object)this.nodeServiceMock.exists((NodeRef)ArgumentMatchers.any(NodeRef.class))).willReturn((Object)true);
        List topCategories = this.objectUnderTest.getTopCategories(STORE_REF, aspectGenClassifiable, 100);
        ((IndexerAndSearcher)BDDMockito.then((Object)this.indexerAndSearcherMock).should()).getSearcher(STORE_REF, false);
        BDDMockito.then((Object)this.indexerAndSearcherMock).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryServiceMock).should()).getAspect(aspectGenClassifiable);
        BDDMockito.then((Object)this.dictionaryServiceMock).shouldHaveNoMoreInteractions();
        ((SearchService)BDDMockito.then((Object)this.searcherMock).should()).query(searchParameters);
        BDDMockito.then((Object)this.searcherMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should(Mockito.times((int)3))).exists((NodeRef)ArgumentMatchers.any(NodeRef.class));
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        IntStream.range(0, countList.size()).forEach(i -> {
            NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, NODE_ID_PREFIX + i);
            Assert.assertEquals((Object)nodeRef, (Object)((Pair)topCategories.get(i)).getFirst());
            Assert.assertEquals(countList.get(i), (Object)((Pair)topCategories.get(i)).getSecond());
        });
    }

    @Test
    public void testGetTopCategories_nonExistingAspect() {
        QName aspectGenClassifiable = ContentModel.ASPECT_GEN_CLASSIFIABLE;
        BDDMockito.given((Object)this.dictionaryServiceMock.getAspect(aspectGenClassifiable)).willReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> {
            List list = this.objectUnderTest.getTopCategories(STORE_REF, aspectGenClassifiable, 100);
        });
        BDDMockito.then((Object)this.indexerAndSearcherMock).shouldHaveNoInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryServiceMock).should()).getAspect(aspectGenClassifiable);
        BDDMockito.then((Object)this.dictionaryServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.searcherMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testGetTopCategories_customCategoryAspect() {
        BDDMockito.given((Object)this.indexerAndSearcherMock.getSearcher(STORE_REF, false)).willReturn((Object)this.searcherMock);
        QName aspectCustomCategories = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"customcategories");
        this.mockAspectDefinition(aspectCustomCategories, DataTypeDefinition.CATEGORY);
        BDDMockito.given((Object)this.dictionaryServiceMock.getAspect(aspectCustomCategories)).willReturn((Object)this.aspectDefinitionMock);
        String field = this.getField(aspectCustomCategories);
        SearchParameters searchParameters = this.prepareSearchParams(STORE_REF, aspectCustomCategories, field, 100);
        List<Integer> countList = List.of(Integer.valueOf(11), Integer.valueOf(9), Integer.valueOf(8));
        this.mockResultSet(field, countList);
        BDDMockito.given((Object)this.searcherMock.query(searchParameters)).willReturn((Object)this.resultSetMock);
        BDDMockito.given((Object)this.nodeServiceMock.exists((NodeRef)ArgumentMatchers.any(NodeRef.class))).willReturn((Object)true);
        List topCategories = this.objectUnderTest.getTopCategories(STORE_REF, aspectCustomCategories, 100);
        ((IndexerAndSearcher)BDDMockito.then((Object)this.indexerAndSearcherMock).should()).getSearcher(STORE_REF, false);
        BDDMockito.then((Object)this.indexerAndSearcherMock).shouldHaveNoMoreInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryServiceMock).should()).getAspect(aspectCustomCategories);
        BDDMockito.then((Object)this.dictionaryServiceMock).shouldHaveNoMoreInteractions();
        ((SearchService)BDDMockito.then((Object)this.searcherMock).should()).query(searchParameters);
        BDDMockito.then((Object)this.searcherMock).shouldHaveNoMoreInteractions();
        ((NodeService)BDDMockito.then((Object)this.nodeServiceMock).should(Mockito.times((int)3))).exists((NodeRef)ArgumentMatchers.any(NodeRef.class));
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoMoreInteractions();
        IntStream.range(0, countList.size()).forEach(i -> {
            NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, NODE_ID_PREFIX + i);
            Assert.assertEquals((Object)nodeRef, (Object)((Pair)topCategories.get(i)).getFirst());
            Assert.assertEquals(countList.get(i), (Object)((Pair)topCategories.get(i)).getSecond());
        });
    }

    @Test
    public void testGetTopCategories_invalidCustomCategoryAspect() {
        QName aspectCustomCategories = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"customcategories");
        this.mockAspectDefinition(aspectCustomCategories, DataTypeDefinition.QNAME);
        BDDMockito.given((Object)this.dictionaryServiceMock.getAspect(aspectCustomCategories)).willReturn((Object)this.aspectDefinitionMock);
        this.getField(aspectCustomCategories);
        Assert.assertThrows(IllegalStateException.class, () -> {
            List list = this.objectUnderTest.getTopCategories(STORE_REF, aspectCustomCategories, 100);
        });
        BDDMockito.then((Object)this.indexerAndSearcherMock).shouldHaveNoInteractions();
        ((DictionaryService)BDDMockito.then((Object)this.dictionaryServiceMock).should()).getAspect(aspectCustomCategories);
        BDDMockito.then((Object)this.dictionaryServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.searcherMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.nodeServiceMock).shouldHaveNoInteractions();
    }

    private String getField(QName categoryProperty) {
        return "@" + String.valueOf(categoryProperty);
    }

    private SearchParameters prepareSearchParams(StoreRef storeRef, QName categoryProperty, String field, int count) {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("index-fts-alfresco");
        sp.addStore(storeRef);
        sp.setQuery(String.valueOf(categoryProperty) + ":*");
        SearchParameters.FieldFacet ff = new SearchParameters.FieldFacet(field);
        ff.setLimitOrNull(Integer.valueOf(count));
        sp.addFieldFacet(ff);
        sp.setMaxItems(1);
        sp.setSkipCount(0);
        return sp;
    }

    private void mockResultSet(String field, List<Integer> countList) {
        List facetedResults = IntStream.range(0, countList.size()).mapToObj(i -> new Pair((Object)(String.valueOf(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE) + "/node-id-" + i), (Object)((Integer)countList.get(i)))).collect(Collectors.toList());
        BDDMockito.given((Object)this.resultSetMock.getFieldFacet(field)).willReturn(CollectionUtils.isEmpty(facetedResults) ? null : facetedResults);
    }

    private void mockAspectDefinition(QName qName, QName dataType) {
        PropertyDefinition propertyDefinitionMock = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        DataTypeDefinition dataTypeMock = (DataTypeDefinition)Mockito.mock(DataTypeDefinition.class);
        if (dataType != null) {
            BDDMockito.given((Object)propertyDefinitionMock.getDataType()).willReturn((Object)dataTypeMock);
            BDDMockito.given((Object)dataTypeMock.getName()).willReturn((Object)dataType);
        }
        BDDMockito.given((Object)this.aspectDefinitionMock.getProperties()).willReturn(Map.of(qName, propertyDefinitionMock));
    }
}

