/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import org.alfresco.repo.event.v1.model.ChildAssociationResource;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event2.ChildAssociationEventSupportedPolicies;
import org.alfresco.repo.event2.EventConsolidator;
import org.alfresco.repo.event2.NodeResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.namespace.QName;

public class ChildAssociationEventConsolidator
extends EventConsolidator<ChildAssociationRef, ChildAssociationResource>
implements ChildAssociationEventSupportedPolicies {
    public ChildAssociationEventConsolidator(ChildAssociationRef childAssociationRef, NodeResourceHelper helper) {
        super(childAssociationRef, helper);
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssociationRef, boolean isNewNode) {
        this.eventTypes.add(EventType.CHILD_ASSOC_CREATED);
        this.resource = this.buildChildAssociationResource(childAssociationRef);
    }

    @Override
    public void beforeDeleteChildAssociation(ChildAssociationRef childAssociationRef) {
        this.eventTypes.add(EventType.CHILD_ASSOC_DELETED);
        this.resource = this.buildChildAssociationResource(childAssociationRef);
    }

    private ChildAssociationResource buildChildAssociationResource(ChildAssociationRef childAssociationRef) {
        String parentId = childAssociationRef.getParentRef().getId();
        String childId = childAssociationRef.getChildRef().getId();
        String assocQName = this.helper.getQNamePrefixString(childAssociationRef.getQName());
        String assocType = this.helper.getQNamePrefixString(childAssociationRef.getTypeQName());
        return new ChildAssociationResource(parentId, childId, assocType, assocQName);
    }

    @Override
    protected EventType getDerivedEvent() {
        if (this.isTemporaryEntity()) {
            return EventType.CHILD_ASSOC_DELETED;
        }
        if (this.eventTypes.contains(EventType.CHILD_ASSOC_CREATED)) {
            return EventType.CHILD_ASSOC_CREATED;
        }
        if (this.eventTypes.getLast() == EventType.CHILD_ASSOC_DELETED) {
            return EventType.CHILD_ASSOC_DELETED;
        }
        return (EventType)this.eventTypes.getFirst();
    }

    @Override
    public boolean isTemporaryEntity() {
        return this.eventTypes.contains(EventType.CHILD_ASSOC_CREATED) && this.eventTypes.getLast() == EventType.CHILD_ASSOC_DELETED;
    }

    @Override
    public QName getEntityType() {
        return ((ChildAssociationRef)this.entityReference).getTypeQName();
    }
}

