/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.query.AbstractCannedQueryFactory;
import org.alfresco.query.CannedQuery;
import org.alfresco.query.CannedQueryPageDetails;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.security.person.GetPeopleCannedQuery;
import org.alfresco.repo.security.person.GetPeopleCannedQueryParams;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;

public class GetPeopleCannedQueryFactory
extends AbstractCannedQueryFactory<NodeRef> {
    protected NodeDAO nodeDAO;
    protected QNameDAO qnameDAO;
    protected CannedQueryDAO cannedQueryDAO;
    protected TenantService tenantService;
    protected NodeService nodeService;
    protected AuthorityService authorityService;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setCannedQueryDAO(CannedQueryDAO cannedQueryDAO) {
        this.cannedQueryDAO = cannedQueryDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public CannedQuery<NodeRef> getCannedQuery(CannedQueryParameters parameters) {
        return new GetPeopleCannedQuery(this.nodeDAO, this.qnameDAO, this.cannedQueryDAO, this.tenantService, this.nodeService, this.authorityService, parameters);
    }

    public CannedQuery<NodeRef> getCannedQuery(NodeRef parentRef, String pattern, List<QName> filterProps, Set<QName> inclusiveAspects, Set<QName> exclusiveAspects, boolean includeAdministrators, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"parentRef", (Object)parentRef);
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        int requestTotalCountMax = pagingRequest.getRequestTotalCountMax();
        GetPeopleCannedQueryParams paramBean = new GetPeopleCannedQueryParams(this.tenantService.getName(parentRef), filterProps, pattern, inclusiveAspects, exclusiveAspects, includeAdministrators);
        CannedQueryPageDetails cqpd = new CannedQueryPageDetails(pagingRequest.getSkipCount(), pagingRequest.getMaxItems(), 1, 1);
        CannedQuerySortDetails cqsd = null;
        if (sortProps != null) {
            ArrayList<Pair> sortPairs = new ArrayList<Pair>(sortProps.size());
            for (Pair<QName, Boolean> sortProp : sortProps) {
                boolean sortAsc = sortProp.getSecond() == null || (Boolean)sortProp.getSecond() != false;
                sortPairs.add(new Pair((Object)((QName)sortProp.getFirst()), (Object)(sortAsc ? CannedQuerySortDetails.SortOrder.ASCENDING : CannedQuerySortDetails.SortOrder.DESCENDING)));
            }
            cqsd = new CannedQuerySortDetails(sortPairs);
        }
        CannedQueryParameters params = new CannedQueryParameters((Object)paramBean, cqpd, cqsd, requestTotalCountMax, pagingRequest.getQueryExecutionId());
        return this.getCannedQuery(params);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        PropertyCheck.mandatory((Object)((Object)this), (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"nodeDAO", (Object)this.nodeDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"qnameDAO", (Object)this.qnameDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"cannedQueryDAO", (Object)this.cannedQueryDAO);
    }
}

