/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.MultiTNodeServiceInterceptor;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class MultiTNodeServiceInterceptorTest
extends TestCase {
    public static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private String tenant1 = "tenant-" + GUID.generate();
    private String tenant1Pwd = "pwd1";
    private boolean enableTest = true;
    private TransactionService transactionService;
    private TenantAdminService tenantAdminService;
    private TenantService tenantService;
    private MultiTNodeServiceInterceptor interceptor;

    public void setUp() throws Exception {
        this.transactionService = (TransactionService)ctx.getBean("TransactionService");
        this.tenantAdminService = (TenantAdminService)ctx.getBean("tenantAdminService");
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        this.interceptor = (MultiTNodeServiceInterceptor)ctx.getBean("multiTNodeServiceInterceptor");
        if (!this.tenantAdminService.isEnabled()) {
            this.enableTest = false;
            return;
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                RetryingTransactionHelper.RetryingTransactionCallback<Object> createTenantCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Throwable {
                        (this).MultiTNodeServiceInterceptorTest.this.tenantAdminService.createTenant((this).MultiTNodeServiceInterceptorTest.this.tenant1, (this).MultiTNodeServiceInterceptorTest.this.tenant1Pwd.toCharArray());
                        return null;
                    }
                };
                MultiTNodeServiceInterceptorTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTenantCallback, false, true);
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    public void tearDown() throws Exception {
        if (!this.tenantAdminService.isEnabled()) {
            return;
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                RetryingTransactionHelper.RetryingTransactionCallback<Object> deleteTenantCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Throwable {
                        (this).MultiTNodeServiceInterceptorTest.this.tenantAdminService.deleteTenant((this).MultiTNodeServiceInterceptorTest.this.tenant1);
                        return null;
                    }
                };
                MultiTNodeServiceInterceptorTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteTenantCallback, false, true);
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    public void testSetUp() {
    }
}

