/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.io.IOException;
import org.alfresco.repo.descriptor.DescriptorServiceAvailableEvent;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.EncryptedContentStoreChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanState;
import org.alfresco.repo.management.subsystems.SwitchableApplicationContextFactory;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationEvent;

public class CryptodocSwitchableApplicationContextFactory
extends SwitchableApplicationContextFactory {
    private DescriptorService descriptorService;
    private static final Log logger = LogFactory.getLog(CryptodocSwitchableApplicationContextFactory.class);

    @Override
    protected PropertyBackedBeanState createInitialState() throws IOException {
        return new CryptoSwitchableState(this.sourceBeanName);
    }

    private boolean canSwitchSubsystemTo(Object newSourceBean, String beanName) {
        Object currentSourceBean = this.getParent().getBean(this.getCurrentSourceBeanName());
        boolean isCurrentEncrypted = this.isEncryptedContentStoreSubsystem(currentSourceBean, this.getCurrentSourceBeanName());
        if (!isCurrentEncrypted) {
            return true;
        }
        boolean isNewEncrypted = this.isEncryptedContentStoreSubsystem(newSourceBean, beanName);
        return isCurrentEncrypted && isNewEncrypted;
    }

    private boolean isEncryptedContentStoreSubsystem(Object sourceBean, String beanName) {
        boolean isEncrypted = false;
        if (sourceBean instanceof EncryptedContentStoreChildApplicationContextFactory) {
            isEncrypted = ((EncryptedContentStoreChildApplicationContextFactory)sourceBean).isEncryptedContent();
        }
        if (!isEncrypted) {
            isEncrypted = beanName.equals("encryptedContentStore");
        }
        return isEncrypted;
    }

    private boolean isEncryptionSupported() {
        boolean isSupported = true;
        if (this.descriptorService != null) {
            LicenseDescriptor license = this.descriptorService.getLicenseDescriptor();
            isSupported = license != null && license.isCryptodocEnabled();
        }
        return isSupported;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("event : " + String.valueOf(event)));
        }
        if (event instanceof DescriptorServiceAvailableEvent) {
            this.descriptorService = ((DescriptorServiceAvailableEvent)event).getDescriptorService();
        }
        super.onApplicationEvent(event);
    }

    protected class CryptoSwitchableState
    extends SwitchableApplicationContextFactory.SwitchableState {
        protected CryptoSwitchableState(String sourceBeanName) {
            super(sourceBeanName);
        }

        @Override
        public void setProperty(String name, String value) {
            if (name.equals("sourceBeanName")) {
                ChildApplicationContextFactory newSourceBean;
                try {
                    newSourceBean = (ChildApplicationContextFactory)CryptodocSwitchableApplicationContextFactory.this.getParent().getBean(value, ChildApplicationContextFactory.class);
                }
                catch (BeansException beansException) {
                    throw new IllegalStateException("Switching to the unknown content store \"" + value + "\" is not possible.");
                }
                if (CryptodocSwitchableApplicationContextFactory.this.canSwitchSubsystemTo(newSourceBean, value)) {
                    boolean isNewEncrypted = CryptodocSwitchableApplicationContextFactory.this.isEncryptedContentStoreSubsystem(newSourceBean, value);
                    if (isNewEncrypted && !CryptodocSwitchableApplicationContextFactory.this.isEncryptionSupported()) {
                        throw new IllegalStateException("Switching to the encrypted content store \"" + value + "\" is not licensed.");
                    }
                } else {
                    throw new IllegalStateException("Switching to the unencrypted content store \"" + value + "\" is not possible.");
                }
            }
            super.setProperty(name, value);
        }
    }
}

