/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.Map;
import org.alfresco.repo.rendition2.RenditionDefinition2Impl;
import org.alfresco.repo.rendition2.RenditionDefinitionRegistry2Impl;

public class TransformDefinition
extends RenditionDefinition2Impl {
    public static final String TRANSFORM_NAMESPACE = "transform:";
    private final String clientData;
    private final String replyQueue;
    private final String requestId;
    private String errorMessage;

    public TransformDefinition(String transformName, String targetMimetype, Map<String, String> transformOptions, String clientData, String replyQueue, String requestId, RenditionDefinitionRegistry2Impl registry) {
        super(TransformDefinition.convertToRenditionName(transformName), targetMimetype, transformOptions, registry);
        this.clientData = clientData;
        this.replyQueue = replyQueue;
        this.requestId = requestId;
        this.errorMessage = null;
    }

    public TransformDefinition(String targetMimetype, Map<String, String> transformOptions, String clientData, String replyQueue, String requestId) {
        this(null, targetMimetype, transformOptions, clientData, replyQueue, requestId, null);
    }

    public static String convertToRenditionName(String transformName) {
        return transformName == null ? null : TRANSFORM_NAMESPACE + transformName;
    }

    public String getTransformName() {
        String renditionName = this.getRenditionName();
        return TransformDefinition.getTransformName(renditionName);
    }

    public static String getTransformName(String renditionName) {
        return renditionName == null || !renditionName.startsWith(TRANSFORM_NAMESPACE) ? null : renditionName.substring(TRANSFORM_NAMESPACE.length());
    }

    public String getClientData() {
        return this.clientData;
    }

    public String getReplyQueue() {
        return this.replyQueue;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

