/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import java.io.Serializable;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.MySQLInnoDBDialect;
import org.alfresco.repo.domain.propval.DefaultPropertyTypeConverter;
import org.alfresco.repo.domain.propval.PropertyTypeConverter;
import org.alfresco.repo.domain.propval.PropertyValueEntity;
import org.alfresco.repo.domain.schema.SchemaBootstrap;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={OwnJVMTestsCategory.class})
public class PropertyTypeConverterTest {
    private int stringLen;

    @Before
    public void setMaxStringLength() {
        this.stringLen = SchemaBootstrap.getMaxStringLength();
        SchemaBootstrap.setMaxStringLength((int)2000, (Dialect)new MySQLInnoDBDialect());
    }

    @After
    public void resetMaxStringLength() {
        SchemaBootstrap.setMaxStringLength((int)this.stringLen, (Dialect)new MySQLInnoDBDialect());
    }

    @Test
    public void testGetPersistentTypeForStrings() {
        DefaultPropertyTypeConverter defaultPropertyTypeConverter = new DefaultPropertyTypeConverter();
        PropertyValueEntity.PersistedType persistedType = PropertyValueEntity.getPersistedTypeEnum((Serializable)((Object)"test"), (PropertyTypeConverter)defaultPropertyTypeConverter);
        Assert.assertEquals((Object)PropertyValueEntity.PersistedType.STRING, (Object)persistedType);
        String stringValue = RandomStringUtils.randomAlphanumeric((int)2001);
        persistedType = PropertyValueEntity.getPersistedTypeEnum((Serializable)((Object)stringValue), (PropertyTypeConverter)defaultPropertyTypeConverter);
        Assert.assertEquals((Object)PropertyValueEntity.PersistedType.SERIALIZABLE, (Object)persistedType);
        stringValue = RandomStringUtils.randomAlphanumeric((int)1999);
        persistedType = PropertyValueEntity.getPersistedTypeEnum((Serializable)((Object)stringValue), (PropertyTypeConverter)defaultPropertyTypeConverter);
        Assert.assertEquals((Object)PropertyValueEntity.PersistedType.STRING, (Object)persistedType);
    }
}

