/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.management.subsystems.SwitchableApplicationContextFactory;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryEngine;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.permissions.AccessControlList;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.DBTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class ACS1907Test
extends TestCase {
    private ApplicationContext ctx;
    private NodeService nodeService;
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    private SearchService pubSearchService;
    private PermissionService pubPermissionService;
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private DBQueryEngine queryEngine;
    private TransactionalCache<Serializable, AccessControlList> aclCache;
    private TransactionalCache<Serializable, Object> aclEntityCache;
    private TransactionalCache<Serializable, Object> permissionEntityCache;
    private NodeRef rootNodeRef;

    public void setUp() throws Exception {
        this.setupServices();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.setupTestUsers();
        this.setupTestContent();
        this.dropCaches();
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    private void setupServices() {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.nodeService = (NodeService)this.ctx.getBean("dbNodeService");
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.authenticationService = (MutableAuthenticationService)this.ctx.getBean("authenticationService");
        this.authenticationDAO = (MutableAuthenticationDao)this.ctx.getBean("authenticationDao");
        this.pubSearchService = (SearchService)this.ctx.getBean("SearchService");
        this.pubPermissionService = (PermissionService)this.ctx.getBean("PermissionService");
        this.transactionService = (TransactionService)this.ctx.getBean("TransactionService");
        this.aclCache = (TransactionalCache)this.ctx.getBean("aclCache");
        this.aclEntityCache = (TransactionalCache)this.ctx.getBean("aclEntityCache");
        this.permissionEntityCache = (TransactionalCache)this.ctx.getBean("permissionEntityCache");
        SwitchableApplicationContextFactory searchContextFactory = (SwitchableApplicationContextFactory)this.ctx.getBean("Search");
        ApplicationContext searchCtx = searchContextFactory.getApplicationContext();
        this.queryEngine = (DBQueryEngine)searchCtx.getBean("search.dbQueryEngineImpl");
        this.txnHelper = new RetryingTransactionHelper();
        this.txnHelper.setTransactionService(this.transactionService);
        this.txnHelper.setReadOnly(false);
        this.txnHelper.setMaxRetries(1);
        this.txnHelper.setMinRetryWaitMs(1);
        this.txnHelper.setMaxRetryWaitMs(10);
        this.txnHelper.setRetryWaitIncrementMs(1);
    }

    private void setupTestUser(String userName) {
        if (!this.authenticationDAO.userExists(userName)) {
            this.authenticationService.createAuthentication(userName, userName.toCharArray());
        }
    }

    private void setupTestUsers() {
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                ACS1907Test.this.setupTestUser("userA");
                ACS1907Test.this.setupTestUser("userB");
                ACS1907Test.this.setupTestUser(AuthenticationUtil.getAdminUserName());
                return null;
            }
        }, false, false);
    }

    private void setupTestContent() {
        int f = 0;
        while (f < 5) {
            final int ff = f++;
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    HashMap<QName, CallSite> testFolderProps = new HashMap<QName, CallSite>();
                    testFolderProps.put(ContentModel.PROP_NAME, (CallSite)((Object)("folder" + ff)));
                    NodeRef testFolder = ACS1907Test.this.nodeService.createNode(ACS1907Test.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"https://example.com/test", (String)("folder" + ff)), ContentModel.TYPE_FOLDER, testFolderProps).getChildRef();
                    int c = 0;
                    while (c < 5) {
                        HashMap<QName, CallSite> testContentProps = new HashMap<QName, CallSite>();
                        testContentProps.put(ContentModel.PROP_NAME, (CallSite)((Object)("content" + c)));
                        NodeRef testContent = ACS1907Test.this.nodeService.createNode(testFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"https://example.com/test", (String)("content" + c)), ContentModel.TYPE_CONTENT, testContentProps).getChildRef();
                        String user = c % 2 == 0 ? "userA" : "userB";
                        ACS1907Test.this.pubPermissionService.setPermission(testContent, user, "Read", true);
                        ++c;
                    }
                    return null;
                }
            }, false, false);
        }
    }

    private void dropCaches() {
        this.aclCache.clear();
        this.aclEntityCache.clear();
        this.permissionEntityCache.clear();
    }

    public void testACS1907() {
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        SearchParameters sp = new SearchParameters();
                        sp.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
                        sp.setLanguage("fts-alfresco");
                        sp.setQueryConsistency(QueryConsistency.TRANSACTIONAL);
                        sp.setQuery("TYPE:\"cm:content\"");
                        ResultSet rs = (this).ACS1907Test.this.pubSearchService.query(sp);
                        for (ResultSetRow row : rs) {
                            ACS1907Test.assertNotNull((Object)row.getValue(ContentModel.PROP_NAME));
                        }
                        return null;
                    }
                }, (String)"userA");
                return null;
            }
        }, false, false);
    }

    public void testPaging() {
        HashSet<NodeRef> resultPageSize2 = this.queryNodes(2);
        HashSet<NodeRef> resultPageSize5 = this.queryNodes(5);
        HashSet<NodeRef> resultPageSize10 = this.queryNodes(10);
        HashSet<NodeRef> resultPageSizeAll = this.queryNodes(10000);
        ACS1907Test.assertTrue((resultPageSize2.size() >= 25 ? 1 : 0) != 0);
        ACS1907Test.assertTrue((resultPageSize5.size() >= 25 ? 1 : 0) != 0);
        ACS1907Test.assertTrue((resultPageSize10.size() >= 25 ? 1 : 0) != 0);
        ACS1907Test.assertTrue((resultPageSizeAll.size() >= 25 ? 1 : 0) != 0);
        ACS1907Test.assertTrue((boolean)resultPageSize2.containsAll(resultPageSize5));
        ACS1907Test.assertTrue((boolean)resultPageSize2.containsAll(resultPageSize10));
        ACS1907Test.assertTrue((boolean)resultPageSize2.containsAll(resultPageSizeAll));
        ACS1907Test.assertTrue((boolean)resultPageSize5.containsAll(resultPageSize2));
        ACS1907Test.assertTrue((boolean)resultPageSize5.containsAll(resultPageSize10));
        ACS1907Test.assertTrue((boolean)resultPageSize5.containsAll(resultPageSizeAll));
        ACS1907Test.assertTrue((boolean)resultPageSize10.containsAll(resultPageSize2));
        ACS1907Test.assertTrue((boolean)resultPageSize10.containsAll(resultPageSize5));
        ACS1907Test.assertTrue((boolean)resultPageSize10.containsAll(resultPageSizeAll));
        ACS1907Test.assertTrue((boolean)resultPageSizeAll.containsAll(resultPageSize2));
        ACS1907Test.assertTrue((boolean)resultPageSizeAll.containsAll(resultPageSize5));
        ACS1907Test.assertTrue((boolean)resultPageSizeAll.containsAll(resultPageSize10));
        this.queryEngine.setMinPagingBatchSize(2500);
        this.queryEngine.setMaxPagingBatchSize(10000);
    }

    HashSet<NodeRef> queryNodes(int pageSize) {
        this.queryEngine.setMinPagingBatchSize(pageSize);
        this.queryEngine.setMaxPagingBatchSize(pageSize);
        HashSet<NodeRef> result = new HashSet<NodeRef>();
        SearchParameters sp = new SearchParameters();
        sp.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        sp.setLanguage("fts-alfresco");
        sp.setQueryConsistency(QueryConsistency.TRANSACTIONAL);
        sp.setQuery("TYPE:\"cm:content\"");
        ResultSet rs = this.pubSearchService.query(sp);
        for (ResultSetRow row : rs) {
            result.add(row.getNodeRef());
        }
        return result;
    }
}

