/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.GetParentReferenceMethod;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.junit.Test;

public class GetParentReferenceMethodTest
extends TestCase {
    private GetParentReferenceMethod method;

    protected void setUp() throws Exception {
        this.method = new GetParentReferenceMethod();
    }

    @Test
    public void testSpacePath() throws Exception {
        GetParentReferenceMethodTest.assertEquals((String)"/Media types", (String)this.toParentPath("/Media types/Images"));
    }

    @Test
    public void testTrailingPath() throws Exception {
        GetParentReferenceMethodTest.assertEquals((String)"/Media types", (String)this.toParentPath("/Media types/Images/"));
    }

    @Test
    public void testFirsLevelPath() throws Exception {
        GetParentReferenceMethodTest.assertEquals((String)"/", (String)this.toParentPath("/Media types"));
    }

    @Test
    public void testTrailingRoot() throws Exception {
        GetParentReferenceMethodTest.assertNull((Object)this.toParentPath("/ "));
    }

    @Test
    public void testRootPath() throws Exception {
        GetParentReferenceMethodTest.assertNull((Object)this.toParentPath("/"));
    }

    private String toParentPath(String path) throws ProtocolMethodException {
        List<Parameter> params = Arrays.asList(new StringParameter(path));
        Reference ref = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)new ClasspathResource("/some/class/path.js"), params);
        Reference parent = (Reference)ref.execute((ProtocolMethod)this.method);
        if (parent == null) {
            return null;
        }
        StringParameter parentPath = (StringParameter)parent.getParameters().get(0);
        return (String)parentPath.getValue();
    }
}

