/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.servlet;

import jakarta.servlet.ServletContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;
import org.springframework.web.context.ServletContextAware;

public class LocalTestRunAsAuthenticatorFactory
implements ServletAuthenticatorFactory,
ServletContextAware {
    public void setServletContext(ServletContext context) {
    }

    public Authenticator create(WebScriptServletRequest req, WebScriptServletResponse res) {
        String runAsUser = AuthenticationUtil.getRunAsUser();
        if (runAsUser == null) {
            runAsUser = AuthenticationUtil.getSystemUserName();
        }
        return new LocalTestRunAsAuthenticator(runAsUser);
    }

    public static class LocalTestRunAsAuthenticator
    implements Authenticator {
        private String userName;

        public LocalTestRunAsAuthenticator(String userName) {
            this.userName = userName;
        }

        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            if (!this.emptyCredentials()) {
                AuthenticationUtil.setRunAsUser((String)this.userName);
                return true;
            }
            return false;
        }

        public boolean emptyCredentials() {
            return this.userName == null || this.userName.length() == 0;
        }
    }
}

