/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.calendar;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.cmr.calendar.CalendarRecurrenceHelper;
import org.junit.Assert;
import org.junit.Test;

public class CalendarRecurrenceHelperTest {
    @Test
    public void fixOutlookRecurrenceQuirks_GenuineMonthlyRecurrenceParamsLeftAsIs() {
        Params in = Params.fromKVPs("BYMONTHDAY=24", "FREQ=MONTHLY", "INTERVAL=1");
        Map out = CalendarRecurrenceHelper.fixOutlookRecurrenceQuirks((Map)Params.fromMap(in));
        Assert.assertEquals((Object)in, (Object)out);
        Assert.assertNotSame((Object)in, (Object)out);
    }

    @Test
    public void fixOutlookRecurrenceQuirks_MonthlyRecurrenceThatShouldBeYearly() {
        Params in = Params.fromKVPs("BYMONTHDAY=25", "FREQ=MONTHLY", "INTERVAL=24", "BYMONTH=7");
        Map out = CalendarRecurrenceHelper.fixOutlookRecurrenceQuirks((Map)Params.fromMap(in));
        Assert.assertEquals((Object)Params.fromKVPs("BYMONTHDAY=25", "FREQ=YEARLY", "INTERVAL=2", "BYMONTH=7"), (Object)out);
    }

    @Test
    public void fixOutlookRecurrenceQuirks_YearlyRecurrenceParamsLeftAsIs() {
        Params in = Params.fromKVPs("BYMONTHDAY=25", "FREQ=YEARLY", "INTERVAL=2", "BYMONTH=7");
        Map out = CalendarRecurrenceHelper.fixOutlookRecurrenceQuirks((Map)Params.fromMap(in));
        Assert.assertEquals((Object)in, (Object)out);
        Assert.assertNotSame((Object)in, (Object)out);
    }

    @Test
    public void fixOutLookRecurrenceQuirks_weekdayRecurrenceRule() {
        Params recurrenceRule = Params.fromKVPs("FREQ=MONTHLY", "BYDAY=MO,TU,WE,TH,FR", "INTERVAL=1", "BYSETPOS=1");
        Map fixedRecurrenceRule = CalendarRecurrenceHelper.fixOutlookRecurrenceQuirks((Map)Params.fromMap(recurrenceRule));
        Assert.assertEquals(null, fixedRecurrenceRule.get("BYDAY"));
        Assert.assertEquals(null, fixedRecurrenceRule.get("BYSETPOS"));
        Assert.assertEquals((Object)"1", fixedRecurrenceRule.get("BYWEEKDAY"));
        Assert.assertEquals((Object)"MO,TU,WE,TH,FR", fixedRecurrenceRule.get("WEEKDAYS"));
    }

    @Test
    public void fixOutLookRecurrenceQuirks_weekendDayRecurrenceRule() {
        Params recurrenceRule = Params.fromKVPs("FREQ=MONTHLY", "BYDAY=SU,SA", "INTERVAL=1", "BYSETPOS=1");
        Map fixedRecurrenceRule = CalendarRecurrenceHelper.fixOutlookRecurrenceQuirks((Map)Params.fromMap(recurrenceRule));
        Assert.assertEquals(null, fixedRecurrenceRule.get("BYDAY"));
        Assert.assertEquals(null, fixedRecurrenceRule.get("BYSETPOS"));
        Assert.assertEquals((Object)"1", fixedRecurrenceRule.get("BYWEEKENDDAY"));
        Assert.assertEquals((Object)"SU,SA", fixedRecurrenceRule.get("WEEKENDS"));
    }

    @Test
    public void fixOutLookRecurrenceQuirks_dayRecurrenceRule() {
        Params recurrenceRule = Params.fromKVPs("FREQ=MONTHLY", "BYDAY=SU,MO,TU,WE,TH,FR,SA", "INTERVAL=1", "BYSETPOS=1");
        Map fixedRecurrenceRule = CalendarRecurrenceHelper.fixOutlookRecurrenceQuirks((Map)Params.fromMap(recurrenceRule));
        Assert.assertEquals((Object)"1", fixedRecurrenceRule.get("BYANYDAY"));
        Assert.assertEquals(null, fixedRecurrenceRule.get("BYSETPOS"));
        Assert.assertEquals(null, fixedRecurrenceRule.get("BYMONTHDAY"));
        Assert.assertEquals((Object)"SU,MO,TU,WE,TH,FR,SA", fixedRecurrenceRule.get("DAY"));
    }

    private static class Params
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1648766671461600951L;

        private Params() {
        }

        private Params(Map<String, String> params) {
            super(params);
        }

        private static Params fromMap(Map<String, String> params) {
            return new Params(params);
        }

        private static Params fromKVPs(String ... keyValuePairs) {
            Params params = new Params();
            String[] stringArray = keyValuePairs;
            int n = keyValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                String kvp = stringArray[n2];
                String[] split = kvp.split("=");
                Assert.assertEquals((String)("Key/value pair is not valid: " + kvp), (long)2L, (long)split.length);
                params.put(split[0], split[1]);
                ++n2;
            }
            return params;
        }
    }
}

