/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.calendar.CalendarModel;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class CalendarAllDayEventDatesCorrectingPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.calendarAllDayEventDatesCorrectingPatch.result";
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarAllDayEventDatesCorrectingPatch.class);
    private int batchSize = 1000;
    private boolean batchEnabled = true;
    private SiteService siteService;
    private CalendarService calendarService;

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchEnabled(boolean batchEnabled) {
        this.batchEnabled = batchEnabled;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setCalendarService(CalendarService calendarService) {
        this.calendarService = calendarService;
    }

    @Override
    protected String applyInternal() throws Exception {
        List allSites;
        int updatedEventsAmount = 0;
        NodeRef siteRoot = this.siteService.getSiteRoot();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Site root: " + String.valueOf(siteRoot));
        }
        List list = allSites = siteRoot != null ? this.nodeService.getChildAssocs(siteRoot) : null;
        if (allSites != null && !allSites.isEmpty()) {
            int maxItems;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Starting processing of " + allSites.size() + " sites...");
            }
            PagingResults<CalendarEntry> entries = null;
            String queryId = null;
            int n = maxItems = this.batchEnabled ? this.batchSize : Integer.MAX_VALUE;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Batching info:\n\t- batching enabled: " + this.batchEnabled + ";\n\t-batch size: " + this.batchSize);
            }
            for (ChildAssociationRef siteAssoc : allSites) {
                SiteInfo site = this.siteService.getSite(siteAssoc.getChildRef());
                if (site != null) {
                    int skipCount = 0;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Processing a site: [short name: " + site.getShortName() + ", title: " + site.getTitle() + ", visibility: " + String.valueOf((Object)site.getVisibility()) + "]");
                    }
                    do {
                        List page;
                        PagingRequest paging = new PagingRequest(skipCount, maxItems, queryId);
                        entries = this.calendarService.listCalendarEntries(site.getShortName(), paging);
                        List list2 = page = entries != null ? entries.getPage() : null;
                        if (page == null) continue;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Processing " + page.size() + " Calendar Events...");
                        }
                        queryId = entries.getQueryExecutionId();
                        for (CalendarEntry entry : page) {
                            if (!CalendarAllDayEventDatesCorrectingPatch.isAllDay(entry)) continue;
                            ++updatedEventsAmount;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("'All Day' Calendar event has been detected: [title: " + entry.getTitle() + ", start: " + String.valueOf(entry.getStart()) + ", end: " + String.valueOf(entry.getEnd()) + ", isOutlook: " + entry.isOutlook() + "]");
                            }
                            this.nodeService.setProperty(entry.getNodeRef(), CalendarModel.PROP_TO_DATE, (Serializable)this.adjustOldDate(entry.getEnd()));
                            this.nodeService.setProperty(entry.getNodeRef(), CalendarModel.PROP_FROM_DATE, (Serializable)this.adjustOldDate(entry.getStart()));
                        }
                        skipCount += maxItems;
                    } while (this.batchEnabled && entries.hasMoreItems());
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Not site object has been detected. Skipping...");
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No one site has been found! Skipping patch execution...");
        }
        return I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{updatedEventsAmount});
    }

    private Date adjustOldDate(Date oldDate) {
        Calendar result = Calendar.getInstance();
        result.setTime(oldDate);
        int offset = result.getTimeZone().getOffset(result.getTimeInMillis());
        result.add(14, offset);
        return result.getTime();
    }

    public static boolean isAllDay(CalendarEntry entry) {
        if (entry.getStart() == null || entry.getEnd() == null) {
            return false;
        }
        Calendar startLocal = Calendar.getInstance();
        Calendar endLocal = Calendar.getInstance();
        startLocal.setTime(entry.getStart());
        endLocal.setTime(entry.getEnd());
        return startLocal.get(11) == 0 && startLocal.get(12) == 0 && startLocal.get(13) == 0 && endLocal.get(11) == 0 && endLocal.get(12) == 0 && endLocal.get(13) == 0;
    }
}

