/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import java.util.ArrayList;
import java.util.Collections;
import org.alfresco.repo.domain.permissions.AbstractPermissionsDaoComponentImpl;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.domain.permissions.AclDAOImpl;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.SimpleAccessControlListProperties;
import org.alfresco.repo.security.permissions.impl.AclChange;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;

public class ADMPermissionsDaoComponentImpl
extends AbstractPermissionsDaoComponentImpl {
    @Override
    protected AbstractPermissionsDaoComponentImpl.CreationReport createAccessControlList(NodeRef nodeRef, boolean inherit, Acl existing) {
        if (existing == null) {
            SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
            properties.setAclType(ACLType.DEFINING);
            properties.setInherits(inherit);
            properties.setVersioned(false);
            Acl acl = this.aclDaoComponent.createAccessControlList(properties);
            long id = acl.getId();
            ArrayList<AclChange> changes = new ArrayList<AclChange>();
            changes.add(new AclDAOImpl.AclChangeImpl(null, id, null, acl.getAclType()));
            changes.addAll(this.getACLDAO(nodeRef).setInheritanceForChildren(nodeRef, id, null));
            this.getACLDAO(nodeRef).setAccessControlList(nodeRef, acl);
            return new AbstractPermissionsDaoComponentImpl.CreationReport(acl, changes);
        }
        switch (existing.getAclType()) {
            case OLD: {
                throw new IllegalStateException("Can not mix old and new style permissions");
            }
            case DEFINING: {
                return new AbstractPermissionsDaoComponentImpl.CreationReport(existing, Collections.emptyList());
            }
            case SHARED: 
            case FIXED: 
            case GLOBAL: {
                SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
                properties.setAclType(ACLType.DEFINING);
                properties.setInherits(existing.getInherits());
                properties.setVersioned(false);
                Acl acl = this.aclDaoComponent.createAccessControlList(properties);
                Long id = acl.getId();
                ArrayList<AclChange> changes = new ArrayList<AclChange>();
                changes.add(new AclDAOImpl.AclChangeImpl(existing.getId(), id, existing.getAclType(), acl.getAclType()));
                changes.addAll(this.aclDaoComponent.mergeInheritedAccessControlList(existing.getId(), id));
                changes.addAll(this.getACLDAO(nodeRef).setInheritanceForChildren(nodeRef, id, this.aclDaoComponent.getInheritedAccessControlList(existing.getId())));
                this.getACLDAO(nodeRef).setAccessControlList(nodeRef, acl);
                return new AbstractPermissionsDaoComponentImpl.CreationReport(acl, changes);
            }
            case LAYERED: {
                throw new IllegalStateException("Layering is not supported for DM permissions");
            }
        }
        throw new IllegalStateException("Unknown type " + String.valueOf((Object)existing.getAclType()));
    }

    @Override
    public void deletePermissions(NodeRef nodeRef) {
        Acl acl = null;
        try {
            acl = this.getAccessControlList(nodeRef);
        }
        catch (InvalidNodeRefException invalidNodeRefException) {
            return;
        }
        if (acl != null) {
            switch (acl.getAclType()) {
                case OLD: {
                    throw new IllegalStateException("Can not mix old and new style permissions");
                }
                case DEFINING: {
                    if (acl.getInherits().booleanValue()) {
                        Long inheritsFrom = this.getACLDAO(nodeRef).getInheritedAcl(nodeRef);
                        if (inheritsFrom != null) {
                            inheritsFrom = this.aclDaoComponent.getInheritedAccessControlList(inheritsFrom);
                            this.getACLDAO(nodeRef).setAccessControlList(nodeRef, this.aclDaoComponent.getAcl(inheritsFrom));
                            ArrayList<AclChange> changes = new ArrayList<AclChange>();
                            changes.addAll(this.getACLDAO(nodeRef).setInheritanceForChildren(nodeRef, inheritsFrom, this.aclDaoComponent.getInheritedAccessControlList(acl.getId())));
                            this.getACLDAO(nodeRef).updateChangedAcls(nodeRef, changes);
                            this.aclDaoComponent.deleteAccessControlList(acl.getId());
                            break;
                        }
                        this.replaceWithCleanDefiningAcl(nodeRef, acl);
                        break;
                    }
                    this.replaceWithCleanDefiningAcl(nodeRef, acl);
                    break;
                }
                case FIXED: {
                    throw new IllegalStateException("Delete not supported for fixed permissions");
                }
                case GLOBAL: {
                    throw new IllegalStateException("Delete not supported for global permissions");
                }
                case SHARED: {
                    return;
                }
                case LAYERED: {
                    throw new IllegalStateException("Layering is not supported for DM permissions");
                }
                default: {
                    throw new IllegalStateException("Unknown type " + String.valueOf((Object)acl.getAclType()));
                }
            }
        }
    }

    private void replaceWithCleanDefiningAcl(NodeRef nodeRef, Acl acl) {
        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
        properties = new SimpleAccessControlListProperties();
        properties.setAclType(ACLType.DEFINING);
        properties.setInherits(Boolean.FALSE);
        properties.setVersioned(false);
        Acl newAcl = this.aclDaoComponent.createAccessControlList(properties);
        long id = newAcl.getId();
        this.getACLDAO(nodeRef).setAccessControlList(nodeRef, newAcl);
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        changes.addAll(this.getACLDAO(nodeRef).setInheritanceForChildren(nodeRef, id, acl.getInheritedAcl()));
        this.getACLDAO(nodeRef).updateChangedAcls(nodeRef, changes);
        this.aclDaoComponent.deleteAccessControlList(acl.getId());
    }
}

