/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveReplicaCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public MoveReplicaCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        this.moveReplica(this.ocmh.zkStateReader.getClusterState(), message, results);
    }

    private void moveReplica(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        log.info("moveReplica() : {}", (Object)Utils.toJSONString((Object)message));
        this.ocmh.checkRequired(message, "collection", "targetNode");
        String collection = message.getStr("collection");
        String targetNode = message.getStr("targetNode");
        String async = message.getStr("async");
        DocCollection coll = clusterState.getCollection(collection);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " does not exist");
        }
        Replica replica = null;
        if (message.containsKey("replica")) {
            String replicaName = message.getStr("replica");
            replica = coll.getReplica(replicaName);
            if (replica == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " replica: " + replicaName + " does not exist");
            }
        } else {
            this.ocmh.checkRequired(message, "shard", "fromNode");
            String fromNode = message.getStr("fromNode");
            String shardId = message.getStr("shard");
            Slice slice = clusterState.getCollection(collection).getSlice(shardId);
            ArrayList sliceReplicas = new ArrayList(slice.getReplicas());
            Collections.shuffle(sliceReplicas, OverseerCollectionMessageHandler.RANDOM);
            for (Replica r : slice.getReplicas()) {
                if (!r.getNodeName().equals(fromNode)) continue;
                replica = r;
            }
            if (replica == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " node: " + fromNode + " do not have any replica belong to shard: " + (String)shardId);
            }
        }
        log.info("Replica will be moved {}", (Object)replica);
        Slice slice = null;
        for (Slice s : coll.getSlices()) {
            if (!s.getReplicas().contains(replica)) continue;
            slice = s;
        }
        assert (slice != null);
        Object dataDir = replica.get("dataDir");
        if (dataDir != null && dataDir.toString().startsWith("hdfs:/")) {
            this.moveHdfsReplica(clusterState, results, dataDir.toString(), targetNode, async, coll, replica, slice);
        } else {
            this.moveNormalReplica(clusterState, results, targetNode, async, coll, replica, slice);
        }
    }

    private void moveHdfsReplica(ClusterState clusterState, NamedList results, String dataDir, String targetNode, String async, DocCollection coll, Replica replica, Slice slice) throws Exception {
        String newCoreName = Assign.buildCoreName(coll, slice.getName());
        ZkNodeProps removeReplicasProps = new ZkNodeProps(new String[]{"collection", coll.getName(), "shard", slice.getName(), "replica", replica.getName()});
        removeReplicasProps.getProperties().put("deleteDataDir", false);
        removeReplicasProps.getProperties().put("deleteIndex", false);
        if (async != null) {
            removeReplicasProps.getProperties().put("async", async);
        }
        NamedList deleteResult = new NamedList();
        this.ocmh.deleteReplica(clusterState, removeReplicasProps, deleteResult, null);
        if (deleteResult.get("failure") != null) {
            String errorString = String.format(Locale.ROOT, "Failed to cleanup replica collection=%s shard=%s name=%s", coll.getName(), slice.getName(), replica.getName());
            log.warn(errorString);
            results.add("failure", (Object)(errorString + ", because of : " + deleteResult.get("failure")));
            return;
        }
        ZkNodeProps addReplicasProps = new ZkNodeProps(new String[]{"collection", coll.getName(), "shard", slice.getName(), "node", targetNode, "name", newCoreName, "dataDir", dataDir});
        if (async != null) {
            addReplicasProps.getProperties().put("async", async);
        }
        NamedList addResult = new NamedList();
        this.ocmh.addReplica(clusterState, addReplicasProps, addResult, null);
        if (addResult.get("failure") != null) {
            String errorString = String.format(Locale.ROOT, "Failed to create replica for collection=%s shard=%s on node=%s", coll.getName(), slice.getName(), targetNode);
            log.warn(errorString);
            results.add("failure", (Object)errorString);
            return;
        }
        String successString = String.format(Locale.ROOT, "MOVEREPLICA action completed successfully, moved replica=%s at node=%s to replica=%s at node=%s", replica.getCoreName(), replica.getNodeName(), newCoreName, targetNode);
        results.add("success", (Object)successString);
    }

    private void moveNormalReplica(ClusterState clusterState, NamedList results, String targetNode, String async, DocCollection coll, Replica replica, Slice slice) throws Exception {
        String newCoreName = Assign.buildCoreName(coll, slice.getName());
        ZkNodeProps addReplicasProps = new ZkNodeProps(new String[]{"collection", coll.getName(), "shard", slice.getName(), "node", targetNode, "name", newCoreName});
        if (async != null) {
            addReplicasProps.getProperties().put("async", async);
        }
        NamedList addResult = new NamedList();
        this.ocmh.addReplica(clusterState, addReplicasProps, addResult, null);
        if (addResult.get("failure") != null) {
            String errorString = String.format(Locale.ROOT, "Failed to create replica for collection=%s shard=%s on node=%s", coll.getName(), slice.getName(), targetNode);
            log.warn(errorString);
            results.add("failure", (Object)errorString);
            return;
        }
        ZkNodeProps removeReplicasProps = new ZkNodeProps(new String[]{"collection", coll.getName(), "shard", slice.getName(), "replica", replica.getName()});
        if (async != null) {
            removeReplicasProps.getProperties().put("async", async);
        }
        NamedList deleteResult = new NamedList();
        this.ocmh.deleteReplica(clusterState, removeReplicasProps, deleteResult, null);
        if (deleteResult.get("failure") != null) {
            String errorString = String.format(Locale.ROOT, "Failed to cleanup replica collection=%s shard=%s name=%s", coll.getName(), slice.getName(), replica.getName());
            log.warn(errorString);
            results.add("failure", (Object)(errorString + ", because of : " + deleteResult.get("failure")));
        } else {
            String successString = String.format(Locale.ROOT, "MOVEREPLICA action completed successfully, moved replica=%s at node=%s to replica=%s at node=%s", replica.getCoreName(), replica.getNodeName(), newCoreName, targetNode);
            results.add("success", (Object)successString);
        }
    }
}

