/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.regex.Pattern;

public class RedactionUtils {
    public static final String SOLR_REDACTION_SYSTEM_PATTERN_PROP = "solr.redaction.system.pattern";
    private static Pattern pattern = Pattern.compile(System.getProperty("solr.redaction.system.pattern", ".*(password|secret|basicauth).*"), 2);
    private static final String REDACT_STRING = "--REDACTED--";
    private static boolean redactSystemProperty = Boolean.parseBoolean(System.getProperty("solr.redaction.system.enabled", "false"));

    public static boolean isSystemPropertySensitive(String name) {
        return redactSystemProperty && pattern.matcher(name).matches();
    }

    public static String getRedactString() {
        return REDACT_STRING;
    }

    public static void setRedactSystemProperty(boolean redactSystemProperty) {
        RedactionUtils.redactSystemProperty = redactSystemProperty;
    }
}

