/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.httpclient;

import java.util.Iterator;
import java.util.Map;

public class Request {
    private String method;
    private String uri;
    private Map<String, String> args;
    private Map<String, String> headers;
    private byte[] body;
    private String encoding = "UTF-8";
    private String contentType;

    public Request(Request req) {
        this.method = req.method;
        this.uri = req.uri;
        this.args = req.args;
        this.headers = req.headers;
        this.body = req.body;
        this.encoding = req.encoding;
        this.contentType = req.contentType;
    }

    public Request(String method, String uri) {
        this.method = method;
        this.uri = uri;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public String getFullUri() {
        Object fullUri;
        Object object = fullUri = this.uri == null ? "" : this.uri;
        if (this.args != null && this.args.size() > 0) {
            int prefix = this.uri.indexOf(63) == -1 ? 63 : 38;
            Iterator<Map.Entry<String, String>> iterator = this.args.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> arg;
                fullUri = (String)fullUri + (char)prefix + arg.getKey() + "=" + ((arg = iterator.next()).getValue() == null ? "" : arg.getValue());
                prefix = 38;
            }
        }
        return fullUri;
    }

    public Request setArgs(Map<String, String> args) {
        this.args = args;
        return this;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    public Request setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Request setBody(byte[] body) {
        this.body = body;
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    public Request setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Request setType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getType() {
        return this.contentType;
    }
}

