/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.query;

import org.alfresco.query.PagingRequest;

public class PageDetails {
    private boolean hasMoreItems = false;
    private int pageSize;
    private int skipCount;
    private int maxItems;
    private int end;

    public PageDetails(int pageSize, boolean hasMoreItems, int skipCount, int maxItems, int end) {
        this.hasMoreItems = hasMoreItems;
        this.pageSize = pageSize;
        this.skipCount = skipCount;
        this.maxItems = maxItems;
        this.end = end;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean hasMoreItems() {
        return this.hasMoreItems;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public static PageDetails getPageDetails(PagingRequest pagingRequest, int totalSize) {
        int skipCount = pagingRequest.getSkipCount();
        int maxItems = pagingRequest.getMaxItems();
        int end = skipCount + maxItems;
        int pageSize = -1;
        if (end < 0 || end > totalSize) {
            end = totalSize;
            pageSize = end - skipCount;
        } else {
            pageSize = maxItems;
        }
        if (pageSize < 0) {
            pageSize = 0;
        }
        boolean hasMoreItems = end < totalSize;
        return new PageDetails(pageSize, hasMoreItems, skipCount, maxItems, end);
    }
}

