/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class TraceableThreadFactory
implements ThreadFactory {
    private static final AtomicInteger factoryNumber = new AtomicInteger(1);
    private static List<ThreadGroup> activeThreadGroups = Collections.synchronizedList(new ArrayList(1));
    private final ThreadGroup group = new ThreadGroup("TraceableThreadGroup-" + factoryNumber.getAndIncrement());
    private String namePrefix;
    private final AtomicInteger threadNumber;
    private boolean threadDaemon;
    private int threadPriority;

    public static List<ThreadGroup> getActiveThreadGroups() {
        return activeThreadGroups;
    }

    public TraceableThreadFactory() {
        activeThreadGroups.add(this.group);
        this.namePrefix = "TraceableThread-" + factoryNumber.getAndIncrement() + "-thread-";
        this.threadNumber = new AtomicInteger(1);
        this.threadDaemon = true;
        this.threadPriority = 5;
    }

    public void setThreadDaemon(boolean daemon) {
        this.threadDaemon = daemon;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        thread.setDaemon(this.threadDaemon);
        thread.setPriority(this.threadPriority);
        return thread;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }
}

