/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.xmlfactory;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringJoiner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

class FactoryHelper {
    private static final Log logger = LogFactory.getLog(FactoryHelper.class);
    static final String FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    static final String FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    static final String FEATURE_USE_ENTITY_RESOLVER2 = "http://xml.org/sax/features/use-entity-resolver2";
    static final String FEATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String ADDITIONAL_FEATURE_X_INCLUDE_AWARE = "xIncludeAware";
    private static final String ADDITIONAL_FEATURE_EXPAND_ENTITY_REFERENCES = "expandEntityReferences";
    static final String FEATURE_DISALLOW_DOCTYPE = "http://apache.org/xml/features/disallow-doctype-decl";
    static final List<String> DEFAULT_FEATURES_TO_DISABLE = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://xml.org/sax/features/use-entity-resolver2", "http://apache.org/xml/features/nonvalidating/load-external-dtd", "xIncludeAware", "expandEntityReferences")));
    static final List<String> DEFAULT_FEATURES_TO_ENABLE = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("http://javax.xml.XMLConstants/feature/secure-processing")));
    static final List<String> DEFAULT_WHITE_LIST_CALLERS = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("com.sun.xml.ws.transport.http.servlet.WSServletContextListener", "org.springframework.beans.factory.xml.XmlBeanDefinitionReader", "org.springframework.beans.factory.support.AbstractBeanFactory", "org.apache.myfaces.config.FacesConfigurator", "org.hibernate.cfg.Configuration", "org.alfresco.ibatis.HierarchicalXMLConfigBuilder", "org.alfresco.repo.security.permissions.impl.model.PermissionModel", "org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl")));
    static final String FEATURES_TO_ENABLE = "features.to.enable";
    static final String FEATURES_TO_DISABLE = "features.to.disable";
    static final String WHITE_LIST_CALLERS = "white.list.callers";
    private static volatile int counter = 1;
    private int debugCounter = counter++;
    private final int STACK_DEPTH = 30;

    FactoryHelper() {
    }

    void configureFactory(DocumentBuilderFactory factory, List<String> featuresToEnable, List<String> featuresToDisable, List<String> whiteListCallers) {
        this.debugStack("DocumentBuilderFactory newInstance", 3, 30);
        if (!this.isCallInWhiteList(whiteListCallers)) {
            if (featuresToEnable != null) {
                for (String featureToEnable : featuresToEnable) {
                    this.setFeature(factory, featureToEnable, true);
                }
            }
            if (featuresToDisable != null) {
                for (String featureToDisable : featuresToDisable) {
                    this.setFeature(factory, featureToDisable, false);
                }
            }
        }
    }

    void configureFactory(SAXParserFactory factory, List<String> featuresToEnable, List<String> featuresToDisable, List<String> whiteListCallers) {
        this.debugStack("SAXParserFactory newInstance", 3, 30);
        if (!this.isCallInWhiteList(whiteListCallers)) {
            if (featuresToEnable != null) {
                for (String featureToEnable : featuresToEnable) {
                    this.setFeature(factory, featureToEnable, true);
                }
            }
            if (featuresToDisable != null) {
                for (String featureToDisable : featuresToDisable) {
                    this.setFeature(factory, featureToDisable, false);
                }
            }
        }
    }

    private boolean isCallInWhiteList(List<String> whiteListCallers) {
        StackTraceElement[] currentStackTrace;
        for (StackTraceElement clazz : currentStackTrace = new Exception().getStackTrace()) {
            String currentClassName = clazz.getClassName();
            for (String className : whiteListCallers) {
                if (!currentClassName.equals(className)) continue;
                this.debug(this.debugCounter + " Found " + className + " in white list.");
                return true;
            }
        }
        return false;
    }

    private void debugStack(String message, int fromStackDepth, int maxStackDepth) {
        if (logger.isDebugEnabled()) {
            this.debug(this.debugCounter + " " + message);
            StackTraceElement[] currentStackTrace = new Exception().getStackTrace();
            StringJoiner stackDebug = new StringJoiner("\n");
            for (int i = fromStackDepth; i < currentStackTrace.length && i < maxStackDepth + fromStackDepth; ++i) {
                StackTraceElement frame = currentStackTrace[i];
                stackDebug.add(this.debugCounter + "   " + frame);
            }
            this.debug(stackDebug.toString());
        }
    }

    private void setFeature(DocumentBuilderFactory factory, String feature, boolean enable) {
        try {
            if (ADDITIONAL_FEATURE_X_INCLUDE_AWARE.equals(feature)) {
                factory.setXIncludeAware(enable);
            } else if (ADDITIONAL_FEATURE_EXPAND_ENTITY_REFERENCES.equals(feature)) {
                factory.setExpandEntityReferences(enable);
            } else {
                factory.setFeature(feature, enable);
            }
            this.debug(this.debugCounter + " DocumentBuilderFactory " + feature + " " + enable);
        }
        catch (ParserConfigurationException pce) {
            this.logConfigurationFailure(factory.getClass().getName(), feature, pce);
        }
    }

    private void setFeature(SAXParserFactory factory, String feature, boolean enable) {
        try {
            if (ADDITIONAL_FEATURE_X_INCLUDE_AWARE.equals(feature)) {
                factory.setXIncludeAware(enable);
            } else if (!ADDITIONAL_FEATURE_EXPAND_ENTITY_REFERENCES.equals(feature)) {
                factory.setFeature(feature, enable);
            }
            this.debug(this.debugCounter + " SAXParserFactory " + feature + " " + enable);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            this.logConfigurationFailure(factory.getClass().getName(), feature, e);
        }
    }

    public void debugNewParser(DocumentBuilder parser) {
        this.debugStack("New DocumentBuilder", 3, 30);
    }

    public void debugNewParser(SAXParser parser) {
        this.debugStack("New SAXParser", 3, 30);
    }

    private void logConfigurationFailure(String factoryName, String feature, Exception e) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Failed to configure " + factoryName + " with feature: " + feature), (Throwable)e);
        }
    }

    List<String> getConfiguration(Class<?> factoryClass, String propertyName, List<String> defaultFeatures) {
        String javaHome;
        List<String> features = defaultFeatures;
        String factoryName = factoryClass.getName();
        String extendedPropertyName = factoryName + '.' + propertyName;
        String value = null;
        try {
            value = this.getSystemProperty(extendedPropertyName);
            this.debugPropertyFrom(propertyName, value, "-D" + extendedPropertyName);
        }
        catch (SecurityException e) {
            this.debug(this.debugCounter + " Error reading system property:" + extendedPropertyName, e);
        }
        if (value == null && (javaHome = this.getJavaHome()) != null) {
            File file = new File(new File(new File(javaHome), "lib"), factoryName + ".properties");
            try {
                URL url = file.toURI().toURL();
                value = this.getProperty(url, propertyName);
                this.debugPropertyFrom(propertyName, value, file);
            }
            catch (MalformedURLException e) {
                this.debug(this.debugCounter + " Error creating URL for:" + file, e);
            }
        }
        if (value == null) {
            String resourceName = "META-INF/services/" + factoryName + ".properties";
            URL url = this.getResource(null, resourceName);
            value = this.getProperty(url, propertyName);
            this.debugPropertyFrom(propertyName, value, resourceName);
        }
        if (value != null) {
            features = new ArrayList<String>();
            if (!(value = value.trim()).isEmpty()) {
                for (String feature : value.split(";")) {
                    features.add(feature.trim());
                }
            }
        }
        return features;
    }

    private void debugPropertyFrom(String propertyName, String value, Object source) {
        if (logger.isDebugEnabled() && value != null) {
            this.debug(this.debugCounter + " " + propertyName + " " + value + " loaded from " + source);
        }
    }

    String getJavaHome() {
        return System.getProperty("java.home");
    }

    String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    URL getResource(ClassLoader loader, String resourceName) {
        return loader == null ? ClassLoader.getSystemResource(resourceName) : loader.getResource(resourceName);
    }

    String getProperty(URL url, String propertyName) {
        String value = null;
        if (url != null) {
            Properties properties = this.getProperties(url);
            value = properties.getProperty(propertyName);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(URL url) {
        Properties properties = new Properties();
        InputStream in = null;
        Reader reader = null;
        try {
            in = url.openStream();
            reader = new InputStreamReader(in, "UTF-8");
            properties.load(reader);
        }
        catch (IOException e) {
            this.debug(this.debugCounter + " Error reading :" + url, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private void debug(String message) {
        logger.debug((Object)message);
    }

    private void debug(String message, Exception e) {
        logger.debug((Object)message, (Throwable)e);
    }
}

