/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component;

import com.google.common.collect.BiMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;

public class RewriteFacetCountsComponent
extends SearchComponent {
    public void finishStage(ResponseBuilder rb) {
        if (!rb.doFacets || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        this.process(rb);
    }

    public void prepare(ResponseBuilder rb) throws IOException {
    }

    public void process(ResponseBuilder rb) {
        this.rewrite(rb, "_field_mappings_", "facet_counts", "facet_fields");
        this.rewrite(rb, "_date_mappings_", "facet_counts", "facet_dates");
        this.rewrite(rb, "_range_mappings_", "facet_counts", "facet_ranges");
        this.rewrite(rb, "_interval_mappings_", "facet_counts", "facet_intervals");
        this.rewrite(rb, "_pivot_mappings_", "facet_counts", "facet_pivot");
        this.rewritePivotFields(rb, "facet_counts", "facet_pivot");
        this.rewrite(rb, "_stats_field_mappings_", "stats", "stats_fields");
        this.copyAnalytics(rb, "facet_counts", "facet_fields");
        Map mappings = (Map)rb.rsp.getValues().get("_stats_field_mappings_");
        if (mappings != null) {
            for (String key : mappings.keySet()) {
                this.rewrite(rb, "_stats_facet_mappings_", "stats", "stats_fields", key, "facets");
            }
        }
    }

    private void copyAnalytics(ResponseBuilder rb, String ... sections) {
        NamedList found = rb.rsp.getValues();
        for (String section : sections) {
            if ((found = (NamedList)found.get(section)) != null) continue;
            return;
        }
        NamedList analytics = rb.rsp.getValues();
        if ((analytics = (NamedList)analytics.get("analytics")) != null) {
            for (int i = 0; i < analytics.size(); ++i) {
                String name = analytics.getName(i);
                Object value = analytics.getVal(i);
                found.add(name, value);
            }
        }
    }

    private void rewritePivotFields(ResponseBuilder rb, String ... sections) {
        Map mappings = (Map)rb.rsp.getValues().get("_pivot_mappings_");
        if (mappings != null) {
            NamedList found = rb.rsp.getValues();
            for (String section : sections) {
                if ((found = (NamedList)found.get(section)) != null) continue;
                return;
            }
            for (int i = 0; i < found.size(); ++i) {
                String pivotName = found.getName(i);
                String[] fromParts = pivotName.split(",");
                String mapping = (String)mappings.get(pivotName);
                String[] toParts = mapping != null ? mapping.split(",") : fromParts;
                Collection current = (Collection)found.getVal(i);
                this.processPivot(rb, fromParts, toParts, current, 0);
            }
        }
    }

    private void processPivot(ResponseBuilder rb, String[] fromParts, String[] toParts, Collection<NamedList<Object>> current, int level) {
        for (NamedList<Object> entry : current) {
            for (int i = 0; i < entry.size(); ++i) {
                String name = entry.getName(i);
                if (name.equals("field")) {
                    entry.setVal(i, (Object)fromParts[level].trim());
                    continue;
                }
                if (name.equals("pivot")) {
                    Collection pivot = (Collection)entry.getVal(i);
                    this.processPivot(rb, fromParts, toParts, pivot, level + 1);
                    continue;
                }
                if (!name.equals("ranges")) continue;
                SimpleOrderedMap ranges = (SimpleOrderedMap)entry.getVal(i);
                this.processRanges(rb, ranges);
            }
        }
    }

    private void processRanges(ResponseBuilder rb, SimpleOrderedMap ranges) {
        BiMap mappings = (BiMap)rb.rsp.getValues().get("_range_mappings_");
        if (mappings != null) {
            this.updateToACSNaming((BiMap<String, String>)mappings, (NamedList<Object>)ranges);
        }
    }

    private void rewrite(ResponseBuilder rb, String mappingName, String ... sections) {
        BiMap mappings = (BiMap)rb.rsp.getValues().get(mappingName);
        if (mappings != null) {
            NamedList found = rb.rsp.getValues();
            for (String section : sections) {
                if ((found = (NamedList)found.get(section)) != null) continue;
                return;
            }
            this.updateToACSNaming((BiMap<String, String>)mappings, (NamedList<Object>)found);
        }
    }

    private void updateToACSNaming(BiMap<String, String> mappings, NamedList<Object> propertyList) {
        for (int i = 0; i < propertyList.size(); ++i) {
            String name = propertyList.getName(i);
            String newName = (String)mappings.inverse().get((Object)name);
            if (newName == null) continue;
            propertyList.setName(i, newName);
        }
    }

    public String getDescription() {
        return "RewriteFacetCounts";
    }

    public String getSource() {
        return "";
    }
}

