/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.alfresco.solr.data.GlobalReaders;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.alfresco.solr.query.SolrAuthorityQuery;
import org.alfresco.solr.query.SolrOwnerQuery;
import org.alfresco.solr.query.SolrReaderQuery;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrAuthorityScorer
extends AbstractSolrCachingScorer {
    SolrAuthorityScorer(Weight weight, DocSet in, LeafReaderContext context, SolrIndexSearcher searcher) {
        super(weight, in, context, searcher);
    }

    public static SolrAuthorityScorer createAuthorityScorer(Weight weight, LeafReaderContext context, SolrIndexSearcher searcher, String authority) throws IOException {
        Properties p = searcher.getSchema().getResourceLoader().getCoreProperties();
        boolean doPermissionChecks = Boolean.parseBoolean(p.getProperty("alfresco.doPermissionChecks", "true"));
        SolrAuthorityQuery key = new SolrAuthorityQuery(authority);
        DocSet answer = (DocSet)searcher.cacheLookup("alfrescoAuthorityCache", (Object)key);
        if (answer != null) {
            return new SolrAuthorityScorer(weight, answer, context, searcher);
        }
        HashSet<String> globalReaders = GlobalReaders.getReaders();
        if (globalReaders.contains(authority) || !doPermissionChecks) {
            DocSet allDocs = searcher.getDocSet((Query)new MatchAllDocsQuery());
            return new SolrAuthorityScorer(weight, allDocs, context, searcher);
        }
        DocSet readableDocSet = searcher.getDocSet((Query)new SolrReaderQuery(authority));
        if (globalReaders.contains("ROLE_OWNER")) {
            DocSet authorityOwnedDocs = searcher.getDocSet((Query)new SolrOwnerQuery(authority));
            DocSet toCache = readableDocSet.union(authorityOwnedDocs);
            searcher.cacheInsert("alfrescoAuthorityCache", (Object)key, (Object)toCache);
            return new SolrAuthorityScorer(weight, toCache, context, searcher);
        }
        DocSet ownerReadableDocSet = searcher.getDocSet((Query)new SolrReaderQuery("ROLE_OWNER"));
        DocSet authorityOwnedDocs = searcher.getDocSet((Query)new SolrOwnerQuery(authority));
        DocSet docsAuthorityOwnsAndCanRead = ownerReadableDocSet.intersection(authorityOwnedDocs);
        DocSet toCache = readableDocSet.union(docsAuthorityOwnsAndCanRead);
        searcher.cacheInsert("alfrescoAuthorityCache", (Object)key, (Object)toCache);
        return new SolrAuthorityScorer(weight, toCache, context, searcher);
    }
}

