/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.solr.data.GlobalReaders;
import org.alfresco.solr.query.AbstractAuthoritySetQuery;
import org.alfresco.solr.query.AllAccessCollector;
import org.alfresco.solr.query.BitsFilter;
import org.alfresco.solr.query.DocValuesCache;
import org.alfresco.solr.query.HybridBitSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrAuthoritySetQuery
extends AbstractAuthoritySetQuery
implements PostFilter {
    public SolrAuthoritySetQuery(String authorities) {
        super(authorities);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        String[] auths = this.authorities.substring(1).split(this.authorities.substring(0, 1));
        SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)searcher;
        Properties p = solrIndexSearcher.getSchema().getResourceLoader().getCoreProperties();
        boolean doPermissionChecks = Boolean.parseBoolean(p.getProperty("alfresco.doPermissionChecks", "true"));
        boolean hasGlobalRead = false;
        HashSet<String> globalReaders = GlobalReaders.getReaders();
        for (String auth : auths) {
            if (!globalReaders.contains(auth)) continue;
            hasGlobalRead = true;
            break;
        }
        if (hasGlobalRead || !doPermissionChecks) {
            return new MatchAllDocsQuery().createWeight(searcher, needsScores);
        }
        BitsFilter readFilter = this.getACLFilter(auths, "READER", solrIndexSearcher);
        BitsFilter ownerFilter = this.getOwnerFilter(auths, solrIndexSearcher);
        if (globalReaders.contains("ROLE_OWNER")) {
            readFilter.or(ownerFilter);
            return new ConstantScoreQuery((Query)readFilter).createWeight(searcher, needsScores);
        }
        String[] ownerAuth = new String[]{"ROLE_OWNER"};
        BitsFilter ownerReadFilter = this.getACLFilter(ownerAuth, "READER", solrIndexSearcher);
        ownerReadFilter.and(ownerFilter);
        readFilter.or(ownerReadFilter);
        return new ConstantScoreQuery((Query)readFilter).createWeight(searcher, needsScores);
    }

    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        String[] auths = this.authorities.substring(1).split(this.authorities.substring(0, 1));
        SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)searcher;
        Properties p = solrIndexSearcher.getSchema().getResourceLoader().getCoreProperties();
        boolean doPermissionChecks = Boolean.parseBoolean(p.getProperty("alfresco.doPermissionChecks", "true"));
        boolean hasGlobalRead = false;
        HashSet<String> globalReaders = GlobalReaders.getReaders();
        for (String auth : auths) {
            if (!globalReaders.contains(auth)) continue;
            hasGlobalRead = true;
            break;
        }
        if (hasGlobalRead || !doPermissionChecks) {
            return new AllAccessCollector();
        }
        try {
            HybridBitSet aclSet = this.getACLSet(auths, "READER", solrIndexSearcher);
            BitsFilter ownerFilter = this.getOwnerFilter(auths, solrIndexSearcher);
            if (globalReaders.contains("ROLE_OWNER")) {
                return new AccessControlCollector(aclSet, ownerFilter);
            }
            String[] ownerAuth = new String[]{"ROLE_OWNER"};
            HybridBitSet ownerAclSet = this.getACLSet(ownerAuth, "READER", solrIndexSearcher);
            return new AccessControlCollectorWithoutOwnerRead(aclSet, ownerAclSet, ownerFilter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getCost() {
        return 202;
    }

    public void setCost(int cost) {
    }

    public boolean getCache() {
        return true;
    }

    public void setCache(boolean cache) {
    }

    public boolean getCacheSep() {
        return false;
    }

    public void setCacheSep(boolean sep) {
    }

    @Override
    public String toString(String field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AUTHSET").append(':');
        stringBuilder.append(this.authorities);
        return stringBuilder.toString();
    }

    private BitsFilter getOwnerFilter(String[] auths, SolrIndexSearcher searcher) throws IOException {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (String current : auths) {
            if (AuthorityType.getAuthorityType((String)current) != AuthorityType.USER) continue;
            builder.add((Query)new TermQuery(new Term("OWNER", current)), BooleanClause.Occur.SHOULD);
        }
        BitsFilterCollector collector = new BitsFilterCollector(searcher.getTopReaderContext().leaves().size());
        searcher.search((Query)builder.build(), (Collector)collector);
        return collector.getBitsFilter();
    }

    class AccessControlCollector
    extends DelegatingCollector {
        private HybridBitSet aclIds;
        private NumericDocValues fieldValues;
        private BitsFilter ownerFilter;
        private FixedBitSet ownerDocs;

        public AccessControlCollector(HybridBitSet aclIds, BitsFilter ownerFilter) {
            this.aclIds = aclIds;
            this.ownerFilter = ownerFilter;
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            this.fieldValues = DocValuesCache.getNumericDocValues("ACLID", context.reader());
            this.ownerDocs = this.ownerFilter.getBitSets().get(context.ord);
        }

        public void collect(int doc) throws IOException {
            long aclId = this.fieldValues.get(doc);
            if (this.aclIds.get(aclId) || this.ownerDocs.get(doc)) {
                super.collect(doc);
            }
        }
    }

    class AccessControlCollectorWithoutOwnerRead
    extends DelegatingCollector {
        private HybridBitSet aclIds;
        private HybridBitSet ownerAclIds;
        private NumericDocValues fieldValues;
        private BitsFilter ownerFilter;
        private FixedBitSet ownerDocs;

        public AccessControlCollectorWithoutOwnerRead(HybridBitSet aclIds, HybridBitSet ownerAclIds, BitsFilter ownerFilter) {
            this.aclIds = aclIds;
            this.ownerAclIds = ownerAclIds;
            this.ownerFilter = ownerFilter;
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            this.fieldValues = DocValuesCache.getNumericDocValues("ACLID", context.reader());
            this.ownerDocs = this.ownerFilter.getBitSets().get(context.ord);
        }

        public void collect(int doc) throws IOException {
            long aclId = this.fieldValues.get(doc);
            if (this.aclIds.get(aclId) || this.ownerDocs.get(doc) && this.ownerAclIds.get(aclId)) {
                super.collect(doc);
            }
        }
    }

    class BitsFilterCollector
    implements Collector,
    LeafCollector {
        private List<FixedBitSet> sets;
        private FixedBitSet set;

        public BitsFilterCollector(int leafCount) {
            this.sets = new ArrayList<FixedBitSet>(leafCount);
        }

        public BitsFilter getBitsFilter() {
            return new BitsFilter(this.sets);
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public void setScorer(Scorer scorer) {
        }

        public void collect(int doc) {
            this.set.set(doc);
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.set = new FixedBitSet(context.reader().maxDoc());
            this.sets.add(this.set);
            return this;
        }

        public boolean needsScores() {
            return false;
        }
    }
}

