/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrReaderScorer
extends AbstractSolrCachingScorer {
    SolrReaderScorer(Weight weight, DocSet in, LeafReaderContext context, SolrIndexSearcher searcher) {
        super(weight, in, context, searcher);
    }

    public static SolrReaderScorer createReaderScorer(Weight weight, LeafReaderContext context, SolrIndexSearcher searcher, String authority) throws IOException {
        DocSet readableDocs = (DocSet)searcher.cacheLookup("alfrescoReaderCache", (Object)authority);
        if (readableDocs == null) {
            DocSet aclDocs = searcher.getDocSet((Query)new TermQuery(new Term("READER", authority)));
            readableDocs = new BitDocSet(new FixedBitSet(searcher.maxDoc()));
            DocIterator it = aclDocs.iterator();
            while (it.hasNext()) {
                int docID = it.nextDoc();
                long aclID = searcher.getSlowAtomicReader().getNumericDocValues("ACLID").get(docID);
                SchemaField schemaField = searcher.getSchema().getField("ACLID");
                Query query = schemaField.getType().getFieldQuery(null, schemaField, Long.toString(aclID));
                DocSet docsForAclId = searcher.getDocSet(query);
                readableDocs = readableDocs.union(docsForAclId);
                readableDocs = readableDocs.andNot(aclDocs);
            }
            searcher.cacheInsert("alfrescoReaderCache", (Object)authority, (Object)readableDocs);
        }
        return new SolrReaderScorer(weight, readableDocs, context, searcher);
    }
}

