/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.solr.AclReport;
import org.alfresco.solr.BoundedDeque;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.adapters.IOpenBitSet;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclChangeSets;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.AbstractWorker;
import org.alfresco.solr.tracker.ActivatableTracker;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.solr.tracker.DocRouterFactory;
import org.alfresco.solr.tracker.IndexHealthReport;
import org.alfresco.solr.tracker.Tracker;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclTracker
extends ActivatableTracker {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AclTracker.class);
    private static final int ACL_CHANGE_SETS_FOUND_QUEUE_SIZE = 100;
    private static final int DEFAULT_CHANGE_SET_ACLS_BATCH_SIZE = 2000;
    private static final int DEFAULT_ACL_BATCH_SIZE = 100;
    private static final int DEFAULT_ACL_TRACKER_MAX_PARALLELISM = 32;
    private static final long DEFAULT_ACL_TRACKER_TIMESTEP = 3600000L;
    protected static final long INITIAL_MAX_ACL_CHANGE_SET_ID = 2000L;
    private static final int MAX_NUMBER_OF_ACL_CHANGE_SETS = 2000;
    private static final long MAX_TIME_STEP = 2764800000L;
    private static final int MAX_ACL_CHANGE_SET_BATCH_SIZE = 512;
    private int aclTrackerParallelism;
    private int changeSetAclsBatchSize;
    private int aclBatchSize;
    private long timeStep;
    private int maxNumberOfAclChangeSets;
    private ConcurrentLinkedQueue<Long> aclChangeSetsToReindex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclChangeSetsToIndex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclChangeSetsToPurge = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclsToReindex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclsToIndex = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Long> aclsToPurge = new ConcurrentLinkedQueue();
    private DocRouter docRouter;
    private ForkJoinPool forkJoinPool;
    private static Map<String, Semaphore> RUN_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();
    private static Map<String, Semaphore> WRITE_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();

    @Override
    public Semaphore getWriteLock() {
        return WRITE_LOCK_BY_CORE.get(this.coreName);
    }

    @Override
    public Semaphore getRunLock() {
        return RUN_LOCK_BY_CORE.get(this.coreName);
    }

    AclTracker() {
        super(Tracker.Type.ACL);
    }

    public AclTracker(Properties p, SOLRAPIClient client, String coreName, InformationServer informationServer) {
        super(p, client, coreName, informationServer, Tracker.Type.ACL);
        this.changeSetAclsBatchSize = Integer.parseInt(p.getProperty("alfresco.changeSetAclsBatchSize", String.valueOf(2000)));
        if (this.changeSetAclsBatchSize > 512) {
            LOGGER.warn("Max value for 'alfresco.changeSetAclsBatchSize' is 512. This value is being taken instead of the one specified in 'solrcore.properties': " + this.changeSetAclsBatchSize);
            this.changeSetAclsBatchSize = 512;
        }
        this.aclBatchSize = Integer.parseInt(p.getProperty("alfresco.aclBatchSize", String.valueOf(100)));
        this.docRouter = DocRouterFactory.getRouter(p, this.shardMethod);
        this.aclTrackerParallelism = Integer.parseInt(p.getProperty("alfresco.acl.tracker.maxParallelism", String.valueOf(32)));
        this.forkJoinPool = new ForkJoinPool(this.aclTrackerParallelism);
        this.timeStep = Long.parseLong(p.getProperty("alfresco.acl.tracker.timestep", String.valueOf(3600000L)));
        this.maxNumberOfAclChangeSets = Integer.parseInt(p.getProperty("alfresco.acl.tracker.maxNumberOfAclChangeSets", String.valueOf(2000)));
        RUN_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
        WRITE_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
    }

    @Override
    protected void doTrack(String iterationId) throws Throwable {
        this.trackRepository();
    }

    @Override
    public void maintenance() throws Exception {
        this.purgeAclChangeSets();
        this.purgeAcls();
        this.reindexAclChangeSets();
        this.reindexAcls();
        this.indexAclChangeSets();
        this.indexAcls();
    }

    @Override
    public boolean hasMaintenance() {
        return this.aclChangeSetsToReindex.size() > 0 || this.aclChangeSetsToIndex.size() > 0 || this.aclChangeSetsToPurge.size() > 0 || this.aclsToReindex.size() > 0 || this.aclsToIndex.size() > 0 || this.aclsToPurge.size() > 0;
    }

    protected void indexAclChangeSets() throws AuthenticationException, IOException, JSONException {
        boolean requiresCommit = false;
        while (this.aclChangeSetsToIndex.peek() != null) {
            Long aclChangeSetId = this.aclChangeSetsToIndex.poll();
            if (aclChangeSetId != null) {
                AclChangeSets aclChangeSets = this.client.getAclChangeSets(null, aclChangeSetId, null, Long.valueOf(aclChangeSetId + 1L), 1);
                if (aclChangeSets.getAclChangeSets().size() > 0 && aclChangeSetId.equals(((AclChangeSet)aclChangeSets.getAclChangeSets().get(0)).getId())) {
                    AclChangeSet changeSet = (AclChangeSet)aclChangeSets.getAclChangeSets().get(0);
                    List acls = this.client.getAcls(Collections.singletonList(changeSet), null, Integer.MAX_VALUE);
                    for (Acl acl : acls) {
                        List readers = this.client.getAclReaders(Collections.singletonList(acl));
                        this.indexAcl(readers, false);
                    }
                    this.infoSrv.indexAclTransaction(changeSet, false);
                    LOGGER.info("[CORE {}] - INDEX ACTION - AclChangeSetId {} has been indexed", (Object)this.coreName, (Object)aclChangeSetId);
                    requiresCommit = true;
                } else {
                    LOGGER.info("[CORE {}] - INDEX ACTION - AclChangeSetId {} was not found in database, it has NOT been reindexed", (Object)this.coreName, (Object)aclChangeSetId);
                }
            }
            this.checkShutdown();
        }
        if (requiresCommit) {
            this.checkShutdown();
        }
    }

    protected void indexAcls() throws AuthenticationException, IOException, JSONException {
        while (this.aclsToIndex.peek() != null) {
            Long aclId = this.aclsToIndex.poll();
            if (aclId != null) {
                Acl acl = new Acl(0L, aclId.longValue());
                List readers = this.client.getAclReaders(Collections.singletonList(acl));
                this.indexAcl(readers, false);
                LOGGER.info("[CORE {}] - INDEX ACTION - AclId {} has been indexed", (Object)this.coreName, (Object)aclId);
            }
            this.checkShutdown();
        }
    }

    protected void reindexAclChangeSets() throws AuthenticationException, IOException, JSONException {
        boolean requiresCommit = false;
        while (this.aclChangeSetsToReindex.peek() != null) {
            Long aclChangeSetId = this.aclChangeSetsToReindex.poll();
            if (aclChangeSetId != null) {
                this.infoSrv.deleteByAclChangeSetId(aclChangeSetId);
                AclChangeSets aclChangeSets = this.client.getAclChangeSets(null, aclChangeSetId, null, Long.valueOf(aclChangeSetId + 1L), 1);
                if (aclChangeSets.getAclChangeSets().size() > 0 && aclChangeSetId.equals(((AclChangeSet)aclChangeSets.getAclChangeSets().get(0)).getId())) {
                    AclChangeSet changeSet = (AclChangeSet)aclChangeSets.getAclChangeSets().get(0);
                    List acls = this.client.getAcls(Collections.singletonList(changeSet), null, Integer.MAX_VALUE);
                    for (Acl acl : acls) {
                        List readers = this.client.getAclReaders(Collections.singletonList(acl));
                        this.indexAcl(readers, true);
                    }
                    this.infoSrv.indexAclTransaction(changeSet, true);
                    LOGGER.info("[CORE {}] - REINDEX ACTION - AclChangeSetId {} has been reindexed", (Object)this.coreName, (Object)aclChangeSetId);
                    requiresCommit = true;
                } else {
                    LOGGER.info("[CORE {}] - REINDEX ACTION - AclChangeSetId {} was not found in database, it has NOT been reindexed", (Object)this.coreName, (Object)aclChangeSetId);
                }
            }
            this.checkShutdown();
        }
        if (requiresCommit) {
            this.checkShutdown();
        }
    }

    protected void reindexAcls() throws AuthenticationException, IOException, JSONException {
        boolean requiresCommit = false;
        while (this.aclsToReindex.peek() != null) {
            Long aclId = this.aclsToReindex.poll();
            if (aclId != null) {
                this.infoSrv.deleteByAclId(aclId);
                Acl acl = new Acl(0L, aclId.longValue());
                List readers = this.client.getAclReaders(Collections.singletonList(acl));
                this.indexAcl(readers, true);
                LOGGER.info("[CORE {}] - REINDEX ACTION - aclId {} has been reindexed", (Object)this.coreName, (Object)aclId);
                requiresCommit = true;
            }
            this.checkShutdown();
        }
        if (requiresCommit) {
            this.checkShutdown();
        }
    }

    protected void purgeAclChangeSets() throws IOException, JSONException {
        while (this.aclChangeSetsToPurge.peek() != null) {
            Long aclChangeSetId = this.aclChangeSetsToPurge.poll();
            if (aclChangeSetId != null) {
                this.infoSrv.deleteByAclChangeSetId(aclChangeSetId);
                LOGGER.info("[CORE {}] - PURGE ACTION - Purged aclChangeSetId {}", (Object)this.coreName, (Object)aclChangeSetId);
            }
            this.checkShutdown();
        }
    }

    protected void purgeAcls() throws IOException, JSONException {
        while (this.aclsToPurge.peek() != null) {
            Long aclId = this.aclsToPurge.poll();
            if (aclId != null) {
                this.infoSrv.deleteByAclId(aclId);
                LOGGER.info("[CORE {}] - PURGE ACTION - Purged aclId {}", (Object)this.coreName, (Object)aclId);
            }
            this.checkShutdown();
        }
    }

    public void addAclChangeSetToReindex(Long aclChangeSetToReindex) {
        this.aclChangeSetsToReindex.offer(aclChangeSetToReindex);
    }

    public void addAclChangeSetToIndex(Long aclChangeSetToIndex) {
        this.aclChangeSetsToIndex.offer(aclChangeSetToIndex);
    }

    public void addAclChangeSetToPurge(Long aclChangeSetToPurge) {
        this.aclChangeSetsToPurge.offer(aclChangeSetToPurge);
    }

    public void addAclToReindex(Long aclToReindex) {
        this.aclsToReindex.offer(aclToReindex);
    }

    public void addAclToIndex(Long aclToIndex) {
        this.aclsToIndex.offer(aclToIndex);
    }

    public void addAclToPurge(Long aclToPurge) {
        this.aclsToPurge.offer(aclToPurge);
    }

    @Override
    protected void clearScheduledMaintenanceWork() {
        this.logAndClear(this.aclChangeSetsToIndex, "ACL ChangeSets to be indexed");
        this.logAndClear(this.aclsToIndex, "ACLs to be indexed");
        this.logAndClear(this.aclChangeSetsToReindex, "ACL ChangeSets to be re-indexed");
        this.logAndClear(this.aclsToReindex, "ACLs to be re-indexed");
        this.logAndClear(this.aclChangeSetsToPurge, "ACL ChangeSets to be purged");
        this.logAndClear(this.aclsToPurge, "ACLs to be purged");
    }

    protected void trackRepository() throws IOException, AuthenticationException, JSONException {
        this.checkShutdown();
        TrackerState state = super.getTrackerState();
        if (state.getTrackerCycles() == 0) {
            this.checkRepoAndIndexConsistency(state);
        }
        this.checkShutdown();
        this.trackAclChangeSets();
    }

    protected void checkRepoAndIndexConsistency(TrackerState state) throws AuthenticationException, IOException, JSONException {
        if (state.getLastGoodChangeSetCommitTimeInIndex() != 0L && state.isCheckedFirstAclTransactionTime() && state.isCheckedLastAclTransactionTime()) {
            return;
        }
        AclChangeSets firstChangeSets = this.client.getAclChangeSets(null, Long.valueOf(0L), null, Long.valueOf(2000L), 1);
        if (state.getLastGoodChangeSetCommitTimeInIndex() == 0L) {
            state.setCheckedLastAclTransactionTime(true);
            state.setCheckedFirstAclTransactionTime(true);
            LOGGER.info("[CORE {}] - No acl transactions found - no verification required", (Object)this.coreName);
            if (!firstChangeSets.getAclChangeSets().isEmpty()) {
                AclChangeSet firstChangeSet = (AclChangeSet)firstChangeSets.getAclChangeSets().get(0);
                long firstChangeSetCommitTime = firstChangeSet.getCommitTimeMs();
                state.setLastGoodChangeSetCommitTimeInIndex(firstChangeSetCommitTime);
                this.setLastChangeSetIdAndCommitTimeInTrackerState(firstChangeSets.getAclChangeSets(), state);
            }
        }
        if (!state.isCheckedFirstAclTransactionTime() && !firstChangeSets.getAclChangeSets().isEmpty()) {
            AclChangeSet firstAclChangeSet = (AclChangeSet)firstChangeSets.getAclChangeSets().get(0);
            long firstAclTxId = firstAclChangeSet.getId();
            long firstAclTxCommitTime = firstAclChangeSet.getCommitTimeMs();
            int setSize = this.infoSrv.getAclTxDocsSize(Long.toString(firstAclTxId), Long.toString(firstAclTxCommitTime));
            if (setSize == 0) {
                LOGGER.error("[CORE {}] First acl transaction was not found with the correct timestamp.", (Object)this.coreName);
                LOGGER.error("SOLR has successfully connected to your repository however the SOLR indexes and repository database do not match.");
                LOGGER.error("If this is a new or rebuilt database your SOLR indexes also need to be re-built to match the database.");
                LOGGER.error("Notice that SOLR will continue to track the repository, but the index may be corrupted.");
                LOGGER.error("You can also check your SOLR connection details in solrcore.properties.");
                throw new AlfrescoRuntimeException("Initial ACL transaction from DB with Id=" + firstAclTxId + " and Timestamp=" + firstAclTxCommitTime + " was not found in Solr core.");
            }
            if (setSize == 1) {
                state.setCheckedFirstAclTransactionTime(true);
                LOGGER.info("[CORE {}] Verified first acl transaction and timestamp in index", (Object)this.coreName);
            } else {
                LOGGER.warn("[CORE {}] Duplicate initial acl transaction found with correct timestamp", (Object)this.coreName);
            }
        }
        if (!state.isCheckedLastAclTransactionTime()) {
            Long maxChangeSetCommitTimeInRepo = firstChangeSets.getMaxChangeSetCommitTime();
            Long maxChangeSetIdInRepo = firstChangeSets.getMaxChangeSetId();
            if (maxChangeSetCommitTimeInRepo != null && maxChangeSetIdInRepo != null) {
                state.setLastChangeSetCommitTimeOnServer(maxChangeSetCommitTimeInRepo.longValue());
                state.setLastChangeSetIdOnServer(maxChangeSetIdInRepo.longValue());
                AclChangeSet maxAclTxInIndex = this.infoSrv.getMaxAclChangeSetIdAndCommitTimeInIndex();
                if (maxAclTxInIndex.getCommitTimeMs() > maxChangeSetCommitTimeInRepo) {
                    LOGGER.error("[CORE {}] Last acl transaction was found in index with timestamp later than that of repository.", (Object)this.coreName);
                    LOGGER.error("Max Acl Tx In Index: " + maxAclTxInIndex.getId() + ", In Repo: " + maxChangeSetIdInRepo);
                    LOGGER.error("Max Acl Tx Commit Time In Index: " + maxAclTxInIndex.getCommitTimeMs() + ", In Repo: " + maxChangeSetCommitTimeInRepo);
                    LOGGER.error("SOLR has successfully connected to your repository however the SOLR indexes and repository database do not match.");
                    LOGGER.error("If this is a new or rebuilt database your SOLR indexes also need to be re-built to match the database.");
                    LOGGER.error("You can also check your SOLR connection details in solrcore.properties.");
                    throw new AlfrescoRuntimeException("Last acl transaction found in index with incorrect timestamp");
                }
                state.setCheckedLastAclTransactionTime(true);
                LOGGER.info("[CORE {}] - Verified last acl transaction timestamp in index less than or equal to that of repository.", (Object)this.coreName);
            }
        }
    }

    protected Long getChangeSetFromCommitTime(BoundedDeque<AclChangeSet> changeSetsFound, long lastGoodChangeSetCommitTimeInIndex) {
        if (changeSetsFound.size() > 0) {
            return ((AclChangeSet)changeSetsFound.getLast()).getCommitTimeMs();
        }
        return lastGoodChangeSetCommitTimeInIndex;
    }

    protected AclChangeSets getSomeAclChangeSets(BoundedDeque<AclChangeSet> changeSetsFound, Long fromCommitTime, long timeStep, int maxResults, long endTime) throws AuthenticationException, IOException, JSONException {
        AclChangeSets aclChangeSets;
        long actualTimeStep = timeStep;
        Long startTime = fromCommitTime == null ? Long.valueOf(0L) : fromCommitTime;
        do {
            aclChangeSets = this.client.getAclChangeSets(startTime, null, Long.valueOf(startTime + actualTimeStep), null, maxResults);
            startTime = startTime + actualTimeStep;
            if ((actualTimeStep *= 2L) <= 2764800000L) continue;
            actualTimeStep = 2764800000L;
        } while (aclChangeSets.getAclChangeSets().size() == 0 && startTime < endTime || aclChangeSets.getAclChangeSets().size() > 0 && this.alreadyFoundChangeSets(changeSetsFound, aclChangeSets));
        return aclChangeSets;
    }

    private boolean alreadyFoundChangeSets(BoundedDeque<AclChangeSet> changeSetsFound, AclChangeSets aclChangeSets) {
        if (changeSetsFound.size() == 0) {
            return false;
        }
        if (aclChangeSets.getAclChangeSets().size() == 1) {
            return ((AclChangeSet)aclChangeSets.getAclChangeSets().get(0)).getId() == ((AclChangeSet)changeSetsFound.getLast()).getId();
        }
        HashSet alreadyFound = new HashSet(changeSetsFound.getDeque());
        for (AclChangeSet aclChangeSet : aclChangeSets.getAclChangeSets()) {
            if (alreadyFound.contains(aclChangeSet)) continue;
            return false;
        }
        return true;
    }

    protected void indexAcl(List<AclReaders> aclReaderList, boolean overwrite) throws IOException {
        long time = this.infoSrv.indexAcl(aclReaderList, overwrite);
        this.trackerStats.addAclTime(time);
    }

    public IndexHealthReport checkIndex(Long toAclTx, Long fromTime, Long toTime) throws AuthenticationException, IOException, JSONException {
        AclChangeSets aclTransactions;
        long firstChangeSetCommitTimex = 0L;
        AclChangeSets firstChangeSets = this.client.getAclChangeSets(null, Long.valueOf(0L), null, Long.valueOf(2000L), 1);
        if (firstChangeSets.getAclChangeSets().size() > 0) {
            AclChangeSet firstChangeSet = (AclChangeSet)firstChangeSets.getAclChangeSets().get(0);
            firstChangeSetCommitTimex = firstChangeSet.getCommitTimeMs();
        }
        IOpenBitSet aclTxIdsInDb = this.infoSrv.getOpenBitSetInstance();
        long lastAclTxCommitTime = firstChangeSetCommitTimex;
        if (fromTime != null) {
            lastAclTxCommitTime = fromTime;
        }
        long maxAclTxId = 0L;
        Long minAclTxId = null;
        long endTime = System.currentTimeMillis() + this.infoSrv.getHoleRetention();
        BoundedDeque changeSetsFound = new BoundedDeque(100);
        block0: do {
            aclTransactions = this.getSomeAclChangeSets((BoundedDeque<AclChangeSet>)changeSetsFound, lastAclTxCommitTime, this.timeStep, this.maxNumberOfAclChangeSets, endTime);
            for (AclChangeSet set : aclTransactions.getAclChangeSets()) {
                if (toTime != null && set.getCommitTimeMs() > toTime || toAclTx != null && set.getId() > toAclTx) break block0;
                if (minAclTxId == null) {
                    minAclTxId = set.getId();
                }
                if (maxAclTxId < set.getId()) {
                    maxAclTxId = set.getId();
                }
                lastAclTxCommitTime = set.getCommitTimeMs();
                aclTxIdsInDb.set(set.getId());
                changeSetsFound.add((Object)set);
            }
        } while (aclTransactions.getAclChangeSets().size() > 0);
        return this.infoSrv.reportAclTransactionsInIndex(minAclTxId, aclTxIdsInDb, maxAclTxId);
    }

    public List<Long> getAclsForDbAclTransaction(Long acltxid) {
        try {
            ArrayList<Long> answer = new ArrayList<Long>();
            AclChangeSets changeSet = this.client.getAclChangeSets(null, acltxid, null, Long.valueOf(acltxid + 1L), 1);
            List acls = this.client.getAcls(changeSet.getAclChangeSets(), null, Integer.MAX_VALUE);
            for (Acl acl : acls) {
                answer.add(acl.getId());
            }
            return answer;
        }
        catch (IOException | AuthenticationException | JSONException e) {
            throw new AlfrescoRuntimeException("Failed to get acls", e);
        }
    }

    public AclReport checkAcl(Long aclid) {
        AclReport aclReport = new AclReport();
        aclReport.setAclId(aclid);
        try {
            List readers = this.client.getAclReaders(Collections.singletonList(new Acl(0L, aclid.longValue())));
            aclReport.setExistsInDb(readers.size() == 1);
        }
        catch (IOException | AuthenticationException | JSONException e) {
            aclReport.setExistsInDb(false);
        }
        return this.infoSrv.checkAclInIndex(aclid, aclReport);
    }

    protected void trackAclChangeSets() throws AuthenticationException, IOException, JSONException {
        AclChangeSets aclChangeSets;
        long startElapsed = System.nanoTime();
        BoundedDeque changeSetsFound = new BoundedDeque(100);
        long totalAclCount = 0L;
        LOGGER.info("{}-[CORE {}] <init> Tracking ACLs", (Object)Thread.currentThread().getId(), (Object)this.coreName);
        do {
            try {
                this.getWriteLock().acquire();
                this.state = this.getTrackerState();
                Long fromCommitTime = this.getChangeSetFromCommitTime((BoundedDeque<AclChangeSet>)changeSetsFound, this.state.getLastGoodChangeSetCommitTimeInIndex());
                aclChangeSets = this.getSomeAclChangeSets((BoundedDeque<AclChangeSet>)changeSetsFound, fromCommitTime, this.timeStep, this.maxNumberOfAclChangeSets, this.state.getTimeToStopIndexing());
                if (aclChangeSets.getAclChangeSets().size() > 0) {
                    LOGGER.info("{}-[CORE {}] Found {} ACL change sets after lastTxCommitTime {}, ACL Change Sets from {} to {}", new Object[]{Thread.currentThread().getId(), this.coreName, aclChangeSets.getAclChangeSets().size(), fromCommitTime, aclChangeSets.getAclChangeSets().get(0), aclChangeSets.getAclChangeSets().get(aclChangeSets.getAclChangeSets().size() - 1)});
                } else {
                    LOGGER.info("{}-[CORE {}] No ACL change set found after lastTxCommitTime {}", new Object[]{Thread.currentThread().getId(), this.coreName, fromCommitTime});
                }
                if (aclChangeSets.getAclChangeSets().stream().anyMatch(changeSet -> changeSet.getCommitTimeMs() > this.state.getTimeToStopIndexing())) break;
                AtomicInteger counter = new AtomicInteger();
                Collection<List<AclChangeSet>> changeSetBatches = aclChangeSets.getAclChangeSets().stream().peek(arg_0 -> ((BoundedDeque)changeSetsFound).add(arg_0)).filter(this::isAclChangeSetAlreadyIndexed).collect(Collectors.groupingBy(it -> counter.getAndAdd(1) / this.changeSetAclsBatchSize)).values();
                for (List<AclChangeSet> changeSetBatch : changeSetBatches) {
                    int aclCount = this.indexBatchOfChangeSets(changeSetBatch);
                    this.indexAclChangeSetAfterWorker(changeSetBatch, this.state);
                    long endElapsed = System.nanoTime();
                    this.trackerStats.addElapsedAclTime(aclCount, endElapsed - startElapsed);
                    startElapsed = endElapsed;
                    totalAclCount += (long)aclCount;
                }
                this.setLastChangeSetIdAndCommitTimeInTrackerState(aclChangeSets.getAclChangeSets(), this.state);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
            finally {
                this.getWriteLock().release();
            }
        } while (aclChangeSets.getAclChangeSets().size() > 0);
        LOGGER.info("{}-[CORE {}] <end> Tracked {} ACLs", new Object[]{Thread.currentThread().getId(), this.coreName, totalAclCount});
    }

    private boolean isAclChangeSetAlreadyIndexed(AclChangeSet changeSet) {
        try {
            boolean isInIndex;
            boolean bl = isInIndex = changeSet.getCommitTimeMs() <= this.state.getLastIndexedChangeSetCommitTime() && this.infoSrv.aclChangeSetInIndex(changeSet.getId(), true);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{}-[CORE {}] Skipping change Set Id {} as it was already indexed", new Object[]{Thread.currentThread().getId(), this.coreName, changeSet.getId()});
            }
            return !isInIndex;
        }
        catch (IOException e) {
            LOGGER.warn("{}-[CORE {}] Error catched while checking if ACL Change Set {} was in index", new Object[]{Thread.currentThread().getId(), this.coreName, changeSet.getId(), e});
            return true;
        }
    }

    private void setLastChangeSetIdAndCommitTimeInTrackerState(List<AclChangeSet> aclChangeSets, TrackerState state) {
        if (!aclChangeSets.isEmpty()) {
            long maxChangeSetCommitTime = aclChangeSets.stream().max(Comparator.comparing(AclChangeSet::getCommitTimeMs)).orElseThrow().getCommitTimeMs();
            state.setLastChangeSetCommitTimeOnServer(maxChangeSetCommitTime);
            long maxChangeSetId = aclChangeSets.stream().max(Comparator.comparing(AclChangeSet::getId)).orElseThrow().getId();
            state.setLastChangeSetIdOnServer(maxChangeSetId);
        }
    }

    private void indexAclChangeSetAfterWorker(Collection<AclChangeSet> changeSetsIndexed, TrackerState state) throws IOException {
        for (AclChangeSet set : changeSetsIndexed) {
            this.infoSrv.indexAclTransaction(set, true);
            if (set.getCommitTimeMs() > state.getLastIndexedChangeSetCommitTime() || set.getCommitTimeMs() == state.getLastIndexedChangeSetCommitTime() && set.getId() > state.getLastIndexedChangeSetId()) {
                state.setLastIndexedChangeSetCommitTime(set.getCommitTimeMs());
                state.setLastIndexedChangeSetId(set.getId());
            }
            this.trackerStats.addChangeSetAcls(set.getAclCount());
        }
    }

    private int indexBatchOfChangeSets(List<AclChangeSet> changeSetBatch) throws AuthenticationException, IOException, JSONException, ExecutionException, InterruptedException {
        List nonEmptyChangeSets = changeSetBatch.stream().filter(set -> set.getAclCount() > 0).collect(Collectors.toList());
        List acls = this.client.getAcls(nonEmptyChangeSets, null, Integer.MAX_VALUE);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}-[CORE {}] Found {} Acls from Acl Change Sets: {}", new Object[]{Thread.currentThread().getId(), this.coreName, acls.size(), nonEmptyChangeSets});
        }
        List aclBatches = Lists.partition((List)acls, (int)this.aclBatchSize);
        return (Integer)((ForkJoinTask)this.forkJoinPool.submit(() -> aclBatches.parallelStream().map(batch -> {
            new AclIndexWorker((List<Acl>)batch).run();
            return batch.size();
        }).reduce(0, Integer::sum))).get();
    }

    @Override
    public void invalidateState() {
        super.invalidateState();
        this.infoSrv.clearProcessedAclChangeSets();
    }

    class AclIndexWorker
    extends AbstractWorker {
        List<Acl> acls;

        AclIndexWorker(List<Acl> acls) {
            this.acls = acls;
        }

        @Override
        protected void doWork() throws IOException, AuthenticationException, JSONException {
            List<Acl> filteredAcls = this.filterAcls(this.acls);
            if (filteredAcls.size() > 0) {
                List readers = AclTracker.this.client.getAclReaders(filteredAcls);
                AclTracker.this.indexAcl(readers, true);
            }
        }

        @Override
        protected void onFail(Throwable failCausedBy) {
            AclTracker.this.setRollback(true, failCausedBy);
        }

        private List<Acl> filterAcls(List<Acl> acls) {
            ArrayList<Acl> filteredList = new ArrayList<Acl>(acls.size());
            for (Acl acl : acls) {
                if (!AclTracker.this.docRouter.routeAcl(AclTracker.this.shardCount, AclTracker.this.shardInstance, acl).booleanValue()) continue;
                filteredList.add(acl);
            }
            return filteredList;
        }
    }
}

