/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import java.util.EnumMap;
import org.carrot2.core.LanguageCode;
import org.carrot2.shaded.guava.common.base.Predicate;
import org.carrot2.shaded.guava.common.collect.Maps;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.linguistic.IStemmerFactory;
import org.carrot2.text.linguistic.IdentityStemmer;
import org.carrot2.text.linguistic.SnowballStemmerAdapter;
import org.carrot2.text.linguistic.lucene.ArabicStemmerAdapter;
import org.carrot2.text.linguistic.lucene.HindiStemmerAdapter;
import org.carrot2.text.linguistic.morfologik.MorfologikStemmerAdapter;
import org.carrot2.text.linguistic.snowball.SnowballProgram;
import org.carrot2.text.linguistic.snowball.stemmers.DanishStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.DutchStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.EnglishStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.FinnishStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.FrenchStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.GermanStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.HungarianStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.ItalianStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.NorwegianStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.PortugueseStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.RomanianStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.RussianStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.SpanishStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.SwedishStemmer;
import org.carrot2.text.linguistic.snowball.stemmers.TurkishStemmer;
import org.carrot2.util.annotations.ThreadSafe;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.factory.FallbackFactory;
import org.carrot2.util.factory.IFactory;
import org.carrot2.util.factory.NewClassInstanceFactory;
import org.carrot2.util.factory.SingletonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable
@ThreadSafe
public class DefaultStemmerFactory
implements IStemmerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStemmerFactory.class);
    private static final EnumMap<LanguageCode, IFactory<IStemmer>> stemmerFactories;
    private static final Predicate<IStemmer> stemmerVerifier;

    @Override
    public IStemmer getStemmer(LanguageCode languageCode) {
        return stemmerFactories.get((Object)languageCode).createInstance();
    }

    private static EnumMap<LanguageCode, IFactory<IStemmer>> createDefaultStemmers() {
        SingletonFactory identity = new SingletonFactory(new IdentityStemmer());
        EnumMap map = Maps.newEnumMap(LanguageCode.class);
        map.put(LanguageCode.POLISH, new NewClassInstanceFactory<MorfologikStemmerAdapter>(MorfologikStemmerAdapter.class));
        map.put(LanguageCode.ARABIC, new NewClassInstanceFactory<ArabicStemmerAdapter>(ArabicStemmerAdapter.class));
        map.put(LanguageCode.DANISH, DefaultStemmerFactory.snowball(DanishStemmer.class));
        map.put(LanguageCode.DUTCH, DefaultStemmerFactory.snowball(DutchStemmer.class));
        map.put(LanguageCode.ENGLISH, DefaultStemmerFactory.snowball(EnglishStemmer.class));
        map.put(LanguageCode.FINNISH, DefaultStemmerFactory.snowball(FinnishStemmer.class));
        map.put(LanguageCode.FRENCH, DefaultStemmerFactory.snowball(FrenchStemmer.class));
        map.put(LanguageCode.GERMAN, DefaultStemmerFactory.snowball(GermanStemmer.class));
        map.put(LanguageCode.HUNGARIAN, DefaultStemmerFactory.snowball(HungarianStemmer.class));
        map.put(LanguageCode.ITALIAN, DefaultStemmerFactory.snowball(ItalianStemmer.class));
        map.put(LanguageCode.NORWEGIAN, DefaultStemmerFactory.snowball(NorwegianStemmer.class));
        map.put(LanguageCode.PORTUGUESE, DefaultStemmerFactory.snowball(PortugueseStemmer.class));
        map.put(LanguageCode.ROMANIAN, DefaultStemmerFactory.snowball(RomanianStemmer.class));
        map.put(LanguageCode.RUSSIAN, DefaultStemmerFactory.snowball(RussianStemmer.class));
        map.put(LanguageCode.SPANISH, DefaultStemmerFactory.snowball(SpanishStemmer.class));
        map.put(LanguageCode.SWEDISH, DefaultStemmerFactory.snowball(SwedishStemmer.class));
        map.put(LanguageCode.TURKISH, DefaultStemmerFactory.snowball(TurkishStemmer.class));
        map.put(LanguageCode.CHINESE_SIMPLIFIED, identity);
        map.put(LanguageCode.HINDI, new NewClassInstanceFactory<HindiStemmerAdapter>(HindiStemmerAdapter.class));
        for (LanguageCode lc : LanguageCode.values()) {
            if (map.containsKey((Object)lc)) {
                FallbackFactory<IStemmer> factory = (FallbackFactory<IStemmer>)map.get((Object)lc);
                if (factory == identity) continue;
                factory = new FallbackFactory<IStemmer>(factory, identity, stemmerVerifier, logger, "Stemmer for " + lc.toString() + " (" + lc.getIsoCode() + ") is not available." + " This may degrade clustering quality of " + lc.toString() + " content. Cause: {}");
                map.put(lc, factory);
                continue;
            }
            map.put(lc, identity);
        }
        return map;
    }

    private static IFactory<IStemmer> snowball(final Class<? extends SnowballProgram> clazz) {
        return new IFactory<IStemmer>(){

            @Override
            public IStemmer createInstance() {
                try {
                    return new SnowballStemmerAdapter((SnowballProgram)clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static {
        stemmerVerifier = new Predicate<IStemmer>(){

            public boolean apply(IStemmer stemmer) {
                stemmer.stem("verification");
                return true;
            }
        };
        stemmerFactories = DefaultStemmerFactory.createDefaultStemmers();
    }
}

