/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.clustering.ClusteringEngine;
import org.apache.solr.handler.clustering.DocumentClusteringEngine;
import org.apache.solr.handler.clustering.SearchClusteringEngine;
import org.apache.solr.handler.clustering.carrot2.CarrotClusteringEngine;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringComponent
extends SearchComponent
implements SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String COMPONENT_NAME = "clustering";
    private final LinkedHashMap<String, SearchClusteringEngine> searchClusteringEngines = new LinkedHashMap();
    private final LinkedHashMap<String, DocumentClusteringEngine> documentClusteringEngines = new LinkedHashMap();
    private final Map<String, SearchClusteringEngine> searchClusteringEnginesView = Collections.unmodifiableMap(this.searchClusteringEngines);
    private NamedList<Object> initParams;

    public static SolrDocumentList docListToSolrDocumentList(DocList docs, SolrIndexSearcher searcher, Set<String> fields, Map<SolrDocument, Integer> ids) throws IOException {
        IndexSchema schema = searcher.getSchema();
        SolrDocumentList list = new SolrDocumentList();
        list.setNumFound((long)docs.matches());
        list.setMaxScore(Float.valueOf(docs.maxScore()));
        list.setStart((long)docs.offset());
        DocIterator dit = docs.iterator();
        while (dit.hasNext()) {
            int docid = dit.nextDoc();
            Document luceneDoc = searcher.doc(docid, fields);
            SolrDocument doc = new SolrDocument();
            for (IndexableField field : luceneDoc) {
                if (null != fields && !fields.contains(field.name())) continue;
                SchemaField sf = schema.getField(field.name());
                doc.addField(field.name(), sf.getType().toObject(field));
            }
            if (docs.hasScores() && (null == fields || fields.contains("score"))) {
                doc.addField("score", (Object)Float.valueOf(dit.score()));
            }
            list.add((Object)doc);
            if (ids == null) continue;
            ids.put(doc, new Integer(docid));
        }
        return list;
    }

    public void init(NamedList args) {
        this.initParams = args;
        super.init(args);
    }

    public void inform(SolrCore core) {
        if (this.initParams != null) {
            log.info("Initializing Clustering Engines");
            SolrResourceLoader loader = core.getResourceLoader();
            for (Map.Entry entry : this.initParams) {
                ClusteringEngine previousEntry;
                if (!"engine".equals(entry.getKey())) continue;
                NamedList engineInitParams = (NamedList)entry.getValue();
                Boolean optional = engineInitParams.getBooleanArg("optional");
                optional = optional == null ? Boolean.FALSE : optional;
                String engineClassName = (String)StringUtils.defaultIfBlank((CharSequence)((String)engineInitParams.get("classname")), (CharSequence)CarrotClusteringEngine.class.getName());
                ClusteringEngine engine = (ClusteringEngine)loader.newInstance(engineClassName, ClusteringEngine.class);
                String name = (String)StringUtils.defaultIfBlank((CharSequence)engine.init(engineInitParams, core), (CharSequence)"");
                if (!engine.isAvailable()) {
                    if (optional.booleanValue()) {
                        log.info("Optional clustering engine not available: " + name);
                    } else {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A required clustering engine failed to initialize, check the logs: " + name);
                    }
                }
                if (engine instanceof SearchClusteringEngine) {
                    previousEntry = this.searchClusteringEngines.put(name, (SearchClusteringEngine)engine);
                } else if (engine instanceof DocumentClusteringEngine) {
                    previousEntry = this.documentClusteringEngines.put(name, (DocumentClusteringEngine)engine);
                } else {
                    log.warn("Unknown type of a clustering engine for class: " + engineClassName);
                    continue;
                }
                if (previousEntry == null) continue;
                log.warn("Duplicate clustering engine component named '" + name + "'.");
            }
            ClusteringComponent.setupDefaultEngine("search results clustering", this.searchClusteringEngines);
            ClusteringComponent.setupDefaultEngine("document clustering", this.documentClusteringEngines);
            log.info("Finished Initializing Clustering Engines");
        }
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
        boolean useCollection;
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        String name = this.getClusteringEngineName(rb);
        boolean useResults = params.getBool("clustering.results", false);
        if (useResults) {
            SearchClusteringEngine engine = this.searchClusteringEngines.get(name);
            if (engine != null) {
                this.checkAvailable(name, engine);
                DocListAndSet results = rb.getResults();
                HashMap<SolrDocument, Integer> docIds = new HashMap<SolrDocument, Integer>(results.docList.size());
                SolrDocumentList solrDocList = ClusteringComponent.docListToSolrDocumentList(results.docList, rb.req.getSearcher(), engine.getFieldsToLoad(rb.req), docIds);
                Object clusters = engine.cluster(rb.getQuery(), solrDocList, docIds, rb.req);
                rb.rsp.add("clusters", clusters);
            } else {
                log.warn("No engine named: " + name);
            }
        }
        if (useCollection = params.getBool("clustering.collection", false)) {
            DocumentClusteringEngine engine = this.documentClusteringEngines.get(name);
            if (engine != null) {
                this.checkAvailable(name, engine);
                boolean useDocSet = params.getBool("clustering.docs.useDocSet", false);
                NamedList<?> nl = null;
                nl = useDocSet ? engine.cluster(rb.getResults().docSet, params) : engine.cluster(params);
                rb.rsp.add("clusters", nl);
            } else {
                log.warn("No engine named: " + name);
            }
        }
    }

    private void checkAvailable(String name, ClusteringEngine engine) {
        if (!engine.isAvailable()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Clustering engine declared, but not available, check the logs: " + name);
        }
    }

    private String getClusteringEngineName(ResponseBuilder rb) {
        return rb.req.getParams().get("clustering.engine", "default");
    }

    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false) || !params.getBool("clustering.results", false)) {
            return;
        }
        sreq.params.remove(COMPONENT_NAME);
        if ((sreq.purpose & 0x40) != 0) {
            String fl = sreq.params.get("fl", "*");
            if (fl.indexOf(42) >= 0) {
                return;
            }
            String name = this.getClusteringEngineName(rb);
            SearchClusteringEngine engine = this.searchClusteringEngines.get(name);
            if (engine != null) {
                this.checkAvailable(name, engine);
                Set<String> fields = engine.getFieldsToLoad(rb.req);
                if (fields == null || fields.size() == 0) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                String[] flparams = fl.split("[,\\s]+");
                HashSet<String> flParamSet = new HashSet<String>(flparams.length);
                for (String flparam : flparams) {
                    flParamSet.add(flparam);
                }
                for (String aFieldToLoad : fields) {
                    if (flParamSet.contains(aFieldToLoad)) continue;
                    sb.append(',').append(aFieldToLoad);
                }
                if (sb.length() > 0) {
                    sreq.params.set("fl", new String[]{fl + sb.toString()});
                }
            } else {
                log.warn("No engine named: " + name);
            }
        }
    }

    public void finishStage(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false) || !params.getBool("clustering.results", false)) {
            return;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            String name = this.getClusteringEngineName(rb);
            SearchClusteringEngine engine = this.searchClusteringEngines.get(name);
            if (engine != null) {
                this.checkAvailable(name, engine);
                SolrDocumentList solrDocList = (SolrDocumentList)rb.rsp.getResponse();
                Map<SolrDocument, Integer> docIds = null;
                Object clusters = engine.cluster(rb.getQuery(), solrDocList, docIds, rb.req);
                rb.rsp.add("clusters", clusters);
            } else {
                log.warn("No engine named: " + name);
            }
        }
    }

    Map<String, SearchClusteringEngine> getSearchClusteringEngines() {
        return this.searchClusteringEnginesView;
    }

    public String getDescription() {
        return "A Clustering component";
    }

    private static <T extends ClusteringEngine> void setupDefaultEngine(String type, LinkedHashMap<String, T> map) {
        String engineName = "default";
        ClusteringEngine defaultEngine = (ClusteringEngine)map.get(engineName);
        if (defaultEngine == null || !defaultEngine.isAvailable()) {
            for (Map.Entry<String, T> e : map.entrySet()) {
                if (!((ClusteringEngine)e.getValue()).isAvailable()) continue;
                engineName = e.getKey();
                defaultEngine = (ClusteringEngine)e.getValue();
                map.put("default", defaultEngine);
                break;
            }
        }
        if (defaultEngine != null) {
            log.info("Default engine for " + type + ": " + engineName + " [" + defaultEngine.getClass().getSimpleName() + "]");
        } else {
            log.warn("No default engine for " + type + ".");
        }
    }
}

