/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;

public class Assign {
    private static Pattern COUNT = Pattern.compile("core_node(\\d+)");

    public static String assignNode(DocCollection collection) {
        Map sliceMap;
        Map map = sliceMap = collection != null ? collection.getSlicesMap() : null;
        if (sliceMap == null) {
            return "core_node1";
        }
        int max = 0;
        for (Slice slice : sliceMap.values()) {
            for (Replica replica : slice.getReplicas()) {
                Matcher m = COUNT.matcher(replica.getName());
                if (!m.matches()) continue;
                max = Math.max(max, Integer.parseInt(m.group(1)));
            }
        }
        return "core_node" + (max + 1);
    }

    public static String assignShard(DocCollection collection, Integer numShards) {
        Map sliceMap;
        if (numShards == null) {
            numShards = 1;
        }
        String returnShardId = null;
        Map map = sliceMap = collection != null ? collection.getActiveSlicesMap() : null;
        if (sliceMap == null) {
            return "shard1";
        }
        ArrayList shardIdNames = new ArrayList(sliceMap.keySet());
        if (shardIdNames.size() < numShards) {
            return "shard" + (shardIdNames.size() + 1);
        }
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        for (String shardId : shardIdNames) {
            int cnt = ((Slice)sliceMap.get(shardId)).getReplicasMap().size();
            map2.put(shardId, cnt);
        }
        Collections.sort(shardIdNames, (o1, o2) -> {
            Integer one = (Integer)map2.get(o1);
            Integer two = (Integer)map2.get(o2);
            return one.compareTo(two);
        });
        returnShardId = (String)shardIdNames.get(0);
        return returnShardId;
    }

    static String buildCoreName(DocCollection collection, String shard) {
        Slice slice = collection.getSlice(shard);
        int replicaNum = slice.getReplicas().size();
        while (true) {
            String replicaName = collection.getName() + "_" + shard + "_replica" + replicaNum;
            boolean exists = false;
            for (Replica replica : slice.getReplicas()) {
                if (!replicaName.equals(replica.getStr("core"))) continue;
                exists = true;
                break;
            }
            if (!exists) break;
            ++replicaNum;
        }
        return collection.getName() + "_" + shard + "_replica" + replicaNum;
    }

    public static List<ReplicaCount> getNodesForNewReplicas(ClusterState clusterState, String collectionName, String shard, int numberOfNodes, Object createNodeSet, CoreContainer cc) {
        List l;
        DocCollection coll = clusterState.getCollection(collectionName);
        Integer maxShardsPerNode = coll.getInt("maxShardsPerNode", Integer.valueOf(1));
        List createNodeList = null;
        createNodeList = createNodeSet instanceof List ? (List)createNodeSet : (createNodeSet == null ? null : StrUtils.splitSmart((String)((String)createNodeSet), (String)",", (boolean)true));
        HashMap<String, ReplicaCount> nodeNameVsShardCount = Assign.getNodeNameVsShardCount(collectionName, clusterState, createNodeList);
        if (createNodeList == null) {
            int availableSlots = 0;
            for (Map.Entry<String, ReplicaCount> ent : nodeNameVsShardCount.entrySet()) {
                if (maxShardsPerNode <= ent.getValue().thisCollectionNodes) continue;
                availableSlots += maxShardsPerNode - ent.getValue().thisCollectionNodes;
            }
            if (availableSlots < numberOfNodes) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Cannot create %d new replicas for collection %s given the current number of live nodes and a maxShardsPerNode of %d", numberOfNodes, collectionName, maxShardsPerNode));
            }
        }
        if ((l = (List)coll.get("rule")) != null) {
            return Assign.getNodesViaRules(clusterState, shard, numberOfNodes, cc, coll, createNodeList, l);
        }
        ArrayList<ReplicaCount> sortedNodeList = new ArrayList<ReplicaCount>(nodeNameVsShardCount.values());
        Collections.sort(sortedNodeList, (x, y) -> x.weight() < y.weight() ? -1 : (x.weight() == y.weight() ? 0 : 1));
        return sortedNodeList;
    }

    private static List<ReplicaCount> getNodesViaRules(ClusterState clusterState, String shard, int numberOfNodes, CoreContainer cc, DocCollection coll, List<String> createNodeList, List l) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Object o : l) {
            rules.add(new Rule((Map)o));
        }
        LinkedHashMap<String, Map<String, Integer>> shardVsNodes = new LinkedHashMap<String, Map<String, Integer>>();
        for (Slice slice : coll.getSlices()) {
            LinkedHashMap<String, Integer> n = new LinkedHashMap<String, Integer>();
            shardVsNodes.put(slice.getName(), n);
            for (Replica replica : slice.getReplicas()) {
                Integer count = (Integer)n.get(replica.getNodeName());
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                n.put(replica.getNodeName(), count);
            }
        }
        List snitches = (List)coll.get("snitch");
        ArrayList<String> nodesList = createNodeList == null ? new ArrayList<String>(clusterState.getLiveNodes()) : createNodeList;
        Map<ReplicaAssigner.Position, String> positions = new ReplicaAssigner(rules, Collections.singletonMap(shard, numberOfNodes), snitches, shardVsNodes, nodesList, cc, clusterState).getNodeMappings();
        ArrayList<ReplicaCount> repCounts = new ArrayList<ReplicaCount>();
        for (String s : positions.values()) {
            repCounts.add(new ReplicaCount(s));
        }
        return repCounts;
    }

    private static HashMap<String, ReplicaCount> getNodeNameVsShardCount(String collectionName, ClusterState clusterState, List<String> createNodeList) {
        Set nodes = clusterState.getLiveNodes();
        ArrayList nodeList = new ArrayList(nodes.size());
        nodeList.addAll(nodes);
        if (createNodeList != null) {
            nodeList.retainAll(createNodeList);
        }
        HashMap<String, ReplicaCount> nodeNameVsShardCount = new HashMap<String, ReplicaCount>();
        for (String s : nodeList) {
            nodeNameVsShardCount.put(s, new ReplicaCount(s));
        }
        if (createNodeList != null) {
            if (createNodeList.size() != nodeNameVsShardCount.size()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one of the node(s) specified are not currently active, no action taken.");
            }
            return nodeNameVsShardCount;
        }
        DocCollection coll = clusterState.getCollection(collectionName);
        Integer maxShardsPerNode = coll.getInt("maxShardsPerNode", Integer.valueOf(1));
        Map collections = clusterState.getCollectionsMap();
        for (Map.Entry entry : collections.entrySet()) {
            DocCollection c = (DocCollection)entry.getValue();
            for (Slice slice : c.getSlices()) {
                Collection replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    ReplicaCount count = nodeNameVsShardCount.get(replica.getNodeName());
                    if (count == null) continue;
                    ++count.totalNodes;
                    if (!((String)entry.getKey()).equals(collectionName)) continue;
                    ++count.thisCollectionNodes;
                    if (count.thisCollectionNodes < maxShardsPerNode) continue;
                    nodeNameVsShardCount.remove(replica.getNodeName());
                }
            }
        }
        return nodeNameVsShardCount;
    }

    static class ReplicaCount {
        public final String nodeName;
        public int thisCollectionNodes = 0;
        public int totalNodes = 0;

        ReplicaCount(String nodeName) {
            this.nodeName = nodeName;
        }

        public int weight() {
            return this.thisCollectionNodes * 100 + this.totalNodes;
        }
    }
}

