/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.util.TimeOut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateShardCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public CreateShardCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        log.info("Create shard invoked: {}", (Object)message);
        if (collectionName == null || sliceName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'collection' and 'shard' are required parameters");
        }
        int numSlices = 1;
        ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler();
        DocCollection collection = clusterState.getCollection(collectionName);
        int repFactor = message.getInt("replicationFactor", collection.getInt("replicationFactor", Integer.valueOf(1)));
        Object createNodeSetStr = message.get("createNodeSet");
        List<Assign.ReplicaCount> sortedNodeList = Assign.getNodesForNewReplicas(clusterState, collectionName, sliceName, repFactor, createNodeSetStr, this.ocmh.overseer.getZkController().getCoreContainer());
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)message));
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
        boolean created = false;
        while (!timeout.hasTimedOut()) {
            Thread.sleep(100L);
            created = zkStateReader.getClusterState().getCollection(collectionName).getSlice(sliceName) != null;
            if (!created) continue;
        }
        if (!created) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create shard: " + message.getStr("name"));
        }
        String configName = message.getStr("collection.configName");
        String async = message.getStr("async");
        HashMap<String, String> requestMap = null;
        if (async != null) {
            requestMap = new HashMap<String, String>(repFactor, 1.0f);
        }
        for (int j = 1; j <= repFactor; ++j) {
            String nodeName = sortedNodeList.get((int)((j - 1) % sortedNodeList.size())).nodeName;
            String shardName = collectionName + "_" + sliceName + "_replica" + j;
            log.info("Creating shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
            params.set("name", new String[]{shardName});
            params.set("collection.configName", new String[]{configName});
            params.set("collection", new String[]{collectionName});
            params.set("shard", new String[]{sliceName});
            params.set("numShards", numSlices);
            this.ocmh.addPropertyParams(message, params);
            this.ocmh.sendShardRequest(nodeName, params, shardHandler, async, requestMap);
        }
        this.ocmh.processResponses(results, shardHandler, true, "Failed to create shard", async, requestMap, Collections.emptySet());
        log.info("Finished create command on all shards for collection: " + collectionName);
    }
}

