/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.cloud.DeleteNodeCmd;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceNodeCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public ReplaceNodeCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        this.ocmh.checkRequired(message, "source", "target");
        String source = message.getStr("source");
        String target = message.getStr("target");
        String async = message.getStr("async");
        boolean parallel = message.getBool("parallel", false);
        ClusterState clusterState = zkStateReader.getClusterState();
        if (!clusterState.liveNodesContain(source)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source Node: " + source + " is not live");
        }
        if (!clusterState.liveNodesContain(target)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target Node: " + target + " is not live");
        }
        List<ZkNodeProps> sourceReplicas = ReplaceNodeCmd.getReplicasOfNode(source, clusterState);
        ArrayList<ZkNodeProps> createdReplicas = new ArrayList<ZkNodeProps>();
        AtomicBoolean anyOneFailed = new AtomicBoolean(false);
        CountDownLatch countDownLatch = new CountDownLatch(sourceReplicas.size());
        for (ZkNodeProps sourceReplica : sourceReplicas) {
            ZkNodeProps addedReplica;
            NamedList nl = new NamedList();
            log.info("Going to create replica for collection={} shard={} on node={}", new Object[]{sourceReplica.getStr("collection"), sourceReplica.getStr("shard"), target});
            ZkNodeProps msg = sourceReplica.plus("parallel", (Object)String.valueOf(parallel)).plus("node", (Object)target);
            if (async != null) {
                msg.getProperties().put("async", async);
            }
            if ((addedReplica = this.ocmh.addReplica(clusterState, msg, nl, () -> {
                countDownLatch.countDown();
                if (nl.get("failure") != null) {
                    String errorString = String.format(Locale.ROOT, "Failed to create replica for collection=%s shard=%s on node=%s", sourceReplica.getStr("collection"), sourceReplica.getStr("shard"), target);
                    log.warn(errorString);
                    NamedList namedList = results;
                    synchronized (namedList) {
                        results.add("failure", (Object)errorString);
                        anyOneFailed.set(true);
                    }
                } else {
                    log.debug("Successfully created replica for collection={} shard={} on node={}", new Object[]{sourceReplica.getStr("collection"), sourceReplica.getStr("shard"), target});
                }
            })) == null) continue;
            createdReplicas.add(addedReplica);
        }
        log.debug("Waiting for replace node action to complete");
        countDownLatch.await(5L, TimeUnit.MINUTES);
        log.debug("Finished waiting for replace node action to complete");
        if (anyOneFailed.get()) {
            log.info("Failed to create some replicas. Cleaning up all replicas on target node");
            CountDownLatch cleanupLatch = new CountDownLatch(createdReplicas.size());
            for (ZkNodeProps createdReplica : createdReplicas) {
                NamedList deleteResult = new NamedList();
                try {
                    this.ocmh.deleteReplica(zkStateReader.getClusterState(), createdReplica.plus("parallel", (Object)"true"), deleteResult, () -> {
                        cleanupLatch.countDown();
                        if (deleteResult.get("failure") != null) {
                            NamedList namedList = results;
                            synchronized (namedList) {
                                results.add("failure", (Object)("Could not cleanup, because of : " + deleteResult.get("failure")));
                            }
                        }
                    });
                }
                catch (KeeperException e) {
                    cleanupLatch.countDown();
                    log.warn("Error deleting replica ", (Throwable)e);
                }
                catch (Exception e) {
                    log.warn("Error deleting replica ", (Throwable)e);
                    cleanupLatch.countDown();
                    throw e;
                }
            }
            cleanupLatch.await(5L, TimeUnit.MINUTES);
        }
        DeleteNodeCmd.cleanupReplicas(results, state, sourceReplicas, this.ocmh, source, async);
        results.add("success", (Object)("REPLACENODE action completed successfully from  : " + source + " to : " + target));
    }

    static List<ZkNodeProps> getReplicasOfNode(String source, ClusterState state) {
        ArrayList<ZkNodeProps> sourceReplicas = new ArrayList<ZkNodeProps>();
        for (Map.Entry e : state.getCollectionsMap().entrySet()) {
            for (Slice slice : ((DocCollection)e.getValue()).getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    if (!source.equals(replica.getNodeName())) continue;
                    ZkNodeProps props = new ZkNodeProps(new String[]{"collection", (String)e.getKey(), "shard", slice.getName(), "core", replica.getCoreName(), "replica", replica.getName(), "node", source});
                    sourceReplicas.add(props);
                }
            }
        }
        return sourceReplicas;
    }
}

