/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.Config;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.logging.LogWatcherConfig;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SolrXmlConfig {
    public static final String SOLR_XML_FILE = "solr.xml";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static NodeConfig fromConfig(Config config) {
        UpdateShardHandlerConfig updateConfig;
        NamedList<Object> entries;
        String nodeName;
        SolrXmlConfig.checkForIllegalConfig(config);
        config.substituteProperties();
        CloudConfig cloudConfig = null;
        UpdateShardHandlerConfig deprecatedUpdateConfig = null;
        if (config.getNodeList("solr/solrcloud", false).getLength() > 0) {
            NamedList<Object> cloudSection = SolrXmlConfig.readNodeListAsNamedList(config, "solr/solrcloud/*[@name]", "<solrcloud>");
            deprecatedUpdateConfig = SolrXmlConfig.loadUpdateConfig(cloudSection, false);
            cloudConfig = SolrXmlConfig.fillSolrCloudSection(cloudSection);
        }
        if (Strings.isNullOrEmpty((String)(nodeName = (String)(entries = SolrXmlConfig.readNodeListAsNamedList(config, "solr/*[@name]", "<solr>")).remove("nodeName"))) && cloudConfig != null) {
            nodeName = cloudConfig.getHost();
        }
        if (deprecatedUpdateConfig == null) {
            updateConfig = SolrXmlConfig.loadUpdateConfig(SolrXmlConfig.readNodeListAsNamedList(config, "solr/updateshardhandler/*[@name]", "<updateshardhandler>"), true);
        } else {
            updateConfig = SolrXmlConfig.loadUpdateConfig(SolrXmlConfig.readNodeListAsNamedList(config, "solr/updateshardhandler/*[@name]", "<updateshardhandler>"), false);
            if (updateConfig != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "UpdateShardHandler configuration defined twice in solr.xml");
            }
            updateConfig = deprecatedUpdateConfig;
        }
        NodeConfig.NodeConfigBuilder configBuilder = new NodeConfig.NodeConfigBuilder(nodeName, config.getResourceLoader());
        configBuilder.setUpdateShardHandlerConfig(updateConfig);
        configBuilder.setShardHandlerFactoryConfig(SolrXmlConfig.getShardHandlerFactoryPluginInfo(config));
        configBuilder.setSolrCoreCacheFactoryConfig(SolrXmlConfig.getTransientCoreCacheFactoryPluginInfo(config));
        configBuilder.setLogWatcherConfig(SolrXmlConfig.loadLogWatcherConfig(config, "solr/logging/*[@name]", "solr/logging/watcher/*[@name]"));
        configBuilder.setSolrProperties(SolrXmlConfig.loadProperties(config));
        if (cloudConfig != null) {
            configBuilder.setCloudConfig(cloudConfig);
        }
        configBuilder.setBackupRepositoryPlugins(SolrXmlConfig.getBackupRepositoryPluginInfos(config));
        configBuilder.setMetricReporterPlugins(SolrXmlConfig.getMetricReporterPluginInfos(config));
        return SolrXmlConfig.fillSolrSection(configBuilder, entries);
    }

    public static NodeConfig fromFile(SolrResourceLoader loader, Path configFile) {
        NodeConfig nodeConfig;
        block10: {
            log.info("Loading container configuration from {}", (Object)configFile);
            if (!Files.exists(configFile, new LinkOption[0])) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "solr.xml does not exist in " + configFile.getParent() + " cannot start Solr");
            }
            InputStream inputStream = Files.newInputStream(configFile, new OpenOption[0]);
            try {
                nodeConfig = SolrXmlConfig.fromInputStream(loader, inputStream);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SolrException exc) {
                    throw exc;
                }
                catch (Exception exc) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load SOLR configuration", (Throwable)exc);
                }
            }
            inputStream.close();
        }
        return nodeConfig;
    }

    public static NodeConfig fromString(SolrResourceLoader loader, String xml) {
        return SolrXmlConfig.fromInputStream(loader, new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    public static NodeConfig fromInputStream(SolrResourceLoader loader, InputStream is) {
        NodeConfig nodeConfig;
        byte[] buf = IOUtils.toByteArray((InputStream)is);
        ByteArrayInputStream dup = new ByteArrayInputStream(buf);
        try {
            Config config = new Config(loader, null, new InputSource(dup), null, false);
            nodeConfig = SolrXmlConfig.fromConfig(config);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dup.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SolrException exc) {
                throw exc;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        dup.close();
        return nodeConfig;
    }

    public static NodeConfig fromSolrHome(SolrResourceLoader loader, Path solrHome) {
        return SolrXmlConfig.fromFile(loader, solrHome.resolve(SOLR_XML_FILE));
    }

    public static NodeConfig fromSolrHome(Path solrHome) {
        SolrResourceLoader loader = new SolrResourceLoader(solrHome);
        return SolrXmlConfig.fromSolrHome(loader, solrHome);
    }

    private static void checkForIllegalConfig(Config config) {
        SolrXmlConfig.failIfFound(config, "solr/@coreLoadThreads");
        SolrXmlConfig.failIfFound(config, "solr/@persistent");
        SolrXmlConfig.failIfFound(config, "solr/@sharedLib");
        SolrXmlConfig.failIfFound(config, "solr/@zkHost");
        SolrXmlConfig.failIfFound(config, "solr/cores");
        SolrXmlConfig.assertSingleInstance("solrcloud", config);
        SolrXmlConfig.assertSingleInstance("logging", config);
        SolrXmlConfig.assertSingleInstance("logging/watcher", config);
        SolrXmlConfig.assertSingleInstance("backup", config);
    }

    private static void assertSingleInstance(String section, Config config) {
        if (config.getNodeList("/solr/" + section, false).getLength() > 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple instances of " + section + " section found in solr.xml");
        }
    }

    private static void failIfFound(Config config, String xPath) {
        if (config.getVal(xPath, false) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Should not have found " + xPath + "\n. Please upgrade your solr.xml: https://cwiki.apache.org/confluence/display/solr/Format+of+solr.xml");
        }
    }

    private static Properties loadProperties(Config config) {
        try {
            Node node = ((NodeList)config.evaluate("solr", XPathConstants.NODESET)).item(0);
            XPath xpath = config.getXPath();
            NodeList props = (NodeList)xpath.evaluate("property", node, XPathConstants.NODESET);
            Properties properties = new Properties();
            for (int i = 0; i < props.getLength(); ++i) {
                Node prop = props.item(i);
                properties.setProperty(DOMUtil.getAttr(prop, "name"), PropertiesUtil.substituteProperty(DOMUtil.getAttr(prop, "value"), null));
            }
            return properties;
        }
        catch (XPathExpressionException e) {
            log.warn("Error parsing solr.xml: " + e.getMessage());
            return null;
        }
    }

    private static NamedList<Object> readNodeListAsNamedList(Config config, String path, String section) {
        NodeList nodes = config.getNodeList(path, false);
        if (nodes == null) {
            return null;
        }
        return SolrXmlConfig.checkForDuplicates(section, DOMUtil.nodesToNamedList(nodes));
    }

    private static NamedList<Object> checkForDuplicates(String section, NamedList<Object> nl) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry entry : nl) {
            if (keys.add((String)entry.getKey())) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, section + " section of solr.xml contains duplicated '" + (String)entry.getKey() + "'");
        }
        return nl;
    }

    private static int parseInt(String field, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing '" + field + "', value '" + value + "' cannot be parsed as int");
        }
    }

    private static NodeConfig fillSolrSection(NodeConfig.NodeConfigBuilder builder, NamedList<Object> nl) {
        block26: for (Map.Entry entry : nl) {
            String name = (String)entry.getKey();
            if (entry.getValue() == null) continue;
            String value = entry.getValue().toString();
            switch (name) {
                case "adminHandler": {
                    builder.setCoreAdminHandlerClass(value);
                    continue block26;
                }
                case "collectionsHandler": {
                    builder.setCollectionsAdminHandlerClass(value);
                    continue block26;
                }
                case "infoHandler": {
                    builder.setInfoHandlerClass(value);
                    continue block26;
                }
                case "configSetsHandler": {
                    builder.setConfigSetsHandlerClass(value);
                    continue block26;
                }
                case "coreRootDirectory": {
                    builder.setCoreRootDirectory(value);
                    continue block26;
                }
                case "managementPath": {
                    builder.setManagementPath(value);
                    continue block26;
                }
                case "sharedLib": {
                    builder.setSharedLibDirectory(value);
                    continue block26;
                }
                case "configSetBaseDir": {
                    builder.setConfigSetBaseDirectory(value);
                    continue block26;
                }
                case "shareSchema": {
                    builder.setUseSchemaCache(Boolean.parseBoolean(value));
                    continue block26;
                }
                case "coreLoadThreads": {
                    builder.setCoreLoadThreads(SolrXmlConfig.parseInt(name, value));
                    continue block26;
                }
                case "transientCacheSize": {
                    builder.setTransientCacheSize(SolrXmlConfig.parseInt(name, value));
                    continue block26;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown configuration value in solr.xml: " + name);
        }
        return builder.build();
    }

    private static UpdateShardHandlerConfig loadUpdateConfig(NamedList<Object> nl, boolean alwaysDefine) {
        Object mrt;
        Object mns;
        Object mucit;
        Object ucesd;
        Object dct;
        Object dst;
        Object mucph;
        if (nl == null && !alwaysDefine) {
            return null;
        }
        if (nl == null) {
            return UpdateShardHandlerConfig.DEFAULT;
        }
        boolean defined = false;
        int maxUpdateConnections = 100000;
        int maxUpdateConnectionsPerHost = 100000;
        int distributedSocketTimeout = 600000;
        int distributedConnectionTimeout = 60000;
        int updateConnectionsEvictorSleepDelay = 5000;
        int maxUpdateConnectionIdleTime = 40000;
        String metricNameStrategy = "queryLessURLAndMethod";
        int maxRecoveryThreads = -1;
        Object muc = nl.remove("maxUpdateConnections");
        if (muc != null) {
            maxUpdateConnections = SolrXmlConfig.parseInt("maxUpdateConnections", muc.toString());
            defined = true;
        }
        if ((mucph = nl.remove("maxUpdateConnectionsPerHost")) != null) {
            maxUpdateConnectionsPerHost = SolrXmlConfig.parseInt("maxUpdateConnectionsPerHost", mucph.toString());
            defined = true;
        }
        if ((dst = nl.remove("distribUpdateSoTimeout")) != null) {
            distributedSocketTimeout = SolrXmlConfig.parseInt("distribUpdateSoTimeout", dst.toString());
            defined = true;
        }
        if ((dct = nl.remove("distribUpdateConnTimeout")) != null) {
            distributedConnectionTimeout = SolrXmlConfig.parseInt("distribUpdateConnTimeout", dct.toString());
            defined = true;
        }
        if ((ucesd = nl.remove("updateConnectionsEvictorSleepDelay")) != null) {
            updateConnectionsEvictorSleepDelay = SolrXmlConfig.parseInt("updateConnectionsEvictorSleepDelay", ucesd.toString());
            defined = true;
        }
        if ((mucit = nl.remove("maxUpdateConnectionIdleTime")) != null) {
            maxUpdateConnectionIdleTime = SolrXmlConfig.parseInt("maxUpdateConnectionIdleTime", mucit.toString());
            defined = true;
        }
        if ((mns = nl.remove("metricNameStrategy")) != null) {
            metricNameStrategy = mns.toString();
            defined = true;
        }
        if ((mrt = nl.remove("maxRecoveryThreads")) != null) {
            maxRecoveryThreads = SolrXmlConfig.parseInt("maxRecoveryThreads", mrt.toString());
            defined = true;
        }
        if (!defined && !alwaysDefine) {
            return null;
        }
        return new UpdateShardHandlerConfig(maxUpdateConnections, maxUpdateConnectionsPerHost, distributedSocketTimeout, distributedConnectionTimeout, updateConnectionsEvictorSleepDelay, maxUpdateConnectionIdleTime, metricNameStrategy, maxRecoveryThreads);
    }

    private static String removeValue(NamedList<Object> nl, String key) {
        Object value = nl.remove(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private static String required(String section, String key, String value) {
        if (value != null) {
            return value;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, section + " section missing required entry '" + key + "'");
    }

    private static CloudConfig fillSolrCloudSection(NamedList<Object> nl) {
        String hostName = SolrXmlConfig.required("solrcloud", "host", SolrXmlConfig.removeValue(nl, "host"));
        int hostPort = SolrXmlConfig.parseInt("hostPort", SolrXmlConfig.required("solrcloud", "hostPort", SolrXmlConfig.removeValue(nl, "hostPort")));
        String hostContext = SolrXmlConfig.required("solrcloud", "hostContext", SolrXmlConfig.removeValue(nl, "hostContext"));
        CloudConfig.CloudConfigBuilder builder = new CloudConfig.CloudConfigBuilder(hostName, hostPort, hostContext);
        block28: for (Map.Entry entry : nl) {
            String name = (String)entry.getKey();
            if (entry.getValue() == null) continue;
            String value = entry.getValue().toString();
            switch (name) {
                case "leaderVoteWait": {
                    builder.setLeaderVoteWait(SolrXmlConfig.parseInt(name, value));
                    continue block28;
                }
                case "leaderConflictResolveWait": {
                    builder.setLeaderConflictResolveWait(SolrXmlConfig.parseInt(name, value));
                    continue block28;
                }
                case "zkClientTimeout": {
                    builder.setZkClientTimeout(SolrXmlConfig.parseInt(name, value));
                    continue block28;
                }
                case "autoReplicaFailoverBadNodeExpiration": {
                    builder.setAutoReplicaFailoverBadNodeExpiration(SolrXmlConfig.parseInt(name, value));
                    continue block28;
                }
                case "autoReplicaFailoverWaitAfterExpiration": {
                    builder.setAutoReplicaFailoverWaitAfterExpiration(SolrXmlConfig.parseInt(name, value));
                    continue block28;
                }
                case "autoReplicaFailoverWorkLoopDelay": {
                    builder.setAutoReplicaFailoverWorkLoopDelay(SolrXmlConfig.parseInt(name, value));
                    continue block28;
                }
                case "zkHost": {
                    builder.setZkHost(value);
                    continue block28;
                }
                case "genericCoreNodeNames": {
                    builder.setUseGenericCoreNames(Boolean.parseBoolean(value));
                    continue block28;
                }
                case "zkACLProvider": {
                    builder.setZkACLProviderClass(value);
                    continue block28;
                }
                case "zkCredentialsProvider": {
                    builder.setZkCredentialsProviderClass(value);
                    continue block28;
                }
                case "createCollectionWaitTimeTillActive": {
                    builder.setCreateCollectionWaitTimeTillActive(SolrXmlConfig.parseInt(name, value));
                    continue block28;
                }
                case "createCollectionCheckLeaderActive": {
                    builder.setCreateCollectionCheckLeaderActive(Boolean.parseBoolean(value));
                    continue block28;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown configuration parameter in <solrcloud> section of solr.xml: " + name);
        }
        return builder.build();
    }

    private static LogWatcherConfig loadLogWatcherConfig(Config config, String loggingPath, String watcherPath) {
        String value;
        String name;
        String loggingClass = null;
        boolean enabled = true;
        int watcherQueueSize = 50;
        String watcherThreshold = null;
        block16: for (Map.Entry entry : SolrXmlConfig.readNodeListAsNamedList(config, loggingPath, "<logging>")) {
            name = (String)entry.getKey();
            value = entry.getValue().toString();
            switch (name) {
                case "class": {
                    loggingClass = value;
                    continue block16;
                }
                case "enabled": {
                    enabled = Boolean.parseBoolean(value);
                    continue block16;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown value in logwatcher config: " + name);
        }
        block17: for (Map.Entry entry : SolrXmlConfig.readNodeListAsNamedList(config, watcherPath, "<watcher>")) {
            name = (String)entry.getKey();
            value = entry.getValue().toString();
            switch (name) {
                case "size": {
                    watcherQueueSize = SolrXmlConfig.parseInt(name, value);
                    continue block17;
                }
                case "threshold": {
                    watcherThreshold = value;
                    continue block17;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown value in logwatcher config: " + name);
        }
        return new LogWatcherConfig(enabled, loggingClass, watcherThreshold, watcherQueueSize);
    }

    private static PluginInfo getShardHandlerFactoryPluginInfo(Config config) {
        Node node = config.getNode("solr/shardHandlerFactory", false);
        return node == null ? null : new PluginInfo(node, "shardHandlerFactory", false, true);
    }

    private static PluginInfo[] getBackupRepositoryPluginInfos(Config config) {
        NodeList nodes = (NodeList)config.evaluate("solr/backup/repository", XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return new PluginInfo[0];
        }
        PluginInfo[] configs = new PluginInfo[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            configs[i] = new PluginInfo(nodes.item(i), "BackupRepositoryFactory", true, true);
        }
        return configs;
    }

    private static PluginInfo[] getMetricReporterPluginInfos(Config config) {
        NodeList nodes = (NodeList)config.evaluate("solr/metrics/reporter", XPathConstants.NODESET);
        ArrayList<PluginInfo> configs = new ArrayList<PluginInfo>();
        if (nodes != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                PluginInfo info = new PluginInfo(nodes.item(i), "SolrMetricReporter", true, false);
                configs.add(info);
            }
        }
        return configs.toArray(new PluginInfo[configs.size()]);
    }

    private static PluginInfo getTransientCoreCacheFactoryPluginInfo(Config config) {
        Node node = config.getNode("solr/transientCoreCacheFactory", false);
        return node == null ? null : new PluginInfo(node, "transientCoreCacheFactory", false, true);
    }
}

