/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.graph.GatherNodesStream;
import org.apache.solr.client.solrj.io.graph.ShortestPathStream;
import org.apache.solr.client.solrj.io.graph.Traversal;
import org.apache.solr.client.solrj.io.ops.ConcatOperation;
import org.apache.solr.client.solrj.io.ops.DistinctOperation;
import org.apache.solr.client.solrj.io.ops.GroupOperation;
import org.apache.solr.client.solrj.io.ops.ReplaceOperation;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.ComplementStream;
import org.apache.solr.client.solrj.io.stream.DaemonStream;
import org.apache.solr.client.solrj.io.stream.ExceptionStream;
import org.apache.solr.client.solrj.io.stream.FacetStream;
import org.apache.solr.client.solrj.io.stream.HashJoinStream;
import org.apache.solr.client.solrj.io.stream.InnerJoinStream;
import org.apache.solr.client.solrj.io.stream.IntersectStream;
import org.apache.solr.client.solrj.io.stream.JDBCStream;
import org.apache.solr.client.solrj.io.stream.LeftOuterJoinStream;
import org.apache.solr.client.solrj.io.stream.MergeStream;
import org.apache.solr.client.solrj.io.stream.OuterHashJoinStream;
import org.apache.solr.client.solrj.io.stream.ParallelStream;
import org.apache.solr.client.solrj.io.stream.RandomStream;
import org.apache.solr.client.solrj.io.stream.RankStream;
import org.apache.solr.client.solrj.io.stream.ReducerStream;
import org.apache.solr.client.solrj.io.stream.RollupStream;
import org.apache.solr.client.solrj.io.stream.ScoreNodesStream;
import org.apache.solr.client.solrj.io.stream.SelectStream;
import org.apache.solr.client.solrj.io.stream.SortStream;
import org.apache.solr.client.solrj.io.stream.StatsStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TopicStream;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.UniqueStream;
import org.apache.solr.client.solrj.io.stream.UpdateStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.CountMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MaxMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MeanMetric;
import org.apache.solr.client.solrj.io.stream.metrics.MinMetric;
import org.apache.solr.client.solrj.io.stream.metrics.SumMetric;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.StreamHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    private StreamFactory streamFactory = new StreamFactory();
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String coreName;

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    @Override
    public void inform(SolrCore core) {
        CoreContainer coreContainer = core.getCoreContainer();
        this.coreName = core.getName();
        if (coreContainer.isZooKeeperAware()) {
            String defaultCollection = core.getCoreDescriptor().getCollectionName();
            String defaultZkhost = core.getCoreContainer().getZkController().getZkServerAddress();
            this.streamFactory.withCollectionZkHost(defaultCollection, defaultZkhost);
            this.streamFactory.withDefaultZkHost(defaultZkhost);
        }
        this.streamFactory.withFunctionName("search", CloudSolrStream.class).withFunctionName("merge", MergeStream.class).withFunctionName("unique", UniqueStream.class).withFunctionName("top", RankStream.class).withFunctionName("group", GroupOperation.class).withFunctionName("reduce", ReducerStream.class).withFunctionName("parallel", ParallelStream.class).withFunctionName("rollup", RollupStream.class).withFunctionName("stats", StatsStream.class).withFunctionName("innerJoin", InnerJoinStream.class).withFunctionName("leftOuterJoin", LeftOuterJoinStream.class).withFunctionName("hashJoin", HashJoinStream.class).withFunctionName("outerHashJoin", OuterHashJoinStream.class).withFunctionName("facet", FacetStream.class).withFunctionName("update", UpdateStream.class).withFunctionName("jdbc", JDBCStream.class).withFunctionName("intersect", IntersectStream.class).withFunctionName("select", SelectStream.class).withFunctionName("complement", ComplementStream.class).withFunctionName("daemon", DaemonStream.class).withFunctionName("topic", TopicStream.class).withFunctionName("shortestPath", ShortestPathStream.class).withFunctionName("gatherNodes", GatherNodesStream.class).withFunctionName("nodes", GatherNodesStream.class).withFunctionName("sort", SortStream.class).withFunctionName("scoreNodes", ScoreNodesStream.class).withFunctionName("random", RandomStream.class).withFunctionName("min", MinMetric.class).withFunctionName("max", MaxMetric.class).withFunctionName("avg", MeanMetric.class).withFunctionName("sum", SumMetric.class).withFunctionName("count", CountMetric.class).withFunctionName("replace", ReplaceOperation.class).withFunctionName("concat", ConcatOperation.class).withFunctionName("group", GroupOperation.class).withFunctionName("distinct", DistinctOperation.class);
        Object functionMappingsObj = this.initArgs.get("streamFunctions");
        if (null != functionMappingsObj) {
            NamedList functionMappings = (NamedList)functionMappingsObj;
            for (Map.Entry functionMapping : functionMappings) {
                Class<Expressible> clazz = core.getResourceLoader().findClass((String)functionMapping.getValue(), Expressible.class);
                this.streamFactory.withFunctionName((String)functionMapping.getKey(), clazz);
            }
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        params = this.adjustParams(params);
        req.setParams(params);
        TupleStream tupleStream = null;
        try {
            tupleStream = this.streamFactory.constructStream(params.get("expr"));
        }
        catch (Exception e) {
            SolrException.log((Logger)logger, (Throwable)e);
            Map<Object, Object> requestContext = req.getContext();
            requestContext.put("stream", (Object)new DummyErrorStream(e));
            return;
        }
        StreamContext context = new StreamContext();
        context.setSolrClientCache(StreamHandler.clientCache);
        context.put((Object)"core", (Object)this.coreName);
        Traversal traversal = new Traversal();
        context.put((Object)"traversal", (Object)traversal);
        tupleStream.setStreamContext(context);
        Map<Object, Object> requestContext = req.getContext();
        requestContext.put("stream", (Object)new TimerStream((TupleStream)new ExceptionStream(tupleStream)));
        requestContext.put("traversal", traversal);
    }

    @Override
    public String getDescription() {
        return "StreamHandler";
    }

    @Override
    public String getSource() {
        return null;
    }

    private SolrParams adjustParams(SolrParams params) {
        ModifiableSolrParams adjustedParams = new ModifiableSolrParams();
        adjustedParams.add(params);
        adjustedParams.add("omitHeader", new String[]{"true"});
        return adjustedParams;
    }

    public static class TimerStream
    extends TupleStream {
        private long begin;
        private TupleStream tupleStream;

        public TimerStream(TupleStream tupleStream) {
            this.tupleStream = tupleStream;
        }

        public StreamComparator getStreamSort() {
            return this.tupleStream.getStreamSort();
        }

        public void close() throws IOException {
            this.tupleStream.close();
        }

        public void open() throws IOException {
            this.begin = System.nanoTime();
            this.tupleStream.open();
        }

        public void setStreamContext(StreamContext context) {
            this.tupleStream.setStreamContext(context);
        }

        public List<TupleStream> children() {
            return this.tupleStream.children();
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return null;
        }

        public Tuple read() throws IOException {
            Tuple tuple = this.tupleStream.read();
            if (tuple.EOF) {
                long totalTime = (System.nanoTime() - this.begin) / 1000000L;
                tuple.fields.put("RESPONSE_TIME", totalTime);
            }
            return tuple;
        }
    }

    public static class DummyErrorStream
    extends TupleStream {
        private Exception e;

        public DummyErrorStream(Exception e) {
            this.e = e;
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public Exception getException() {
            return this.e;
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return null;
        }

        public Tuple read() {
            String msg = this.e.getMessage();
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("EOF", true);
            m.put("EXCEPTION", msg);
            return new Tuple(m);
        }
    }
}

