/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.UpdateRequestHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class UpdateRequestHandlerApi
extends UpdateRequestHandler {
    private static final Map<String, String> mapping = ImmutableMap.builder().put((Object)"/update", (Object)"/update/json/docs").put((Object)"/update/json", (Object)"/update/json/docs").put((Object)"/update/json/commands", (Object)"/update/json").build();

    @Override
    public Collection<Api> getApis() {
        return Collections.singleton(this.getApiImpl());
    }

    private Api getApiImpl() {
        return new Api(ApiBag.getSpec("core.Update")){

            @Override
            public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
                String path = req.getPath();
                String target = (String)mapping.get(path);
                if (target != null) {
                    req.getContext().put("path", target);
                }
                try {
                    UpdateRequestHandlerApi.this.handleRequest(req, rsp);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
            }
        };
    }

    @Override
    public Boolean registerV1() {
        return Boolean.FALSE;
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }
}

