/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.update.SplitIndexCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SplitOp
implements CoreAdminHandler.CoreAdminOp {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    SplitOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        ArrayList<DocRouter.Range> ranges = null;
        String[] pathsArr = params.getParams("path");
        String rangesStr = params.get("ranges");
        if (rangesStr != null) {
            String[] rangesArr = rangesStr.split(",");
            if (rangesArr.length == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There must be at least one range specified to split an index");
            }
            ranges = new ArrayList<DocRouter.Range>(rangesArr.length);
            for (String r : rangesArr) {
                try {
                    ranges.add(DocRouter.DEFAULT.fromString(r));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception parsing hexadecimal hash range: " + r, (Throwable)e);
                }
            }
        }
        String splitKey = params.get("split.key");
        String[] newCoreNames = params.getParams("targetCore");
        String cname = params.get("core", "");
        if (!(pathsArr != null && pathsArr.length != 0 || newCoreNames != null && newCoreNames.length != 0)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either path or targetCore param must be specified");
        }
        log.info("Invoked split action for core: " + cname);
        SolrCore core = it.handler.coreContainer.getCore(cname);
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, params);
        ArrayList<SolrCore> newCores = null;
        try {
            Object paths = null;
            int partitions = pathsArr != null ? pathsArr.length : newCoreNames.length;
            DocRouter router = null;
            String routeFieldName = null;
            if (it.handler.coreContainer.isZooKeeperAware()) {
                Object routerObj;
                String[] clusterState = it.handler.coreContainer.getZkController().getClusterState();
                String collectionName = req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName();
                DocCollection collection = clusterState.getCollection(collectionName);
                String sliceName = req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
                Slice slice = collection.getSlice(sliceName);
                DocRouter docRouter = router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
                if (ranges == null) {
                    DocRouter.Range currentRange = slice.getRange();
                    ArrayList<DocRouter.Range> arrayList = ranges = currentRange != null ? router.partitionRange(partitions, currentRange) : null;
                }
                if ((routerObj = collection.get("router")) != null && routerObj instanceof Map) {
                    Map routerProps = (Map)routerObj;
                    routeFieldName = (String)routerProps.get("field");
                }
            }
            if (pathsArr == null) {
                newCores = new ArrayList<SolrCore>(partitions);
                for (String newCoreName : newCoreNames) {
                    SolrCore newcore = it.handler.coreContainer.getCore(newCoreName);
                    if (newcore == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core with core name " + newCoreName + " expected but doesn't exist.");
                    }
                    newCores.add(newcore);
                }
            } else {
                paths = Arrays.asList(pathsArr);
            }
            SplitIndexCommand cmd = new SplitIndexCommand(req, (List<String>)paths, (List<SolrCore>)newCores, (List<DocRouter.Range>)ranges, router, routeFieldName, splitKey);
            core.getUpdateHandler().split(cmd);
        }
        catch (Exception e) {
            log.error("ERROR executing split:", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (req != null) {
                req.close();
            }
            if (core != null) {
                core.close();
            }
            if (newCores != null) {
                for (SolrCore newCore : newCores) {
                    newCore.close();
                }
            }
        }
    }
}

