/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.component.DebugComponent;
import org.apache.solr.handler.component.ExpandComponent;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.handler.component.MoreLikeThisComponent;
import org.apache.solr.handler.component.QueryComponent;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.StatsComponent;
import org.apache.solr.handler.component.TermsComponent;
import org.apache.solr.search.facet.FacetModule;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public abstract class SearchComponent
implements SolrInfoMBean,
NamedListInitializedPlugin {
    private String name = this.getClass().getName();
    public static final Map<String, Class<? extends SearchComponent>> standard_components;

    public abstract void prepare(ResponseBuilder var1) throws IOException;

    public abstract void process(ResponseBuilder var1) throws IOException;

    public int distributedProcess(ResponseBuilder rb) throws IOException {
        return ResponseBuilder.STAGE_DONE;
    }

    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
    }

    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
    }

    public void finishStage(ResponseBuilder rb) {
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void init(NamedList args) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract String getDescription();

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public String getVersion() {
        return this.getClass().getPackage().getSpecificationVersion();
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.OTHER;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        return null;
    }

    static {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("highlight", HighlightComponent.class);
        map.put("query", QueryComponent.class);
        map.put("facet", FacetComponent.class);
        map.put("facet_module", FacetModule.class);
        map.put("mlt", MoreLikeThisComponent.class);
        map.put("stats", StatsComponent.class);
        map.put("debug", DebugComponent.class);
        map.put("get", RealTimeGetComponent.class);
        map.put("expand", ExpandComponent.class);
        map.put("terms", TermsComponent.class);
        standard_components = Collections.unmodifiableMap(map);
    }
}

