/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.FastLRUCache;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.stats.CollectionStats;
import org.apache.solr.search.stats.ExactStatsCache;
import org.apache.solr.search.stats.StatsSource;
import org.apache.solr.search.stats.StatsUtil;
import org.apache.solr.search.stats.TermStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUStatsCache
extends ExactStatsCache {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, SolrCache<String, TermStats>> perShardTermStats = new ConcurrentHashMap<String, SolrCache<String, TermStats>>();
    private final Map<String, Map<String, CollectionStats>> perShardColStats = new ConcurrentHashMap<String, Map<String, CollectionStats>>();
    private final FastLRUCache<String, TermStats> currentGlobalTermStats = new FastLRUCache();
    private final Map<String, CollectionStats> currentGlobalColStats = new ConcurrentHashMap<String, CollectionStats>();
    private final Map lruCacheInitArgs = new HashMap();

    @Override
    public StatsSource get(SolrQueryRequest req) {
        LOG.debug("## GET total={}, cache {}", this.currentGlobalColStats, (Object)this.currentGlobalTermStats.size());
        return new LRUStatsSource(this.currentGlobalTermStats, this.currentGlobalColStats);
    }

    @Override
    public void init(PluginInfo info) {
        this.lruCacheInitArgs.put("size", "100");
        this.currentGlobalTermStats.init(this.lruCacheInitArgs, null, null);
    }

    @Override
    protected void addToGlobalTermStats(SolrQueryRequest req, Map.Entry<String, TermStats> e) {
        this.currentGlobalTermStats.put(e.getKey(), e.getValue());
    }

    @Override
    protected void addToPerShardColStats(SolrQueryRequest req, String shard, Map<String, CollectionStats> colStats) {
        this.perShardColStats.put(shard, colStats);
    }

    @Override
    protected Map<String, CollectionStats> getPerShardColStats(ResponseBuilder rb, String shard) {
        return this.perShardColStats.get(shard);
    }

    @Override
    protected void addToPerShardTermStats(SolrQueryRequest req, String shard, String termStatsString) {
        Map<String, TermStats> termStats = StatsUtil.termStatsMapFromString(termStatsString);
        if (termStats != null) {
            SolrCache<String, TermStats> cache = this.perShardTermStats.get(shard);
            if (cache == null) {
                cache = new FastLRUCache<String, TermStats>();
                cache.init(this.lruCacheInitArgs, null, null);
                this.perShardTermStats.put(shard, cache);
            }
            for (Map.Entry<String, TermStats> e : termStats.entrySet()) {
                cache.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    protected TermStats getPerShardTermStats(SolrQueryRequest req, String t, String shard) {
        SolrCache<String, TermStats> cache = this.perShardTermStats.get(shard);
        return cache != null ? cache.get(t) : null;
    }

    @Override
    protected void addToGlobalColStats(SolrQueryRequest req, Map.Entry<String, CollectionStats> e) {
        this.currentGlobalColStats.put(e.getKey(), e.getValue());
    }

    @Override
    protected void printStats(SolrQueryRequest req) {
        LOG.debug("## MERGED: perShardColStats={}, perShardTermStats={}", this.perShardColStats, this.perShardTermStats);
    }

    static class LRUStatsSource
    extends StatsSource {
        private final SolrCache<String, TermStats> termStatsCache;
        private final Map<String, CollectionStats> colStatsCache;

        public LRUStatsSource(SolrCache<String, TermStats> termStatsCache, Map<String, CollectionStats> colStatsCache) {
            this.termStatsCache = termStatsCache;
            this.colStatsCache = colStatsCache;
        }

        @Override
        public TermStatistics termStatistics(SolrIndexSearcher localSearcher, Term term, TermContext context) throws IOException {
            TermStats termStats = this.termStatsCache.get(term.toString());
            if (termStats == null) {
                LOG.debug("## Missing global termStats info: {}, using local", (Object)term.toString());
                return localSearcher.localTermStatistics(term, context);
            }
            return termStats.toTermStatistics();
        }

        @Override
        public CollectionStatistics collectionStatistics(SolrIndexSearcher localSearcher, String field) throws IOException {
            CollectionStats colStats = this.colStatsCache.get(field);
            if (colStats == null) {
                LOG.debug("## Missing global colStats info: {}, using local", (Object)field);
                return localSearcher.localCollectionStatistics(field);
            }
            return colStats.toCollectionStatistics();
        }
    }
}

